/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.vcs.github.ultimate.i18n.GithubUltimateBundle;
import com.intellij.vcs.github.ultimate.ide.inspections.ActionInspectionsUtilKt;
import com.intellij.vcs.github.ultimate.ide.inspections.BaseGitHubActionInspection;
import com.intellij.vcs.github.ultimate.ide.intentions.ReloadActionIntention;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/github/ultimate/ide/inspections/UndefinedParamsPresentInspection;", "Lcom/intellij/vcs/github/ultimate/ide/inspections/BaseGitHubActionInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RemoveUndefinedParameterQuickFix", "intellij.vcs.github.ultimate"})
public final class UndefinedParamsPresentInspection
extends BaseGitHubActionInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new YamlPsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                YAMLSequenceItem yAMLSequenceItem;
                String paramName;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
                        if (!ActionInspectionsUtilKt.getStepParamPattern().accepts((Object)keyValue)) {
                            return;
                        }
                        String string = keyValue.getKeyText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
                        paramName = string;
                        PsiElement $this$parentOfType_u24default$iv = (PsiElement)keyValue;
                        boolean withSelf$iv = false;
                        boolean $i$f$parentOfType = false;
                        yAMLSequenceItem = (YAMLSequenceItem)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLSequenceItem.class, (boolean)true);
                        if (yAMLSequenceItem == null) break block5;
                        YAMLSequenceItem it = yAMLSequenceItem;
                        boolean bl = false;
                        YAMLKeyValue yAMLKeyValue = ActionInspectionsUtilKt.findActionReference(it);
                        yAMLSequenceItem = yAMLKeyValue;
                        if (yAMLKeyValue != null) break block6;
                    }
                    return;
                }
                YAMLSequenceItem actionReference2 = yAMLSequenceItem;
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Set<String> definedActionInputs = ActionInspectionsUtilKt.getActionInputs(project, (YAMLKeyValue)actionReference2).keySet();
                boolean isDefined = definedActionInputs.contains(paramName);
                if (!isDefined) {
                    Object[] objectArray = new Object[]{paramName};
                    String string = GithubUltimateBundle.message("github.action.inspection.message.undefined.parameter", objectArray);
                    objectArray = new LocalQuickFix[]{new RemoveUndefinedParameterQuickFix(paramName), new ReloadActionIntention()};
                    this.$holder.registerProblem((PsiElement)keyValue, string, (LocalQuickFix[])objectArray);
                }
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/github/ultimate/ide/inspections/UndefinedParamsPresentInspection$RemoveUndefinedParameterQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "paramNameToRemove", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.vcs.github.ultimate"})
    public static final class RemoveUndefinedParameterQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String paramNameToRemove;

        public RemoveUndefinedParameterQuickFix(@NotNull String paramNameToRemove) {
            Intrinsics.checkNotNullParameter((Object)paramNameToRemove, (String)"paramNameToRemove");
            this.paramNameToRemove = paramNameToRemove;
        }

        @NotNull
        public String getFamilyName() {
            String string = GithubUltimateBundle.message("github.action.intention.family.name.remove.undefined.parameter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                YAMLSequenceItem yAMLSequenceItem = (YAMLSequenceItem)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), YAMLSequenceItem.class);
                if (yAMLSequenceItem == null) {
                    return;
                }
                YAMLSequenceItem stepYamlItemSequence = yAMLSequenceItem;
                YAMLKeyValue yAMLKeyValue = ActionInspectionsUtilKt.getStepParams(stepYamlItemSequence);
                if (yAMLKeyValue == null) {
                    return;
                }
                YAMLKeyValue actionParamsList = yAMLKeyValue;
                if (!(actionParamsList.getValue() instanceof YAMLMapping)) {
                    return;
                }
                YAMLValue yAMLValue = actionParamsList.getValue();
                Intrinsics.checkNotNull((Object)yAMLValue, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLMapping");
                YAMLMapping actionParams = (YAMLMapping)yAMLValue;
                YAMLKeyValue yAMLKeyValue2 = actionParams.getKeyValueByKey(this.paramNameToRemove);
                if (yAMLKeyValue2 == null) break block3;
                YAMLKeyValue it = yAMLKeyValue2;
                boolean bl = false;
                actionParams.deleteKeyValue(it);
            }
        }
    }
}

