/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.expression.editor;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.vcs.github.ultimate.expression.editor.GithubExpressionFunctionSignatureValidationInspection;
import com.intellij.vcs.github.ultimate.expression.psi.GAEExpression;
import com.intellij.vcs.github.ultimate.expression.psi.GAEFunctionCallExpression;
import com.intellij.vcs.github.ultimate.expression.psi.GAEVisitor;
import com.intellij.vcs.github.ultimate.expression.stdlib.GithubExpressionStdLibEntry;
import com.intellij.vcs.github.ultimate.i18n.GithubUltimateBundle;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/github/ultimate/expression/editor/GithubExpressionFunctionSignatureValidationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "stdLibEntriesMap", "", "", "Lcom/intellij/vcs/github/ultimate/expression/stdlib/GithubExpressionStdLibEntry;", "getStdLibEntriesMap", "()Ljava/util/Map;", "stdLibEntriesMap$delegate", "Lkotlin/Lazy;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "highlightExtraArguments", "", "callExpression", "Lcom/intellij/vcs/github/ultimate/expression/psi/GAEFunctionCallExpression;", "functionMeta", "Lcom/intellij/vcs/github/ultimate/expression/stdlib/GithubExpressionStdLibEntry$FunctionWithExactParametersNumber;", "actualArgumentsNumber", "", "highlightMissingArguments", "highlightUnresolvedMethodCall", "intellij.vcs.github.ultimate"})
public final class GithubExpressionFunctionSignatureValidationInspection
extends LocalInspectionTool {
    @NotNull
    private final Lazy stdLibEntriesMap$delegate = LazyKt.lazy((Function0)stdLibEntriesMap.2.INSTANCE);

    private final Map<String, GithubExpressionStdLibEntry> getStdLibEntriesMap() {
        Lazy lazy = this.stdLibEntriesMap$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new GAEVisitor(this, holder){
            final /* synthetic */ GithubExpressionFunctionSignatureValidationInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunctionCallExpression(@NotNull GAEFunctionCallExpression callExpression) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                int actualArgumentsNumber = callExpression.getExpressionList().size();
                GithubExpressionStdLibEntry functionMeta = (GithubExpressionStdLibEntry)GithubExpressionFunctionSignatureValidationInspection.access$getStdLibEntriesMap(this.this$0).get(callExpression.getName());
                if (functionMeta == null) {
                    GithubExpressionFunctionSignatureValidationInspection.access$highlightUnresolvedMethodCall(this.this$0, callExpression, this.$holder);
                } else if (functionMeta instanceof GithubExpressionStdLibEntry.FunctionWithExactParametersNumber && actualArgumentsNumber < ((GithubExpressionStdLibEntry.FunctionWithExactParametersNumber)functionMeta).getParametersNumber()) {
                    GithubExpressionFunctionSignatureValidationInspection.access$highlightMissingArguments(this.this$0, callExpression, (GithubExpressionStdLibEntry.FunctionWithExactParametersNumber)functionMeta, actualArgumentsNumber, this.$holder);
                } else if (functionMeta instanceof GithubExpressionStdLibEntry.FunctionWithExactParametersNumber && actualArgumentsNumber > ((GithubExpressionStdLibEntry.FunctionWithExactParametersNumber)functionMeta).getParametersNumber()) {
                    GithubExpressionFunctionSignatureValidationInspection.access$highlightExtraArguments(this.this$0, callExpression, (GithubExpressionStdLibEntry.FunctionWithExactParametersNumber)functionMeta, actualArgumentsNumber, this.$holder);
                }
            }
        };
    }

    private final void highlightUnresolvedMethodCall(GAEFunctionCallExpression callExpression, ProblemsHolder holder) {
        holder.registerProblem(callExpression.getIdentifier(), GithubUltimateBundle.message("github.action.inspections.std.lib.validation.unknown.function", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
    }

    private final void highlightMissingArguments(GAEFunctionCallExpression callExpression, GithubExpressionStdLibEntry.FunctionWithExactParametersNumber functionMeta, int actualArgumentsNumber, ProblemsHolder holder) {
        int closingBraceOffset = RangesKt.coerceAtLeast((int)(callExpression.getTextRange().getEndOffset() - 1), (int)0);
        int functionCallEndOffset = callExpression.getTextRange().getEndOffset();
        Object[] objectArray = new Object[]{functionMeta.getParametersNumber(), actualArgumentsNumber};
        holder.registerProblem((PsiElement)callExpression, GithubUltimateBundle.message("github.action.inspections.std.lib.validation.incorrect.arguments.count", objectArray), ProblemHighlightType.WARNING, TextRange.create((int)closingBraceOffset, (int)functionCallEndOffset).shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)callExpression)), new LocalQuickFix[0]);
    }

    private final void highlightExtraArguments(GAEFunctionCallExpression callExpression, GithubExpressionStdLibEntry.FunctionWithExactParametersNumber functionMeta, int actualArgumentsNumber, ProblemsHolder holder) {
        int n;
        TextRange textRange;
        int n2;
        Object[] objectArray;
        GAEExpression gAEExpression = callExpression.getExpressionList().get(functionMeta.getParametersNumber());
        if (gAEExpression != null && (objectArray = gAEExpression.getTextRange()) != null) {
            n2 = objectArray.getStartOffset();
        } else {
            PsiElement psiElement = callExpression.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getIdentifier(...)");
            n2 = PsiTreeUtilKt.getStartOffset((PsiElement)psiElement);
        }
        int extraArgumentsStartOffset = n2;
        List<GAEExpression> list = callExpression.getExpressionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionList(...)");
        objectArray = (GAEExpression)CollectionsKt.lastOrNull(list);
        if (objectArray != null && (textRange = objectArray.getTextRange()) != null) {
            n = textRange.getEndOffset();
        } else {
            PsiElement psiElement = callExpression.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getIdentifier(...)");
            n = PsiTreeUtilKt.getEndOffset((PsiElement)psiElement);
        }
        int extraArgumentsEndOffset = n;
        objectArray = new Object[]{functionMeta.getParametersNumber(), actualArgumentsNumber};
        holder.registerProblem((PsiElement)callExpression, GithubUltimateBundle.message("github.action.inspections.std.lib.validation.incorrect.arguments.count", objectArray), ProblemHighlightType.WARNING, TextRange.create((int)extraArgumentsStartOffset, (int)extraArgumentsEndOffset).shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)callExpression)), new LocalQuickFix[0]);
    }

    public static final /* synthetic */ Map access$getStdLibEntriesMap(GithubExpressionFunctionSignatureValidationInspection $this) {
        return $this.getStdLibEntriesMap();
    }

    public static final /* synthetic */ void access$highlightUnresolvedMethodCall(GithubExpressionFunctionSignatureValidationInspection $this, GAEFunctionCallExpression callExpression, ProblemsHolder holder) {
        $this.highlightUnresolvedMethodCall(callExpression, holder);
    }

    public static final /* synthetic */ void access$highlightMissingArguments(GithubExpressionFunctionSignatureValidationInspection $this, GAEFunctionCallExpression callExpression, GithubExpressionStdLibEntry.FunctionWithExactParametersNumber functionMeta, int actualArgumentsNumber, ProblemsHolder holder) {
        $this.highlightMissingArguments(callExpression, functionMeta, actualArgumentsNumber, holder);
    }

    public static final /* synthetic */ void access$highlightExtraArguments(GithubExpressionFunctionSignatureValidationInspection $this, GAEFunctionCallExpression callExpression, GithubExpressionStdLibEntry.FunctionWithExactParametersNumber functionMeta, int actualArgumentsNumber, ProblemsHolder holder) {
        $this.highlightExtraArguments(callExpression, functionMeta, actualArgumentsNumber, holder);
    }
}

