/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.cache.metadata;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadata;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadataFactory$special$;
import com.intellij.vcs.github.ultimate.context.ActionYamlPatternsKt;
import com.intellij.vcs.github.ultimate.context.handler.InputsContext;
import com.intellij.vcs.github.ultimate.context.handler.StepsOutputsContext;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "descriptionPattern", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createDescription", "", "actionMetadata", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadata;", "actionFile", "createMetadata", "psiFile", "Lcom/intellij/psi/PsiFile;", "generateMetadataFromPsi", "url", "", "resolveInputs", "resolveOutputs", "intellij.vcs.github.ultimate"})
@SourceDebugExtension(value={"SMAP\nGitHubActionMetadataFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubActionMetadataFactory.kt\ncom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory\n+ 2 ActionYamlPatterns.kt\ncom/intellij/vcs/github/ultimate/context/ActionYamlPatternsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,68:1\n46#2:69\n38#2,7:70\n20#2,8:77\n55#3:85\n34#3,2:86\n288#4,2:88\n1179#4,2:92\n1253#4,4:94\n1179#4,2:101\n1253#4,4:103\n1313#5:90\n1314#5:98\n1313#5:99\n1314#5:107\n436#6:91\n436#6:100\n*S KotlinDebug\n*F\n+ 1 GitHubActionMetadataFactory.kt\ncom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory\n*L\n18#1:69\n18#1:70,7\n18#1:77,8\n22#1:85\n22#1:86,2\n37#1:88,2\n46#1:92,2\n46#1:94,4\n60#1:101,2\n60#1:103,4\n44#1:90\n44#1:98\n58#1:99\n58#1:107\n46#1:91\n60#1:100\n*E\n"})
public final class GitHubActionMetadataFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiElementPattern.Capture<PsiElement> descriptionPattern;

    /*
     * WARNING - void declaration
     */
    public GitHubActionMetadataFactory(@NotNull Project project) {
        void keyTextValue$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String[] stringArray = new String[]{"description"};
        boolean $i$f$yamlKeysPattern = false;
        List keys$iv$iv = ArraysKt.toList((Object[])keyTextValue$iv);
        boolean $i$f$yamlKeysPattern2 = false;
        boolean $i$f$yamlKeysPatternCondition = false;
        ObjectPattern objectPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>(){

            public boolean accepts(@NotNull PsiElement element, @Nullable ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return GithubYamlFileDetectionKt.isGithubActionsFile(element.getContainingFile());
            }
        })).with((PatternCondition)new PatternCondition<PsiElement>(keys$iv$iv){
            @NotNull
            private final List<Regex> regexList;
            {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = $keys;
                special$$inlined$yamlKeysPattern$1 var3_3 = this;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Regex((String)it));
                }
                var3_3.regexList = (List)destination$iv$iv;
            }

            @NotNull
            public final List<Regex> getRegexList() {
                return this.regexList;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accepts(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                CharSequence charSequence;
                Regex it;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!(element instanceof YAMLKeyValue)) return false;
                Iterable $this$any$iv = this.regexList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    it = (Regex)element$iv;
                    boolean bl = false;
                    charSequence = StringUtil.newBombedCharSequence((CharSequence)ActionYamlPatternsKt.fullYamlKey(element), (long)1000L);
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
                } while (!it.matches(charSequence));
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        this.descriptionPattern = (PsiElementPattern.Capture)objectPattern;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GitHubActionMetadata createMetadata(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Object object = psiFile.getVirtualFile();
        if (object == null || (object = object.getUrl()) == null) {
            object = "";
        }
        Object url = object;
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Creating action metadata from psi file Action file URL = " + (String)url + "\n Psi file: code=" + psiFile.hashCode() + " timestamp=" + psiFile.getModificationStamp());
        return this.generateMetadataFromPsi((String)url, psiFile);
    }

    private final GitHubActionMetadata generateMetadataFromPsi(String url, PsiFile psiFile) {
        GitHubActionMetadata actionMetadata = new GitHubActionMetadata(url);
        this.createDescription(actionMetadata, (PsiElement)psiFile);
        this.resolveInputs(actionMetadata, (PsiElement)psiFile);
        this.resolveOutputs(actionMetadata, (PsiElement)psiFile);
        return actionMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private final void createDescription(GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        Object v1;
        block1: {
            void $this$firstOrNull$iv;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)actionFile);
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
            Iterable iterable = (Iterable)syntaxTraverser;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement psiElement = (PsiElement)element$iv;
                boolean bl = false;
                if (!this.descriptionPattern.accepts((Object)psiElement)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        Object var5_9 = v1;
        YAMLKeyValue yAMLKeyValue = var5_9 instanceof YAMLKeyValue ? (YAMLKeyValue)var5_9 : null;
        String description = yAMLKeyValue != null ? yAMLKeyValue.getValueText() : null;
        actionMetadata.setDescription(description);
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveInputs(GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        Sequence<YAMLKeyValue> $this$forEach$iv = InputsContext.INSTANCE.getResolver().getReferenceCandidates(actionFile);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            void $this$associateTo$iv$iv;
            YAMLKeyValue element = (YAMLKeyValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)element.getKeyText(), (String)"getKeyText(...)");
            YAMLValue yAMLValue = element.getValue();
            Object object = yAMLValue;
            if (object == null) continue;
            Intrinsics.checkNotNull((Object)object);
            PsiElement $this$childrenOfType$iv = (PsiElement)yAMLValue;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLKeyValue.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            object = list;
            if (list == null) continue;
            Iterable $this$associate$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Object object2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                boolean bl2 = false;
                Pair pair = new Pair((Object)it.getKeyText(), (Object)it.getValueText());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map dataMap = destination$iv$iv;
            boolean bl3 = false;
            boolean bl4 = Boolean.parseBoolean((String)dataMap.get("required"));
            String string = (String)dataMap.get("description");
            if (string == null) {
                string = "";
            }
            object2 = string;
            Intrinsics.checkNotNull((Object)object2);
            GitHubActionMetadata.Input input = new GitHubActionMetadata.Input(name, bl4, (String)object2, (String)dataMap.get("default"), (String)dataMap.get("deprecationMessage"));
            ((Map)actionMetadata.getInputs()).put(name, input);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveOutputs(GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        Sequence<YAMLKeyValue> $this$forEach$iv = StepsOutputsContext.INSTANCE.getResolver().getReferenceCandidates(actionFile);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            String string;
            void $this$associateTo$iv$iv;
            YAMLKeyValue element = (YAMLKeyValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)element.getKeyText(), (String)"getKeyText(...)");
            YAMLValue yAMLValue = element.getValue();
            Object object = yAMLValue;
            if (object == null) continue;
            Intrinsics.checkNotNull((Object)object);
            PsiElement $this$childrenOfType$iv = (PsiElement)yAMLValue;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLKeyValue.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            object = list;
            if (list == null) continue;
            Iterable $this$associate$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Object object2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                boolean bl2 = false;
                Pair pair = new Pair((Object)it.getKeyText(), (Object)it.getValueText());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map dataMap = destination$iv$iv;
            boolean bl3 = false;
            String string2 = (String)dataMap.get("value");
            if (string2 == null) {
                string2 = "";
            }
            if ((string = (String)dataMap.get("description")) == null) {
                string = "";
            }
            object2 = string;
            Intrinsics.checkNotNull((Object)object2);
            GitHubActionMetadata.Output output = new GitHubActionMetadata.Output(name, string2, (String)object2);
            ((Map)actionMetadata.getOutputs()).put(name, output);
        }
    }
}

