/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J.\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookCellTagLabel;", "Ljavax/swing/JLabel;", "tag", "", "cellNum", "", "(Ljava/lang/String;I)V", "backgroundColor", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getCellNum", "()I", "foregroundColor", "kotlin.jvm.PlatformType", "getTag", "()Ljava/lang/String;", "createPopupGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "showPopup", "popupBuilder", "Lkotlin/Function0;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "component", "Ljava/awt/Component;", "x", "y", "Companion", "intellij.notebooks.ui"})
public final class NotebookCellTagLabel
extends JLabel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    private final int cellNum;
    @NotNull
    private JBColor backgroundColor;
    private JBColor foregroundColor;
    private static final int TEXT_VERTICAL_PADDING = JBUI.scale((int)2);
    private static final int TEXT_HORIZONTAL_PADDING = JBUI.scale((int)8);
    private static final int ARC_SIZE = JBUI.scale((int)20);
    @NotNull
    private static final String ACTION_ID = "JupyterCellRemoveTagAction";

    public NotebookCellTagLabel(@NlsSafe @NotNull String tag, int cellNum) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super(tag);
        this.tag = tag;
        this.cellNum = cellNum;
        JBColor jBColor = JBColor.namedColor((String)"Tag.background", (Color)((Color)Gray.xDF));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        this.backgroundColor = jBColor;
        this.foregroundColor = JBColor.BLACK;
        this.setFont((Font)JBFont.small());
        this.setForeground((Color)this.foregroundColor);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(TEXT_VERTICAL_PADDING, TEXT_HORIZONTAL_PADDING, TEXT_VERTICAL_PADDING, TEXT_HORIZONTAL_PADDING));
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                this.showPopup((Function0<? extends ActionGroup>)((Function0)new Function0<ActionGroup>(this){
                    final /* synthetic */ NotebookCellTagLabel this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final ActionGroup invoke() {
                        return (ActionGroup)NotebookCellTagLabel.access$createPopupGroup(this.this$0);
                    }
                }), comp, x, y);
            }
        });
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    public final int getCellNum() {
        return this.cellNum;
    }

    private final void showPopup(Function0<? extends ActionGroup> popupBuilder, Component component, int x, int y) {
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", (ActionGroup)popupBuilder.invoke());
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        ActionPopupMenu popupMenu = actionPopupMenu;
        popupMenu.getComponent().show(component, x, y);
    }

    private final DefaultActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction action = ActionManager.getInstance().getAction(ACTION_ID);
        group.add(action);
        return group;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D graphics2D = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (graphics2D != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setColor((Color)this.backgroundColor);
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), ARC_SIZE, ARC_SIZE);
        FontMetrics fm = g.getFontMetrics();
        int textHeight = fm.getHeight();
        int textWidth = fm.stringWidth(this.getText());
        int textX = (this.getWidth() - textWidth) / 2;
        int textY = (this.getHeight() - textHeight) / 2 + fm.getAscent();
        g.setColor((Color)this.foregroundColor);
        g.drawString(this.getText(), textX, textY);
    }

    public static final /* synthetic */ DefaultActionGroup access$createPopupGroup(NotebookCellTagLabel $this) {
        return $this.createPopupGroup();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookCellTagLabel$Companion;", "", "()V", "ACTION_ID", "", "ARC_SIZE", "", "TEXT_HORIZONTAL_PADDING", "TEXT_VERTICAL_PADDING", "intellij.notebooks.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

