/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookBelowCellDelimiterPanel;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookCellTagLabel;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r*\u0001+\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0011J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u001d\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0002J!\u00101\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u00102\u001a\u0004\u0018\u00010\bH\u0003\u00a2\u0006\u0002\u00103J\u0017\u00104\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u00105J\"\u00106\u001a\u0002072\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b09H\u0002J*\u0010:\u001a\u0002072\b\u0010;\u001a\u0004\u0018\u00010\u00182\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b09J\u0006\u0010<\u001a\u00020\nJ\b\u0010=\u001a\u000207H\u0002J\u0012\u0010>\u001a\u00020\u001a2\b\b\u0001\u0010?\u001a\u00020\bH\u0002J7\u0010@\u001a\u0002072\n\b\u0001\u0010A\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010B\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010C\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u000207H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "isExecutable", "", "cellTags", "", "", "cellNum", "", "isRenderedMarkdown", "executionCount", "initStatusIcon", "Ljavax/swing/Icon;", "initTooltipText", "initExecutionDurationText", "(Lcom/intellij/openapi/editor/impl/EditorImpl;ZLjava/util/List;IZLjava/lang/Integer;Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;)V", "getCellNum", "()I", "delimiterHeight", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "elapsedStartTime", "Ljava/time/ZonedDateTime;", "executionLabel", "Ljavax/swing/JLabel;", "notebookAppearance", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookEditorAppearance;", "plusTagButtonSize", "tagsSpacing", "updateAlarm", "Lcom/intellij/util/Alarm;", "getUpdateAlarm$annotations", "()V", "updateElapsedTimeDelay", "createAddTagButton", "Ljavax/swing/JButton;", "createAddTagButtonActionListener", "Ljava/awt/event/ActionListener;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "createAddTagButtonHoverListener", "org/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel$createAddTagButtonHoverListener$1", "originalIcon", "transparentIcon", "(Ljavax/swing/Icon;Ljavax/swing/Icon;)Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel$createAddTagButtonHoverListener$1;", "createTagsRow", "Ljavax/swing/Box;", "getExecutionLabelText", "durationText", "(Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "isExecutionCountDefined", "(Ljava/lang/Integer;)Z", "scheduleElapsedTimeUpdate", "", "diffFormatter", "Lkotlin/Function2;", "startElapsedTimeUpdate", "startTime", "stopElapsedTimeUpdate", "updateBackgroundColor", "updateElapsedTime", "elapsedText", "updateExecutionStatus", "tooltipText", "statusIcon", "executionDurationText", "(Ljava/lang/String;Ljava/lang/Integer;Ljavax/swing/Icon;Ljava/lang/String;)V", "updateUI", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookBelowCellDelimiterPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookBelowCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1#2:197\n1855#3,2:198\n*S KotlinDebug\n*F\n+ 1 NotebookBelowCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel\n*L\n81#1:198,2\n*E\n"})
public final class NotebookBelowCellDelimiterPanel
extends JPanel {
    @NotNull
    private final EditorImpl editor;
    private final boolean isExecutable;
    @NotNull
    private final List<String> cellTags;
    private final int cellNum;
    @NotNull
    private final NotebookEditorAppearance notebookAppearance;
    private final int plusTagButtonSize;
    private final int tagsSpacing;
    private final int delimiterHeight;
    @NotNull
    private JLabel executionLabel;
    @NotNull
    private final Alarm updateAlarm;
    @Nullable
    private ZonedDateTime elapsedStartTime;
    private final int updateElapsedTimeDelay;

    /*
     * WARNING - void declaration
     */
    public NotebookBelowCellDelimiterPanel(@NotNull EditorImpl editor, boolean isExecutable, @NotNull List<String> cellTags, int cellNum, boolean isRenderedMarkdown, @Nullable Integer executionCount, @Nullable Icon initStatusIcon, @Nullable String initTooltipText, @Nullable String initExecutionDurationText) {
        boolean addingTagsRow;
        void it;
        JLabel $this$executionLabel_u24lambda_u240;
        JLabel jLabel;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(cellTags, (String)"cellTags");
        super(new BorderLayout());
        this.editor = editor;
        this.isExecutable = isExecutable;
        this.cellTags = cellTags;
        this.cellNum = cellNum;
        this.notebookAppearance = NotebookUtilKt.getNotebookAppearance((Editor)this.editor);
        this.plusTagButtonSize = JBUI.scale((int)18);
        this.tagsSpacing = JBUI.scale((int)6);
        EditorKind editorKind = this.editor.getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
        boolean bl = NotebookUtilKt.isDiff(editorKind);
        if (bl) {
            n = NotebookUtilKt.getJupyterCellSpacing((Editor)this.editor) / 2;
        } else if (!bl) {
            n = NotebookUtilKt.getNotebookAppearance((Editor)this.editor).getCellBorderHeight() / 4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.delimiterHeight = n;
        JLabel jLabel2 = jLabel = new JLabel();
        NotebookBelowCellDelimiterPanel notebookBelowCellDelimiterPanel = this;
        boolean bl2 = false;
        $this$executionLabel_u24lambda_u240.setFont(EditorUtil.getEditorFont());
        $this$executionLabel_u24lambda_u240.setForeground(UIUtil.getLabelInfoForeground());
        notebookBelowCellDelimiterPanel.executionLabel = jLabel;
        $this$executionLabel_u24lambda_u240 = jLabel = new Alarm();
        notebookBelowCellDelimiterPanel = this;
        boolean bl3 = false;
        Disposer.register((Disposable)this.editor.getDisposable(), (Disposable)((Disposable)it));
        notebookBelowCellDelimiterPanel.updateAlarm = jLabel;
        this.updateElapsedTimeDelay = 100;
        this.add((Component)this.executionLabel, "West");
        this.updateBackgroundColor();
        this.setBorder(BorderFactory.createEmptyBorder(this.delimiterHeight, 0, this.delimiterHeight, 0));
        this.setCursor(Cursor.getPredefinedCursor(0));
        boolean bl4 = addingTagsRow = !((Collection)this.cellTags).isEmpty() && !isRenderedMarkdown && Registry.is((String)"jupyter.cell.metadata.tags", (boolean)false);
        if (addingTagsRow) {
            this.add((Component)this.createTagsRow(), "East");
        }
        this.updateExecutionStatus(initTooltipText, executionCount, initStatusIcon, initExecutionDurationText);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public final int getCellNum() {
        return this.cellNum;
    }

    private static /* synthetic */ void getUpdateAlarm$annotations() {
    }

    @NlsSafe
    private final String getExecutionLabelText(Integer executionCount, String durationText) {
        String string;
        Object executionCountText;
        block5: {
            Object object;
            block4: {
                object = executionCount;
                if (object == null) break block4;
                int it = ((Number)object).intValue();
                boolean bl = false;
                Object object2 = it > 0 ? "[" + it + "]" : "";
                object = object2;
                if (object2 != null) break block5;
            }
            object = executionCountText = "";
        }
        if ((string = durationText) == null) {
            string = "";
        }
        String durationLabelText = string;
        String labelText = (String)executionCountText + " " + durationLabelText;
        return labelText;
    }

    private final Box createTagsRow() {
        Box tagsRow = Box.createHorizontalBox();
        JButton plusActionToolbar = this.createAddTagButton();
        tagsRow.add(plusActionToolbar);
        tagsRow.add(Box.createHorizontalStrut(this.tagsSpacing));
        Iterable $this$forEach$iv = this.cellTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String tag = (String)element$iv;
            boolean bl = false;
            NotebookCellTagLabel tagLabel = new NotebookCellTagLabel(tag, this.cellNum);
            tagsRow.add(tagLabel);
            tagsRow.add(Box.createHorizontalStrut(this.tagsSpacing));
        }
        Intrinsics.checkNotNull((Object)tagsRow);
        return tagsRow;
    }

    private final JButton createAddTagButton() {
        JButton jButton;
        AnAction anAction = ActionManager.getInstance().getAction("JupyterCellAddTagInlayAction");
        if (anAction == null) {
            return null;
        }
        AnAction action = anAction;
        Icon icon = AllIcons.Expui.General.Add;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Add");
        Icon originalIcon = icon;
        Icon transparentIcon = IconLoader.getTransparentIcon((Icon)originalIcon);
        JButton $this$createAddTagButton_u24lambda_u244 = jButton = new JButton();
        boolean bl = false;
        $this$createAddTagButton_u24lambda_u244.setIcon(transparentIcon);
        $this$createAddTagButton_u24lambda_u244.setPreferredSize(new Dimension(this.plusTagButtonSize, this.plusTagButtonSize));
        $this$createAddTagButton_u24lambda_u244.setContentAreaFilled(false);
        $this$createAddTagButton_u24lambda_u244.setFocusPainted(false);
        $this$createAddTagButton_u24lambda_u244.setBorderPainted(false);
        $this$createAddTagButton_u24lambda_u244.setCursor(Cursor.getPredefinedCursor(12));
        $this$createAddTagButton_u24lambda_u244.addMouseListener(this.createAddTagButtonHoverListener(originalIcon, transparentIcon));
        $this$createAddTagButton_u24lambda_u244.addActionListener(this.createAddTagButtonActionListener(action));
        return jButton;
    }

    private final createAddTagButtonHoverListener.1 createAddTagButtonHoverListener(Icon originalIcon, Icon transparentIcon) {
        return new MouseAdapter(originalIcon, transparentIcon){
            final /* synthetic */ Icon $originalIcon;
            final /* synthetic */ Icon $transparentIcon;
            {
                this.$originalIcon = $originalIcon;
                this.$transparentIcon = $transparentIcon;
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JButton");
                ((JButton)object).setIcon(this.$originalIcon);
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JButton");
                ((JButton)object).setIcon(this.$transparentIcon);
            }
        };
    }

    private final ActionListener createAddTagButtonActionListener(AnAction action) {
        return arg_0 -> NotebookBelowCellDelimiterPanel.createAddTagButtonActionListener$lambda$6(action, this, arg_0);
    }

    private final void updateBackgroundColor() {
        Color color;
        boolean bl = this.isExecutable;
        if (bl) {
            EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            color = this.notebookAppearance.getCodeCellBackground(editorColorsScheme);
            if (color == null) {
                Color color2 = this.editor.getColorsScheme().getDefaultBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
            }
        } else if (!bl) {
            color = this.editor.getColorsScheme().getDefaultBackground();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.setBackground(color);
    }

    private final boolean isExecutionCountDefined(Integer executionCount) {
        boolean bl;
        Integer n = executionCount;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = it > 0;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void updateUI() {
        if (this.editor == null) {
            return;
        }
        this.updateBackgroundColor();
        super.updateUI();
    }

    public final void updateExecutionStatus(@NlsSafe @Nullable String tooltipText, @Nullable Integer executionCount, @Nullable Icon statusIcon, @NlsSafe @Nullable String executionDurationText) {
        boolean showStatus;
        boolean bl = showStatus = this.isExecutionCountDefined(executionCount) || tooltipText != null && !Intrinsics.areEqual((Object)statusIcon, (Object)AllIcons.Expui.General.GreenCheckmark);
        if (showStatus) {
            JLabel jLabel;
            JLabel $this$updateExecutionStatus_u24lambda_u248 = jLabel = this.executionLabel;
            boolean bl2 = false;
            $this$updateExecutionStatus_u24lambda_u248.setText(this.getExecutionLabelText(executionCount, executionDurationText));
            $this$updateExecutionStatus_u24lambda_u248.setIcon(statusIcon);
            $this$updateExecutionStatus_u24lambda_u248.setToolTipText(tooltipText);
        } else {
            JLabel jLabel;
            JLabel $this$updateExecutionStatus_u24lambda_u249 = jLabel = this.executionLabel;
            boolean bl3 = false;
            $this$updateExecutionStatus_u24lambda_u249.setText("");
            $this$updateExecutionStatus_u24lambda_u249.setIcon(null);
            $this$updateExecutionStatus_u24lambda_u249.setToolTipText("");
        }
    }

    private final JLabel updateElapsedTime(@Nls String elapsedText) {
        JLabel jLabel;
        JLabel $this$updateElapsedTime_u24lambda_u2410 = jLabel = this.executionLabel;
        boolean bl = false;
        $this$updateElapsedTime_u24lambda_u2410.setText(elapsedText);
        return jLabel;
    }

    public final void startElapsedTimeUpdate(@Nullable ZonedDateTime startTime, @NotNull Function2<? super ZonedDateTime, ? super ZonedDateTime, String> diffFormatter) {
        Intrinsics.checkNotNullParameter(diffFormatter, (String)"diffFormatter");
        if (startTime == null) {
            return;
        }
        this.elapsedStartTime = startTime;
        this.scheduleElapsedTimeUpdate(diffFormatter);
    }

    public final int stopElapsedTimeUpdate() {
        return this.updateAlarm.cancelAllRequests();
    }

    private final void scheduleElapsedTimeUpdate(Function2<? super ZonedDateTime, ? super ZonedDateTime, String> diffFormatter) {
        if (this.updateAlarm.isDisposed()) {
            return;
        }
        this.updateAlarm.addRequest(() -> NotebookBelowCellDelimiterPanel.scheduleElapsedTimeUpdate$lambda$13(this, diffFormatter), this.updateElapsedTimeDelay);
    }

    private static final Object createAddTagButtonActionListener$lambda$6$lambda$5(NotebookBelowCellDelimiterPanel this$0, String dataId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String string = dataId;
        return Intrinsics.areEqual((Object)string, (Object)CommonDataKeys.EDITOR.getName()) ? this$0.editor : (Intrinsics.areEqual((Object)string, (Object)CommonDataKeys.PROJECT.getName()) ? this$0.editor.getProject() : (Intrinsics.areEqual((Object)string, (Object)PlatformCoreDataKeys.CONTEXT_COMPONENT.getName()) ? this$0 : null));
    }

    private static final void createAddTagButtonActionListener$lambda$6(AnAction $action, NotebookBelowCellDelimiterPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DataContext dataContext = arg_0 -> NotebookBelowCellDelimiterPanel.createAddTagButtonActionListener$lambda$6$lambda$5(this$0, arg_0);
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)$action, null, (String)"EditorInlay", (DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent event = anActionEvent;
        $action.actionPerformed(event);
    }

    private static final void scheduleElapsedTimeUpdate$lambda$13$lambda$12$lambda$11(NotebookBelowCellDelimiterPanel this$0, Function2 $diffFormatter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$diffFormatter, (String)"$diffFormatter");
        this$0.scheduleElapsedTimeUpdate((Function2<? super ZonedDateTime, ? super ZonedDateTime, String>)$diffFormatter);
    }

    private static final void scheduleElapsedTimeUpdate$lambda$13(NotebookBelowCellDelimiterPanel this$0, Function2 $diffFormatter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$diffFormatter, (String)"$diffFormatter");
            ZonedDateTime zonedDateTime = this$0.elapsedStartTime;
            if (zonedDateTime == null) break block0;
            ZonedDateTime startTime = zonedDateTime;
            boolean bl = false;
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now(...)");
            String elapsedLabel = (String)$diffFormatter.invoke((Object)startTime, (Object)zonedDateTime2);
            this$0.updateElapsedTime(elapsedLabel);
            this$0.updateAlarm.addRequest(() -> NotebookBelowCellDelimiterPanel.scheduleElapsedTimeUpdate$lambda$13$lambda$12$lambda$11(this$0, $diffFormatter), this$0.updateElapsedTimeDelay);
        }
    }
}

