/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.jupyterToolbar;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.jupyterToolbar.JupyterAddNewCellToolbar;
import org.jetbrains.plugins.notebooks.ui.visualization.DefaultNotebookEditorAppearanceSizes;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\u0012J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0006\u0010\u001a\u001a\u00020\u0012J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u0012J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/jupyterToolbar/JupyterAddCellToolbarService;", "Lcom/intellij/openapi/Disposable;", "()V", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "currentEditor", "Lcom/intellij/openapi/editor/Editor;", "currentPanel", "Ljavax/swing/JPanel;", "currentToolbar", "Lorg/jetbrains/plugins/notebooks/ui/jupyterToolbar/JupyterAddNewCellToolbar;", "editorComponentListener", "Ljava/awt/event/ComponentAdapter;", "editorKeyListener", "Ljava/awt/event/KeyAdapter;", "hideToolbarTimer", "Ljavax/swing/Timer;", "addEditorComponentListener", "", "addEditorKeyListener", "adjustToolbarPosition", "conditionallyHideToolBar", "createActionGroup", "createAndShowToolbar", "editor", "dispose", "hideToolbarUnconditionally", "requestToolbarDisplay", "panel", "requestToolbarHide", "updateCurrentEditor", "newEditor", "Companion", "intellij.notebooks.ui"})
public final class JupyterAddCellToolbarService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Editor currentEditor;
    @Nullable
    private JPanel currentPanel;
    @Nullable
    private JupyterAddNewCellToolbar currentToolbar;
    @NotNull
    private final Timer hideToolbarTimer = new Timer(600, arg_0 -> JupyterAddCellToolbarService.hideToolbarTimer$lambda$0(this, arg_0));
    @Nullable
    private final ActionGroup actionGroup = this.createActionGroup();
    @Nullable
    private ComponentAdapter editorComponentListener;
    @Nullable
    private KeyAdapter editorKeyListener;
    @NotNull
    private static final String ACTION_GROUP_ID = "Jupyter.AboveCellPanelNew";
    private static final int TOOLBAR_HIDE_DELAY = 600;
    private static final int DELIMITER_SIZE = DefaultNotebookEditorAppearanceSizes.INSTANCE.getCellBorderHeight() / 2;

    public final void requestToolbarDisplay(@NotNull JPanel panel, @NotNull Editor editor) {
        boolean shouldDisplayToolbar;
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        boolean bl = shouldDisplayToolbar = !Intrinsics.areEqual((Object)this.currentPanel, (Object)panel) || this.currentToolbar == null;
        if (!shouldDisplayToolbar) {
            return;
        }
        this.hideToolbarUnconditionally();
        this.currentPanel = panel;
        this.updateCurrentEditor(editor);
        this.createAndShowToolbar(editor);
    }

    public final void requestToolbarHide() {
        if (this.currentToolbar == null) {
            return;
        }
        this.hideToolbarTimer.restart();
    }

    public final void hideToolbarUnconditionally() {
        block1: {
            this.currentPanel = null;
            JupyterAddNewCellToolbar jupyterAddNewCellToolbar = this.currentToolbar;
            if (jupyterAddNewCellToolbar == null) break block1;
            JupyterAddNewCellToolbar it = jupyterAddNewCellToolbar;
            boolean bl = false;
            Object object = this.currentEditor;
            if (object != null && (object = object.getContentComponent()) != null) {
                ((Container)object).remove((Component)((Object)it));
            }
            this.currentToolbar = null;
        }
    }

    public final void adjustToolbarPosition() {
        block2: {
            JupyterAddNewCellToolbar jupyterAddNewCellToolbar = this.currentToolbar;
            if (jupyterAddNewCellToolbar == null) break block2;
            JupyterAddNewCellToolbar tb = jupyterAddNewCellToolbar;
            boolean bl = false;
            Editor editor = this.currentEditor;
            if (editor == null) {
                return;
            }
            Editor e = editor;
            JPanel jPanel = this.currentPanel;
            if (jPanel == null) {
                return;
            }
            JPanel p = jPanel;
            tb.setBounds(Companion.calculateToolbarBounds(e, p, tb));
        }
    }

    private final void updateCurrentEditor(Editor newEditor) {
        Object object;
        Editor prevEditor = this.currentEditor;
        if (Intrinsics.areEqual((Object)prevEditor, (Object)newEditor)) {
            return;
        }
        this.currentEditor = newEditor;
        Object object2 = prevEditor;
        if (object2 != null && (object2 = object2.getContentComponent()) != null) {
            ((Component)object2).removeComponentListener(this.editorComponentListener);
        }
        if ((object = prevEditor) != null && (object = object.getContentComponent()) != null) {
            ((Component)object).removeKeyListener(this.editorKeyListener);
        }
        this.addEditorComponentListener();
        this.addEditorKeyListener();
    }

    private final void conditionallyHideToolBar() {
        block2: {
            JupyterAddNewCellToolbar jupyterAddNewCellToolbar = this.currentToolbar;
            if (jupyterAddNewCellToolbar == null) break block2;
            JupyterAddNewCellToolbar tb = jupyterAddNewCellToolbar;
            boolean bl = false;
            Point mousePos = MouseInfo.getPointerInfo().getLocation();
            Editor editor = this.currentEditor;
            Intrinsics.checkNotNull((Object)editor);
            SwingUtilities.convertPointFromScreen(mousePos, editor.getContentComponent());
            if (tb.getBounds().contains(mousePos)) {
                this.hideToolbarTimer.restart();
            } else {
                this.hideToolbarUnconditionally();
            }
        }
    }

    private final void createAndShowToolbar(Editor editor) {
        if (this.actionGroup == null) {
            return;
        }
        if (this.currentToolbar == null) {
            JComponent jComponent = editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            this.currentToolbar = new JupyterAddNewCellToolbar(this.actionGroup, jComponent, null, 4, null);
        }
        editor.getContentComponent().add((Component)((Object)this.currentToolbar), 0);
        this.hideToolbarTimer.stop();
        this.adjustToolbarPosition();
        JupyterAddNewCellToolbar jupyterAddNewCellToolbar = this.currentToolbar;
        if (jupyterAddNewCellToolbar != null) {
            jupyterAddNewCellToolbar.updateActionsImmediately();
        }
        editor.getContentComponent().revalidate();
        editor.getContentComponent().repaint();
    }

    private final ActionGroup createActionGroup() {
        AnAction anAction = CustomActionsSchema.Companion.getInstance().getCorrectedAction(ACTION_GROUP_ID);
        return anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
    }

    private final void addEditorComponentListener() {
        block0: {
            this.editorComponentListener = new ComponentAdapter(this){
                final /* synthetic */ JupyterAddCellToolbarService this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(@Nullable ComponentEvent e) {
                    this.this$0.hideToolbarUnconditionally();
                }
            };
            Object object = this.currentEditor;
            if (object == null || (object = object.getContentComponent()) == null) break block0;
            ((Component)object).addComponentListener(this.editorComponentListener);
        }
    }

    private final void addEditorKeyListener() {
        block0: {
            this.editorKeyListener = new KeyAdapter(this){
                final /* synthetic */ JupyterAddCellToolbarService this$0;
                {
                    this.this$0 = $receiver;
                }

                public void keyTyped(@NotNull KeyEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.hideToolbarUnconditionally();
                }

                public void keyPressed(@NotNull KeyEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.hideToolbarUnconditionally();
                }
            };
            Object object = this.currentEditor;
            if (object == null || (object = object.getContentComponent()) == null) break block0;
            ((Component)object).addKeyListener(this.editorKeyListener);
        }
    }

    public void dispose() {
        block3: {
            Object object;
            Object object2 = this.currentEditor;
            if (object2 != null && (object2 = object2.getContentComponent()) != null) {
                ((Component)object2).removeComponentListener(this.editorComponentListener);
            }
            if ((object = this.currentEditor) != null && (object = object.getContentComponent()) != null) {
                ((Component)object).removeKeyListener(this.editorKeyListener);
            }
            JupyterAddNewCellToolbar jupyterAddNewCellToolbar = this.currentToolbar;
            if (jupyterAddNewCellToolbar == null) break block3;
            JupyterAddNewCellToolbar tb = jupyterAddNewCellToolbar;
            boolean bl = false;
            Object object3 = this.currentEditor;
            if (object3 != null && (object3 = object3.getContentComponent()) != null) {
                ((Container)object3).remove((Component)((Object)tb));
            }
            this.currentToolbar = null;
        }
    }

    private static final void hideToolbarTimer$lambda$0(JupyterAddCellToolbarService this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.conditionallyHideToolBar();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/jupyterToolbar/JupyterAddCellToolbarService$Companion;", "", "()V", "ACTION_GROUP_ID", "", "DELIMITER_SIZE", "", "TOOLBAR_HIDE_DELAY", "calculateToolbarBounds", "Ljava/awt/Rectangle;", "editor", "Lcom/intellij/openapi/editor/Editor;", "panel", "Ljavax/swing/JPanel;", "toolbar", "Lorg/jetbrains/plugins/notebooks/ui/jupyterToolbar/JupyterAddNewCellToolbar;", "getInstance", "Lorg/jetbrains/plugins/notebooks/ui/jupyterToolbar/JupyterAddCellToolbarService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.notebooks.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterAddCellToolbarService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterAddCellToolbarService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterAddCellToolbarService)object;
        }

        @NotNull
        public final Rectangle calculateToolbarBounds(@NotNull Editor editor, @NotNull JPanel panel, @NotNull JupyterAddNewCellToolbar toolbar) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)((Object)toolbar), (String)"toolbar");
            int panelHeight = panel.getHeight();
            int panelWidth = panel.getWidth();
            int toolbarHeight = toolbar.getPreferredSize().height;
            int toolbarWidth = toolbar.getPreferredSize().width;
            int xOffset = (panelWidth - toolbarWidth) / 2;
            int yOffset = (int)((double)panelHeight - 1.5 * (double)DELIMITER_SIZE - (double)(toolbarHeight / 2));
            JComponent jComponent = editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            JComponent editorComponent = jComponent;
            Point panelLocationInEditor = SwingUtilities.convertPoint(panel, new Point(0, 0), editorComponent);
            int xCoordinate = panelLocationInEditor.x + xOffset;
            int yCoordinate = panelLocationInEditor.y + yOffset;
            return new Rectangle(xCoordinate, yCoordinate, toolbarWidth, toolbarHeight);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

