/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.starter;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.CliktCommandKt;
import com.github.ajalt.clikt.core.NoOpCliktCommand;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.arguments.ArgumentTransformContext;
import com.github.ajalt.clikt.parameters.arguments.ProcessedArgument;
import com.github.ajalt.clikt.parameters.options.OptionTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.options.ValueWithDefault;
import com.github.ajalt.clikt.parameters.types.FileKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import com.intellij.lang.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.markers.MarkerEvaluator;
import org.jetbrains.completion.full.line.markers.report.MarkerReporter;
import org.jetbrains.completion.full.line.starter.ConvertersKt;
import org.jetbrains.completion.full.line.starter.ErrorsKt;
import org.jetbrains.completion.full.line.starter.FullLineCommand;
import org.jetbrains.completion.full.line.starter.FullLineFormatter;
import org.jetbrains.completion.full.line.starter.FullLineInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand;", "Lcom/github/ajalt/clikt/core/NoOpCliktCommand;", "()V", "Format", "Help", "Info", "Markers", "intellij.fullLine"})
public final class FullLineCommand
extends NoOpCliktCommand {
    @NotNull
    public static final FullLineCommand INSTANCE = new FullLineCommand();

    private FullLineCommand() {
        super(null, null, null, false, false, null, null, false, false, 511, null);
    }

    static {
        CliktCommand[] cliktCommandArray = new CliktCommand[]{Markers.INSTANCE, Format.INSTANCE, Info.INSTANCE, Help.INSTANCE};
        CliktCommandKt.subcommands((CliktCommand)INSTANCE, cliktCommandArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020!H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006R\u001b\u0010\u0012\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\b\u001a\u0004\b\u0013\u0010\u0006R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\b\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\b\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand$Format;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "failed", "Ljava/io/File;", "getFailed", "()Ljava/io/File;", "failed$delegate", "Lkotlin/properties/ReadOnlyProperty;", "languagesToFilter", "", "", "getLanguagesToFilter", "()Ljava/util/List;", "languagesToFilter$delegate", "output", "getOutput", "output$delegate", "parse", "getParse", "parse$delegate", "preserveOrder", "", "getPreserveOrder", "()Z", "preserveOrder$delegate", "supportedExtensions", "threads", "", "getThreads", "()I", "threads$delegate", "run", "", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineStarter.kt\norg/jetbrains/completion/full/line/starter/FullLineCommand$Format\n+ 2 TransformAll.kt\ncom/github/ajalt/clikt/parameters/options/OptionWithValuesKt__TransformAllKt\n*L\n1#1,156:1\n87#2,5:157\n*S KotlinDebug\n*F\n+ 1 FullLineStarter.kt\norg/jetbrains/completion/full/line/starter/FullLineCommand$Format\n*L\n120#1:157,5\n*E\n"})
    public static final class Format
    extends CliktCommand {
        @NotNull
        public static final Format INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final List<String> supportedExtensions;
        @NotNull
        private static final ReadOnlyProperty parse$delegate;
        @NotNull
        private static final ReadOnlyProperty output$delegate;
        @NotNull
        private static final ReadOnlyProperty failed$delegate;
        @NotNull
        private static final ReadOnlyProperty threads$delegate;
        @NotNull
        private static final ReadOnlyProperty languagesToFilter$delegate;
        @NotNull
        private static final ReadOnlyProperty preserveOrder$delegate;

        private Format() {
            super("Format passed files with jsonl format data", null, null, false, false, null, null, false, false, false, 1022, null);
        }

        private final File getParse() {
            return (File)parse$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final File getOutput() {
            return (File)output$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final File getFailed() {
            return (File)failed$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        private final int getThreads() {
            return ((Number)threads$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
        }

        private final List<String> getLanguagesToFilter() {
            return (List)languagesToFilter$delegate.getValue((Object)this, $$delegatedProperties[4]);
        }

        private final boolean getPreserveOrder() {
            return (Boolean)preserveOrder$delegate.getValue((Object)this, $$delegatedProperties[5]);
        }

        @Override
        public void run() {
            Runtime runtime = Runtime.getRuntime();
            if ((runtime != null ? runtime.maxMemory() : 0L) < 0x780000000L) {
                String string = "Please set big enough -Xmx or we will drop big files (which maybe is ok for your).\nWe need around 1gb of ram for every 1k line of code.\nSo if you want to process even huge files in dataset set -Xmx30g.";
                System.out.println((Object)string);
            }
            FullLineFormatter formatter2 = new FullLineFormatter(new FullLineFormatter.Args(this.getParse(), this.getOutput(), this.getFailed(), this.getThreads(), this.getLanguagesToFilter(), this.getPreserveOrder()));
            formatter2.run();
        }

        public static final /* synthetic */ List access$getSupportedExtensions$p() {
            return supportedExtensions;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$defaultLazy$iv$iv;
            Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "parse", "getParse()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "output", "getOutput()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "failed", "getFailed()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "threads", "getThreads()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "languagesToFilter", "getLanguagesToFilter()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "preserveOrder", "getPreserveOrder()Z", 0)))};
            $$delegatedProperties = objectArray;
            INSTANCE = new Format();
            objectArray = new String[]{"gz", "jsonl"};
            supportedExtensions = CollectionsKt.listOf((Object[])objectArray);
            parse$delegate = ArgumentKt.validate(FileKt.file$default(ArgumentKt.argument$default(INSTANCE, "FILE-TO-PARSE", "Path jsonl file/folder/gzip file with formatting data", null, null, 12, null), true, false, false, true, true, false, 38, null), parse.2.INSTANCE).provideDelegate(INSTANCE, $$delegatedProperties[0]);
            output$delegate = ArgumentKt.default$default(FileKt.file$default(ArgumentKt.argument$default(INSTANCE, "FILE-TO-OUTPUT", "Path to output formatting result, might be jsonl/gzip file", null, null, 12, null), false, false, false, false, false, false, 38, null), new File("output.jsonl.gz"), null, 2, null).provideDelegate(INSTANCE, $$delegatedProperties[1]);
            objectArray = new String[]{"--failed-output", "-f"};
            OptionWithValues $this$defaultLazy_u24default$iv = FileKt.file$default(OptionWithValuesKt.option$default(INSTANCE, (String[])objectArray, "Path for file data with failed cases and short explanation", null, false, null, null, null, null, 252, null), false, false, false, true, true, false, 38, null);
            String defaultForHelp$iv = "";
            OptionWithValues optionWithValues = $this$defaultLazy_u24default$iv;
            String defaultForHelp$iv$iv = defaultForHelp$iv;
            boolean $i$f$defaultLazy = false;
            failed$delegate = OptionWithValuesKt.transformAll$default((OptionWithValues)$this$defaultLazy$iv$iv, defaultForHelp$iv$iv, false, (Function2)new Function2<OptionTransformContext, List<? extends File>, File>(){

                @NotNull
                public final File invoke(@NotNull OptionTransformContext $this$transformAll, @NotNull List<? extends File> it) {
                    Intrinsics.checkNotNullParameter((Object)$this$transformAll, (String)"$this$transformAll");
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Object object = CollectionsKt.lastOrNull(it);
                    if (object == null) {
                        boolean bl = false;
                        object = new File("failed.jsonl.gz");
                    }
                    return object;
                }
            }, 2, null).provideDelegate(INSTANCE, $$delegatedProperties[2]);
            objectArray = new String[]{"--threads", "-t"};
            threads$delegate = OptionWithValuesKt.default$default(IntKt.int(OptionWithValuesKt.option$default(INSTANCE, (String[])objectArray, "Add option to run formatting in parallel, just pass value more than 1 or 1 if you want to do it synchronously", null, false, null, null, null, null, 252, null)), Runtime.getRuntime().availableProcessors(), null, 2, null).provideDelegate(INSTANCE, $$delegatedProperties[3]);
            objectArray = new String[]{"--filter-tags", "-tags"};
            languagesToFilter$delegate = OptionWithValuesKt.multiple$default(OptionWithValuesKt.option$default(INSTANCE, (String[])objectArray, "List of languages and dialects to filter-out while formatting, such files will be marked in failed file. See `info` command for list of supported languages.", null, false, null, null, null, null, 252, null), null, false, 3, null).provideDelegate(INSTANCE, $$delegatedProperties[4]);
            objectArray = new String[]{"--preserve-order", "-o"};
            preserveOrder$delegate = OptionWithValuesKt.default$default(ConvertersKt.boolean(OptionWithValuesKt.option$default(INSTANCE, (String[])objectArray, "If `--threads > 1` - keep an order of result formatted files, passing false might win extra ~100ms", null, false, null, null, null, null, 252, null)), true, null, 2, null).provideDelegate(INSTANCE, $$delegatedProperties[5]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand$Help;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "run", "", "intellij.fullLine"})
    public static final class Help
    extends CliktCommand {
        @NotNull
        public static final Help INSTANCE = new Help();

        private Help() {
            super("Prints help info (passing --help won't work)", null, null, false, false, null, null, false, false, false, 1022, null);
        }

        @Override
        public void run() {
            String help = INSTANCE.getFormattedHelp();
            System.out.println((Object)help);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand$Info;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "run", "", "intellij.fullLine"})
    public static final class Info
    extends CliktCommand {
        @NotNull
        public static final Info INSTANCE = new Info();

        private Info() {
            super("Get info about current environment (system, plugin, list of supported languages)", null, null, false, false, null, null, false, false, false, 1022, null);
        }

        @Override
        public void run() {
            String info = FullLineInfo.INSTANCE.collect();
            System.out.println((Object)info);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand$Markers;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "language", "", "getLanguage", "()Ljava/lang/String;", "language$delegate", "Lkotlin/properties/ReadOnlyProperty;", "reporter", "getReporter", "reporter$delegate", "root", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "root$delegate", "initReporter", "run", "", "validate", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineStarter.kt\norg/jetbrains/completion/full/line/starter/FullLineCommand$Markers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Argument.kt\ncom/github/ajalt/clikt/parameters/arguments/ArgumentKt\n*L\n1#1,156:1\n766#2:157\n857#2,2:158\n1549#2:160\n1620#2,3:161\n453#3,17:164\n*S KotlinDebug\n*F\n+ 1 FullLineStarter.kt\norg/jetbrains/completion/full/line/starter/FullLineCommand$Markers\n*L\n102#1:157\n102#1:158,2\n102#1:160\n102#1:161,3\n80#1:164,17\n*E\n"})
    public static final class Markers
    extends CliktCommand {
        @NotNull
        public static final Markers INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty language$delegate;
        @NotNull
        private static final ReadOnlyProperty root$delegate;
        @NotNull
        private static final ReadOnlyProperty reporter$delegate;

        private Markers() {
            super("Run marker cases to check if resulted suggestion is correct or not.", null, null, false, false, null, null, false, false, false, 1022, null);
        }

        private final String getLanguage() {
            return (String)language$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final File getRoot() {
            return (File)root$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final String getReporter() {
            return (String)reporter$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        private final String initReporter() {
            return System.getenv("FLCC_TESTRAIL") != null ? "testrail" : (System.getenv("TEAMCITY_VERSION") != null ? "teamcity" : "console");
        }

        @Override
        public void run() {
            this.validate();
            MarkerEvaluator evaluator = MarkerEvaluator.Companion.fromDirStructure(this.getRoot(), this.getLanguage(), MarkerReporter.Companion.fromCode(this.getReporter()));
            evaluator.evaluate();
        }

        /*
         * WARNING - void declaration
         */
        private final void validate() {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = FilesKt.readLines$default((File)FilesKt.resolve((File)this.getRoot(), (String)"languages.txt"), null, (int)1, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null) && !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                collection.add(string);
            }
            List existingLanguages = (List)destination$iv$iv;
            if (!existingLanguages.contains(this.getLanguage())) {
                ErrorsKt.noMarkersForLanguage(this.getLanguage(), existingLanguages);
                throw new KotlinNothingValueException();
            }
        }

        static {
            Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Markers.class, "language", "getLanguage()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Markers.class, "root", "getRoot()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Markers.class, "reporter", "getReporter()Ljava/lang/String;", 0)))};
            $$delegatedProperties = objectArray;
            INSTANCE = new Markers();
            ProcessedArgument<Language, Language> $this$convert_u24default$iv = ConvertersKt.language(ArgumentKt.argument$default(INSTANCE, null, "Pass language to run markers on, others will be skipped", null, null, 13, null));
            CompletionCandidates completionCandidates$iv = $this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
            boolean $i$f$convert = false;
            Function2 conv$iv = (Function2)new Function2<ArgumentTransformContext, String, String>($this$convert_u24default$iv){
                final /* synthetic */ ProcessedArgument $this_convert;
                {
                    this.$this_convert = $receiver;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke(@NotNull ArgumentTransformContext $this$null, @NotNull String it) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        void it2;
                        Language language2 = (Language)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                        ArgumentTransformContext $this$language_delegate_u24lambda_u240 = $this$null;
                        boolean bl = false;
                        String string2 = it2.getID();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getID(...)");
                        String string3 = string2.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        string = string3;
                    }
                    catch (UsageError err) {
                        err.setArgument($this$null.getArgument());
                        throw err;
                    }
                    catch (Exception err) {
                        String string4 = err.getMessage();
                        if (string4 == null) {
                            string4 = "";
                        }
                        $this$null.fail(string4);
                        throw new KotlinNothingValueException();
                    }
                    return string;
                }
            };
            language$delegate = ProcessedArgument.copy$default($this$convert_u24default$iv, conv$iv, ArgumentKt.defaultAllProcessor(), ArgumentKt.defaultValidator(), null, 0, false, null, null, ValueWithDefault.copy$default($this$convert_u24default$iv.getCompletionCandidatesWithDefault(), null, completionCandidates$iv, 1, null), 248, null).provideDelegate(INSTANCE, $$delegatedProperties[0]);
            root$delegate = FileKt.file$default(ArgumentKt.argument$default(INSTANCE, null, "Path to root of folder with markers to complete", null, null, 13, null), true, false, false, true, true, false, 36, null).provideDelegate(INSTANCE, $$delegatedProperties[1]);
            objectArray = new String[]{"--reporter", "-r"};
            reporter$delegate = OptionWithValuesKt.default$default(OptionWithValuesKt.option$default(INSTANCE, (String[])objectArray, "Type of reporter to show markers result", null, false, null, null, null, null, 252, null), INSTANCE.initReporter(), null, 2, null).provideDelegate(INSTANCE, $$delegatedProperties[2]);
        }
    }
}

