/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.markers.report;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.markers.Marker;
import org.jetbrains.completion.full.line.markers.report.AnsiECKt;
import org.jetbrains.completion.full.line.markers.report.MarkerReportItem;
import org.jetbrains.completion.full.line.markers.report.MarkerReporter;
import org.jetbrains.completion.full.line.platform.FullLineLookupElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/completion/full/line/markers/report/ConsoleMarkerReporter;", "Lorg/jetbrains/completion/full/line/markers/report/MarkerReporter;", "logDetails", "", "(Z)V", "logMarker", "", "item", "Lorg/jetbrains/completion/full/line/markers/report/MarkerReportItem;", "markerStarted", "marker", "Lorg/jetbrains/completion/full/line/markers/Marker;", "fraction", "", "markerStopped", "summary", "items", "", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nMarkerReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerReporter.kt\norg/jetbrains/completion/full/line/markers/report/ConsoleMarkerReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,158:1\n1477#2:159\n1502#2,3:160\n1505#2,3:170\n1855#2,2:173\n1855#2,2:175\n1855#2,2:177\n372#3,7:163\n*S KotlinDebug\n*F\n+ 1 MarkerReporter.kt\norg/jetbrains/completion/full/line/markers/report/ConsoleMarkerReporter\n*L\n42#1:159\n42#1:160,3\n42#1:170,3\n48#1:173,2\n52#1:175,2\n67#1:177,2\n42#1:163,7\n*E\n"})
public final class ConsoleMarkerReporter
implements MarkerReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean logDetails;
    public static final int MAX_LEN = 100;
    @NotNull
    public static final String CODE = "console";

    public ConsoleMarkerReporter(boolean logDetails) {
        this.logDetails = logDetails;
    }

    @Override
    public void markerStarted(@NotNull Marker marker, double fraction) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        int percent = (int)(fraction * (double)100);
        int n = 100;
        StringBuilder $this$markerStarted_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$markerStarted_u24lambda_u240.append('\r');
        $this$markerStarted_u24lambda_u240.append(StringsKt.padStart$default((String)String.valueOf(percent), (int)3, (char)'\u0000', (int)2, null) + "%|");
        $this$markerStarted_u24lambda_u240.append(StringsKt.repeat((CharSequence)"=", (int)Math.max(percent - 1, 0)));
        if (!(fraction == 0.0)) {
            $this$markerStarted_u24lambda_u240.append('>');
        }
        $this$markerStarted_u24lambda_u240.append(StringsKt.repeat((CharSequence)" ", (int)(99 - percent)));
        $this$markerStarted_u24lambda_u240.append("| ");
        $this$markerStarted_u24lambda_u240.append(marker.getTestcase());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String progressBar = string;
        System.out.println((Object)progressBar);
    }

    @Override
    public void markerStopped(@NotNull MarkerReportItem item, double fraction) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void summary(@NotNull List<MarkerReportItem> items) {
        Iterable $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$groupBy$iv = items;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MarkerReportItem it = (MarkerReportItem)element$iv$iv;
            boolean bl = false;
            MarkerReportItem.MarkerStatus key$iv$iv = it.getStatus();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map perStatusItems = destination$iv$iv;
        List list = (List)perStatusItems.get((Object)MarkerReportItem.MarkerStatus.GREEN);
        int passed = list != null ? list.size() : 0;
        double resultRaw = (double)passed / (double)items.size();
        double result = Math.floor(resultRaw * (double)100) / (double)100;
        if (this.logDetails) {
            $this$forEach$iv = items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MarkerReportItem p0 = (MarkerReportItem)element$iv;
                boolean bl = false;
                this.logMarker(p0);
            }
        }
        System.out.println((Object)("Markers passed " + result * (double)100 + "% (" + passed + "/" + items.size() + ")"));
        $this$forEach$iv = perStatusItems.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            MarkerReportItem.MarkerStatus status = (MarkerReportItem.MarkerStatus)((Object)entry.getKey());
            List item = (List)entry.getValue();
            System.out.println((Object)("\t Got " + item.size() + " " + status.presentable() + " tests"));
        }
    }

    private final void logMarker(MarkerReportItem item) {
        String status = AnsiECKt.wrapWithColor(item.getStatus().presentable(), AnsiECKt.toAnsi(item.getStatus()));
        System.out.println((Object)(status + " - `" + item.getMarker().getTestcase() + "`"));
        System.out.println((Object)("\tExpected: `" + item.getMarker().getResult().getPattern() + "`"));
        System.out.println((Object)"\tFull Line suggestions:");
        if (item.getFullLineElements().isEmpty()) {
            System.out.println((Object)"\t\t-");
        } else {
            Iterable $this$forEach$iv = item.getFullLineElements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FullLineLookupElement el = (FullLineLookupElement)((Object)element$iv);
                boolean bl = false;
                System.out.println((Object)("\t\t`" + el.getLookupString() + el.getSuffix() + "`"));
            }
        }
        System.out.println((Object)StringsKt.repeat((CharSequence)"=", (int)66));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/markers/report/ConsoleMarkerReporter$Companion;", "", "()V", "CODE", "", "MAX_LEN", "", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

