/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancerProvider;
import io.grpc.ServiceProviders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
@ThreadSafe
public final class LoadBalancerRegistry {
    private static final Logger logger = Logger.getLogger(LoadBalancerRegistry.class.getName());
    private static LoadBalancerRegistry instance;
    private static final Iterable<Class<?>> HARDCODED_CLASSES;
    private final LinkedHashSet<LoadBalancerProvider> allProviders = new LinkedHashSet();
    private final LinkedHashMap<String, LoadBalancerProvider> effectiveProviders = new LinkedHashMap();

    public synchronized void register(LoadBalancerProvider provider2) {
        this.addProvider(provider2);
        this.refreshProviderMap();
    }

    private synchronized void addProvider(LoadBalancerProvider provider2) {
        Preconditions.checkArgument((boolean)provider2.isAvailable(), (Object)"isAvailable() returned false");
        this.allProviders.add(provider2);
    }

    public synchronized void deregister(LoadBalancerProvider provider2) {
        this.allProviders.remove(provider2);
        this.refreshProviderMap();
    }

    private synchronized void refreshProviderMap() {
        this.effectiveProviders.clear();
        for (LoadBalancerProvider provider2 : this.allProviders) {
            String policy = provider2.getPolicyName();
            LoadBalancerProvider existing = this.effectiveProviders.get(policy);
            if (existing != null && existing.getPriority() >= provider2.getPriority()) continue;
            this.effectiveProviders.put(policy, provider2);
        }
    }

    public static synchronized LoadBalancerRegistry getDefaultRegistry() {
        if (instance == null) {
            List<LoadBalancerProvider> providerList = ServiceProviders.loadAll(LoadBalancerProvider.class, HARDCODED_CLASSES, LoadBalancerProvider.class.getClassLoader(), new LoadBalancerPriorityAccessor());
            instance = new LoadBalancerRegistry();
            for (LoadBalancerProvider provider2 : providerList) {
                logger.fine("Service loader found " + provider2);
                instance.addProvider(provider2);
            }
            instance.refreshProviderMap();
        }
        return instance;
    }

    @Nullable
    public synchronized LoadBalancerProvider getProvider(String policy) {
        return this.effectiveProviders.get(Preconditions.checkNotNull((Object)policy, (Object)"policy"));
    }

    @VisibleForTesting
    synchronized Map<String, LoadBalancerProvider> providers() {
        return new LinkedHashMap<String, LoadBalancerProvider>(this.effectiveProviders);
    }

    @VisibleForTesting
    static List<Class<?>> getHardCodedClasses() {
        ArrayList list = new ArrayList();
        try {
            list.add(Class.forName("io.grpc.internal.PickFirstLoadBalancerProvider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Unable to find pick-first LoadBalancer", e);
        }
        try {
            list.add(Class.forName("io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to find round-robin LoadBalancer", e);
        }
        return Collections.unmodifiableList(list);
    }

    static {
        HARDCODED_CLASSES = LoadBalancerRegistry.getHardCodedClasses();
    }

    private static final class LoadBalancerPriorityAccessor
    implements ServiceProviders.PriorityAccessor<LoadBalancerProvider> {
        LoadBalancerPriorityAccessor() {
        }

        @Override
        public boolean isAvailable(LoadBalancerProvider provider2) {
            return provider2.isAvailable();
        }

        @Override
        public int getPriority(LoadBalancerProvider provider2) {
            return provider2.getPriority();
        }
    }
}

