/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.usages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsagePresentation;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdMergeableUsage;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rdclient.usages.FrontendMergeableUsage;
import com.jetbrains.rdclient.usages.FrontendMergeableUsagePresentationKt;
import com.jetbrains.rdclient.usages.RdUsageExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0002J\u0018\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u000fH\u0002J\r\u0010#\u001a\u00070\u001c\u00a2\u0006\u0002\b$H\u0016J\u0013\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016\u00a2\u0006\u0002\u0010!J\r\u0010&\u001a\u00070\u001c\u00a2\u0006\u0002\b$H\u0016J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002\u00a2\u0006\u0002\u0010!R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lcom/jetbrains/rdclient/usages/FrontendMergeableUsagePresentation;", "Lcom/intellij/usages/UsagePresentation;", "model", "Lcom/jetbrains/rd/ide/model/RdMergeableUsage;", "mergedUsages", "Ljava/util/ArrayList;", "Lcom/jetbrains/rdclient/usages/FrontendMergeableUsage;", "Lkotlin/collections/ArrayList;", "(Lcom/jetbrains/rd/ide/model/RdMergeableUsage;Ljava/util/ArrayList;)V", "getModel", "()Lcom/jetbrains/rd/ide/model/RdMergeableUsage;", "createChunk", "Lcom/intellij/usages/TextChunk;", "points", "", "", "i", "createChunks", "", "(Ljava/util/List;)[Lcom/intellij/usages/TextChunk;", "createControlPoints", "createPositionChunk", "getAllModels", "", "getChunkStyle", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "kotlin.jvm.PlatformType", "getChunkText", "", "getColumn", "getIcon", "Ljavax/swing/Icon;", "getInvalidText", "()[Lcom/intellij/usages/TextChunk;", "getLine", "getPlainText", "Lcom/intellij/openapi/util/NlsSafe;", "getText", "getTooltipText", "getValidText", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMergeableUsagePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMergeableUsagePresentation.kt\ncom/jetbrains/rdclient/usages/FrontendMergeableUsagePresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n1549#2:92\n1620#2,3:93\n1549#2:100\n1620#2,3:101\n1549#2:104\n1620#2,3:105\n37#3,2:96\n13#4:98\n13#4:99\n*S KotlinDebug\n*F\n+ 1 FrontendMergeableUsagePresentation.kt\ncom/jetbrains/rdclient/usages/FrontendMergeableUsagePresentation\n*L\n49#1:92\n49#1:93,3\n80#1:100\n80#1:101,3\n85#1:104\n85#1:105,3\n50#1:96,2\n56#1:98\n60#1:99\n*E\n"})
public final class FrontendMergeableUsagePresentation
implements UsagePresentation {
    @NotNull
    private final RdMergeableUsage model;
    @NotNull
    private final ArrayList<FrontendMergeableUsage> mergedUsages;

    public FrontendMergeableUsagePresentation(@NotNull RdMergeableUsage model, @NotNull ArrayList<FrontendMergeableUsage> mergedUsages) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(mergedUsages, (String)"mergedUsages");
        this.model = model;
        this.mergedUsages = mergedUsages;
    }

    @NotNull
    public final RdMergeableUsage getModel() {
        return this.model;
    }

    @NotNull
    public TextChunk[] getText() {
        return this.getValidText();
    }

    private final TextChunk[] getValidText() {
        return this.createChunks(this.createControlPoints());
    }

    private final TextChunk[] getInvalidText() {
        TextChunk[] textChunkArray = new TextChunk[]{new TextChunk(FrontendMergeableUsagePresentationKt.access$getErrorStyle$p(), "INVALID")};
        return textChunkArray;
    }

    /*
     * WARNING - void declaration
     */
    private final TextChunk[] createChunks(List<Integer> points) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ArrayList<TextChunk> arrayList;
        ArrayList<TextChunk> $this$createChunks_u24lambda_u241 = arrayList = new ArrayList<TextChunk>();
        boolean bl = false;
        $this$createChunks_u24lambda_u241.add(this.createPositionChunk());
        Iterable iterable = (Iterable)new IntRange(0, points.size() - 2);
        ArrayList<TextChunk> arrayList2 = $this$createChunks_u24lambda_u241;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.createChunk(points, (int)i));
        }
        arrayList2.addAll((List)destination$iv$iv);
        Collection $this$toTypedArray$iv = arrayList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TextChunk[0]);
    }

    private final TextChunk createChunk(List<Integer> points, int i) {
        return new TextChunk(this.getChunkStyle(i), this.getChunkText(points, i));
    }

    private final TextAttributes getChunkStyle(int i) {
        return i % 2 == 0 ? FrontendMergeableUsagePresentationKt.access$getRegularStyle$p() : FrontendMergeableUsagePresentationKt.access$getBoldStyle$p();
    }

    private final String getChunkText(List<Integer> points, int i) {
        if (((Number)points.get(i)).intValue() > this.model.getText().length()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FrontendMergeableUsagePresentation.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Start Index " + i + ": " + points.get(i) + " > " + this.model.getText().length() + ". Text: " + this.model.getText());
            return "";
        }
        if (((Number)points.get(i + 1)).intValue() > this.model.getText().length()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FrontendMergeableUsagePresentation.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("End Index " + (i + 1) + ": " + points.get(i + 1) + " > " + this.model.getText().length() + ". Text: " + this.model.getText());
            return "";
        }
        String string = this.model.getText().substring(((Number)points.get(i)).intValue(), ((Number)points.get(i + 1)).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        return i == 0 ? ((Object)StringsKt.trimStart((CharSequence)text)).toString() : text;
    }

    private final List<Integer> createControlPoints() {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> $this$createControlPoints_u24lambda_u242 = arrayList = new ArrayList<Integer>();
        boolean bl = false;
        Integer[] integerArray = new Integer[]{0, this.model.getText().length()};
        $this$createControlPoints_u24lambda_u242.addAll(CollectionsKt.listOf((Object[])integerArray));
        for (RdMergeableUsage it : this.getAllModels()) {
            if (it != this.model && !Intrinsics.areEqual((Object)it.getText(), (Object)this.model.getText())) continue;
            $this$createControlPoints_u24lambda_u242.add(RdUsageExtensionsKt.getPosition(it).getOccurrenceRangeStartOffset());
            $this$createControlPoints_u24lambda_u242.add(RdUsageExtensionsKt.getPosition(it).getOccurrenceRangeEndOffset());
        }
        return CollectionsKt.sorted((Iterable)arrayList);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<RdMergeableUsage> getAllModels() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.mergedUsages;
        Iterable iterable2 = CollectionsKt.listOf((Object)this.model);
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FrontendMergeableUsage frontendMergeableUsage = (FrontendMergeableUsage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getModel());
        }
        return CollectionsKt.union((Iterable)iterable2, (Iterable)((List)destination$iv$iv));
    }

    private final TextChunk createPositionChunk() {
        return new TextChunk(FrontendMergeableUsagePresentationKt.access$getHintStyle$p(), "(" + this.getLine() + ": " + this.getColumn() + ") ");
    }

    private final int getLine() {
        return RdUsageExtensionsKt.getPosition(this.model).getLine() + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int getColumn() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.mergedUsages;
        RdMergeableUsage rdMergeableUsage = this.model;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FrontendMergeableUsage frontendMergeableUsage = (FrontendMergeableUsage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getModel());
        }
        return RdUsageExtensionsKt.getMergedColumn(rdMergeableUsage, (List)destination$iv$iv) + 1;
    }

    @NotNull
    public String getPlainText() {
        return this.model.getText();
    }

    @NotNull
    public String getTooltipText() {
        return this.model.getText();
    }

    @Nullable
    public Icon getIcon() {
        IconModel iconModel = this.model.getIcon();
        return iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
    }
}

