/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.settingsSync.DeleteServerDataResult;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsLog;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotKt;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEventListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncIdeMediator;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.SettingsSyncMigration;
import com.intellij.settingsSync.SettingsSyncPushResult;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncState;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.statistics.SettingsSyncEventsStatistics;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002\u0017\u001a\b\u0007\u0018\u0000 X2\u00020\u0001:\u0004XYZ[B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\b\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\u00020\u001d2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001d0(H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0002J\u0015\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b.J \u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020\u001dH\u0003J&\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020,2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001d0@H\u0002J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010<\u001a\u00020=H\u0002J\"\u0010E\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020D2\u0006\u0010F\u001a\u00020,2\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\r\u0010I\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\bJJ\u0010\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020%H\u0002J\b\u0010M\u001a\u00020\u001dH\u0002J\u001e\u0010N\u001a\u00020\u001d2\b\u0010L\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010O\u001a\u0004\u0018\u00010PH\u0002J\r\u0010Q\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\bRJ\u0018\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006\\"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "appConfigPath", "Ljava/nio/file/Path;", "settingsLog", "Lcom/intellij/settingsSync/SettingsLog;", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "updateChecker", "Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "(Lcom/intellij/openapi/Disposable;Ljava/nio/file/Path;Lcom/intellij/settingsSync/SettingsLog;Lcom/intellij/settingsSync/SettingsSyncIdeMediator;Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;)V", "pendingEvents", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/settingsSync/SyncSettingsEvent$StandardEvent;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "settingsChangeListener", "com/intellij/settingsSync/SettingsSyncBridge$settingsChangeListener$1", "Lcom/intellij/settingsSync/SettingsSyncBridge$settingsChangeListener$1;", "updateObject", "com/intellij/settingsSync/SettingsSyncBridge$updateObject$1", "Lcom/intellij/settingsSync/SettingsSyncBridge$updateObject$1;", "applyInitialChanges", "", "initMode", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "applySnapshotFromServer", "cloudEvent", "Lcom/intellij/settingsSync/SyncSettingsEvent$CloudChange;", "checkServer", "collectCurrentState", "Lcom/intellij/settingsSync/SettingsSyncBridge$CurrentState;", "deleteServerData", "afterDeleting", "Lkotlin/Function1;", "Lcom/intellij/settingsSync/DeleteServerDataResult;", "forcePushToCloud", "masterPosition", "Lcom/intellij/settingsSync/SettingsLog$Position;", "initialize", "initialize$intellij_settingsSync", "mergeAndPush", "previousIdePosition", "previousCloudPosition", "pushRequestMode", "Lcom/intellij/settingsSync/SettingsSyncBridge$PushRequestMode;", "migrateFromOldStorage", "migration", "Lcom/intellij/settingsSync/SettingsSyncMigration;", "processExclusiveEvent", "event", "Lcom/intellij/settingsSync/SyncSettingsEvent$ExclusiveEvent;", "processPendingEvents", "pushAndHandleResult", "force", "", "positionToSetCloudBranch", "onRejectedPush", "Lkotlin/Function0;", "pushToCloud", "Lcom/intellij/settingsSync/SettingsSyncPushResult;", "settingsSnapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "pushToIde", "targetPosition", "syncSettings", "Lcom/intellij/settingsSync/SettingsSyncState;", "resumeEventProcessing", "resumeEventProcessing$intellij_settingsSync", "rollback", "previousState", "saveIdeSettings", "stopSyncingAndRollback", "exception", "", "suspendEventProcessing", "suspendEventProcessing$intellij_settingsSync", "waitForAllExecuted", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "Companion", "CurrentState", "InitMode", "PushRequestMode", "intellij.settingsSync"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSettingsSyncBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncBridge.kt\ncom/intellij/settingsSync/SettingsSyncBridge\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,444:1\n13#2:445\n*S KotlinDebug\n*F\n+ 1 SettingsSyncBridge.kt\ncom/intellij/settingsSync/SettingsSyncBridge\n*L\n442#1:445\n*E\n"})
public final class SettingsSyncBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path appConfigPath;
    @NotNull
    private final SettingsLog settingsLog;
    @NotNull
    private final SettingsSyncIdeMediator ideMediator;
    @NotNull
    private final SettingsSyncRemoteCommunicator remoteCommunicator;
    @NotNull
    private final SettingsSyncUpdateChecker updateChecker;
    @NotNull
    private final ConcurrentList<SyncSettingsEvent.StandardEvent> pendingEvents;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final updateObject.1 updateObject;
    @NotNull
    private final settingsChangeListener.1 settingsChangeListener;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public SettingsSyncBridge(@NotNull Disposable parentDisposable, @NotNull Path appConfigPath, @NotNull SettingsLog settingsLog2, @NotNull SettingsSyncIdeMediator ideMediator2, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull SettingsSyncUpdateChecker updateChecker) {
        void $this$queue_u24lambda_u240;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
        Intrinsics.checkNotNullParameter((Object)settingsLog2, (String)"settingsLog");
        Intrinsics.checkNotNullParameter((Object)ideMediator2, (String)"ideMediator");
        Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
        Intrinsics.checkNotNullParameter((Object)updateChecker, (String)"updateChecker");
        this.appConfigPath = appConfigPath;
        this.settingsLog = settingsLog2;
        this.ideMediator = ideMediator2;
        this.remoteCommunicator = remoteCommunicator;
        this.updateChecker = updateChecker;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.pendingEvents = concurrentList;
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("SettingsSyncBridge", 1000, false, null, parentDisposable, null, Alarm.ThreadToUse.POOLED_THREAD);
        SettingsSyncBridge settingsSyncBridge = this;
        boolean bl = false;
        $this$queue_u24lambda_u240.setRestartTimerOnAdd(true);
        settingsSyncBridge.queue = mergingUpdateQueue;
        this.updateObject = new Update(this){
            final /* synthetic */ SettingsSyncBridge this$0;
            {
                this.this$0 = $receiver;
                super((Object)1);
            }

            public void run() {
                SettingsSyncBridge.access$processPendingEvents(this.this$0);
            }
        };
        this.settingsChangeListener = new SettingsSyncEventListener(this){
            final /* synthetic */ SettingsSyncBridge this$0;
            {
                this.this$0 = $receiver;
            }

            public void settingChanged(@NotNull SyncSettingsEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SettingsSyncBridge.access$getLOG$cp().debug("Adding settings changed event " + event + " to the queue");
                if (event instanceof SyncSettingsEvent.ExclusiveEvent) {
                    SettingsSyncBridge.access$getQueue$p(this.this$0).queue(Update.create((Object)event, () -> settingsChangeListener.1.settingChanged$lambda$0(this.this$0, event)));
                } else {
                    SettingsSyncBridge.access$getPendingEvents$p(this.this$0).add((Object)((SyncSettingsEvent.StandardEvent)event));
                    SettingsSyncBridge.access$getQueue$p(this.this$0).queue((Update)SettingsSyncBridge.access$getUpdateObject$p(this.this$0));
                }
            }

            private static final void settingChanged$lambda$0(SettingsSyncBridge this$0, SyncSettingsEvent $event) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
                SettingsSyncBridge.access$processExclusiveEvent(this$0, (SyncSettingsEvent.ExclusiveEvent)$event);
            }
        };
    }

    @RequiresBackgroundThread
    public final void initialize$intellij_settingsSync(@NotNull InitMode initMode) {
        Intrinsics.checkNotNullParameter((Object)initMode, (String)"initMode");
        try {
            this.settingsLog.initialize();
            SettingsSyncEvents.Companion.getInstance().addListener(this.settingsChangeListener);
            this.ideMediator.activateStreamProvider();
            this.applyInitialChanges(initMode);
            this.queue.activate();
        }
        catch (Exception ex) {
            this.stopSyncingAndRollback(null, ex);
        }
    }

    private final void saveIdeSettings() {
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                        this.label = 1;
                        Object object3 = StoreUtilKt.saveSettings((ComponentManager)((ComponentManager)application), (boolean)true, (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void applyInitialChanges(InitMode initMode) {
        CurrentState previousState = this.collectCurrentState();
        this.settingsLog.logExistingSettings();
        try {
            InitMode initMode2 = initMode;
            if (initMode2 instanceof InitMode.TakeFromServer) {
                this.applySnapshotFromServer(((InitMode.TakeFromServer)initMode).getCloudEvent());
            } else if (Intrinsics.areEqual((Object)initMode2, (Object)InitMode.PushToServer.INSTANCE)) {
                this.mergeAndPush(previousState.getIdePosition(), previousState.getCloudPosition(), PushRequestMode.FORCE_PUSH);
            } else if (Intrinsics.areEqual((Object)initMode2, (Object)InitMode.JustInit.INSTANCE)) {
                this.mergeAndPush(previousState.getIdePosition(), previousState.getCloudPosition(), PushRequestMode.PUSH_IF_NEEDED);
            } else if (initMode2 instanceof InitMode.MigrateFromOldStorage) {
                this.migrateFromOldStorage(((InitMode.MigrateFromOldStorage)initMode).getMigration());
            }
        }
        catch (Throwable e) {
            this.stopSyncingAndRollback(previousState, e);
        }
    }

    private final void applySnapshotFromServer(SyncSettingsEvent.CloudChange cloudEvent) {
        this.settingsLog.advanceMaster();
        SettingsLog.Position masterPosition = this.settingsLog.forceWriteToMaster(cloudEvent.getSnapshot(), "Remote changes to initialize settings by data from cloud");
        this.pushToIde(this.settingsLog.collectCurrentSnapshot(), masterPosition, cloudEvent.getSyncSettings());
        this.settingsLog.setCloudPosition(masterPosition);
        SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(cloudEvent.getServerVersionId());
    }

    private final void migrateFromOldStorage(SettingsSyncMigration migration) {
        TemplateSettings.getInstance();
        SettingsSnapshot migrationSnapshot = migration.getLocalDataIfAvailable(this.appConfigPath);
        if (migrationSnapshot != null) {
            this.settingsLog.applyIdeState(migrationSnapshot, "Migrate from old settings sync");
            LOG.info("Migration from old storage applied.");
            SettingsLog.Position masterPosition = this.settingsLog.advanceMaster();
            UpdateResult updateResult = this.remoteCommunicator.receiveUpdates();
            if (updateResult instanceof UpdateResult.Success) {
                LOG.info("There is a snapshot on the server => prefer server version over local migration data");
                SettingsSnapshot snapshot = ((UpdateResult.Success)updateResult).getSettingsSnapshot();
                masterPosition = this.settingsLog.forceWriteToMaster(snapshot, "Remote changes to overwrite migration data by settings from cloud");
                this.settingsLog.setCloudPosition(masterPosition);
                SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(((UpdateResult.Success)updateResult).getServerVersionId());
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
                this.pushToIde(this.settingsLog.collectCurrentSnapshot(), masterPosition, null);
            } else if (updateResult instanceof UpdateResult.FileDeletedFromServer) {
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
                LOG.info("Snapshot on the server has been deleted => not enabling settings sync after migration");
            } else if (updateResult instanceof UpdateResult.Error) {
                LOG.info("Error prevented checking server state: " + ((UpdateResult.Error)updateResult).getMessage());
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
                SettingsSyncStatusTracker.Companion.getInstance().updateOnError(((UpdateResult.Error)updateResult).getMessage());
            } else if (Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.NoFileOnServer.INSTANCE)) {
                LOG.info("No snapshot file on the server yet => pushing the migrated data to the cloud");
                this.forcePushToCloud(masterPosition);
                this.settingsLog.setCloudPosition(masterPosition);
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
                this.pushToIde(this.settingsLog.collectCurrentSnapshot(), masterPosition, null);
                migration.migrateCategoriesSyncStatus(this.appConfigPath, SettingsSyncSettings.Companion.getInstance());
                this.saveIdeSettings();
            }
        } else {
            LOG.warn("Migration from old storage didn't happen, although it was identified as possible: no data to migrate");
            this.settingsLog.advanceMaster();
        }
    }

    private final void forcePushToCloud(SettingsLog.Position masterPosition) {
        this.pushAndHandleResult(true, masterPosition, (Function0<Unit>)((Function0)forcePushToCloud.1.INSTANCE));
    }

    private final void processExclusiveEvent(SyncSettingsEvent.ExclusiveEvent event) {
        SyncSettingsEvent.ExclusiveEvent exclusiveEvent = event;
        if (exclusiveEvent instanceof SyncSettingsEvent.CrossIdeSyncStateChanged) {
            LOG.info("Cross-ide sync state changed to: " + ((SyncSettingsEvent.CrossIdeSyncStateChanged)event).isCrossIdeSyncEnabled());
            if (((SyncSettingsEvent.CrossIdeSyncStateChanged)event).isCrossIdeSyncEnabled()) {
                this.remoteCommunicator.createFile("cross-ide-sync-enabled", "");
            } else {
                this.remoteCommunicator.deleteFile("cross-ide-sync-enabled");
            }
            this.forcePushToCloud(this.settingsLog.getMasterPosition());
        } else if (exclusiveEvent instanceof SyncSettingsEvent.SyncRequest) {
            this.checkServer();
        } else if (exclusiveEvent instanceof SyncSettingsEvent.RestoreSettingsSnapshot) {
            CurrentState previousState = this.collectCurrentState();
            this.settingsLog.restoreStateAt(((SyncSettingsEvent.RestoreSettingsSnapshot)event).getHash());
            this.pushToIde(this.settingsLog.collectCurrentSnapshot(), this.settingsLog.getIdePosition(), null);
            this.mergeAndPush(previousState.getIdePosition(), previousState.getCloudPosition(), PushRequestMode.MUST_PUSH);
            ((SyncSettingsEvent.RestoreSettingsSnapshot)event).getOnComplete().run();
        }
    }

    @RequiresBackgroundThread
    private final void processPendingEvents() {
        CurrentState previousState = this.collectCurrentState();
        try {
            PushRequestMode pushRequestMode = PushRequestMode.PUSH_IF_NEEDED;
            boolean mergeAndPushAfterProcessingEvents = true;
            while (!((Collection)this.pendingEvents).isEmpty()) {
                SyncSettingsEvent.StandardEvent event = (SyncSettingsEvent.StandardEvent)this.pendingEvents.remove(0);
                LOG.debug("Processing event " + event);
                SyncSettingsEvent.StandardEvent standardEvent = event;
                if (standardEvent instanceof SyncSettingsEvent.IdeChange) {
                    this.settingsLog.applyIdeState(((SyncSettingsEvent.IdeChange)event).getSnapshot(), "Local changes made in the IDE");
                    continue;
                }
                if (standardEvent instanceof SyncSettingsEvent.CloudChange) {
                    this.settingsLog.applyCloudState(((SyncSettingsEvent.CloudChange)event).getSnapshot(), "Remote changes");
                    SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(((SyncSettingsEvent.CloudChange)event).getServerVersionId());
                    continue;
                }
                if (standardEvent instanceof SyncSettingsEvent.LogCurrentSettings) {
                    this.settingsLog.logExistingSettings();
                    continue;
                }
                if (standardEvent instanceof SyncSettingsEvent.MustPushRequest) {
                    pushRequestMode = PushRequestMode.MUST_PUSH;
                    continue;
                }
                if (standardEvent instanceof SyncSettingsEvent.DeleteServerData) {
                    mergeAndPushAfterProcessingEvents = false;
                    SettingsSyncBridge.stopSyncingAndRollback$default(this, previousState, null, 2, null);
                    this.deleteServerData(((SyncSettingsEvent.DeleteServerData)event).getAfterDeleting());
                    continue;
                }
                if (!Intrinsics.areEqual((Object)standardEvent, (Object)SyncSettingsEvent.DeletedOnCloud.INSTANCE)) continue;
                mergeAndPushAfterProcessingEvents = false;
                SettingsSyncBridge.stopSyncingAndRollback$default(this, previousState, null, 2, null);
            }
            if (mergeAndPushAfterProcessingEvents) {
                this.mergeAndPush(previousState.getIdePosition(), previousState.getCloudPosition(), pushRequestMode);
            }
        }
        catch (Throwable exception) {
            this.stopSyncingAndRollback(previousState, exception);
        }
    }

    private final void deleteServerData(Function1<? super DeleteServerDataResult, Unit> afterDeleting) {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        SettingsSnapshot deletionSnapshot = new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), true), SetsKt.emptySet(), null, MapsKt.emptyMap(), SetsKt.emptySet());
        SettingsSyncPushResult pushResult = this.pushToCloud(deletionSnapshot, true);
        LOG.info("Deleting server data. Result: " + pushResult);
        SettingsSyncPushResult settingsSyncPushResult = pushResult;
        if (settingsSyncPushResult instanceof SettingsSyncPushResult.Success) {
            afterDeleting.invoke((Object)DeleteServerDataResult.Success.INSTANCE);
        } else if (settingsSyncPushResult instanceof SettingsSyncPushResult.Error) {
            afterDeleting.invoke((Object)new DeleteServerDataResult.Error(((SettingsSyncPushResult.Error)pushResult).getMessage()));
        } else if (Intrinsics.areEqual((Object)settingsSyncPushResult, (Object)SettingsSyncPushResult.Rejected.INSTANCE)) {
            afterDeleting.invoke((Object)new DeleteServerDataResult.Error("Deletion rejected by server"));
        }
    }

    private final void checkServer() {
        ServerState serverState = this.remoteCommunicator.checkServerState();
        if (serverState instanceof ServerState.UpdateNeeded) {
            LOG.info("Updating from server");
            this.updateChecker.scheduleUpdateFromServer();
        } else if (Intrinsics.areEqual((Object)serverState, (Object)ServerState.FileNotExists.INSTANCE)) {
            LOG.info("No file on server, will push local settings");
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.MustPushRequest.INSTANCE);
        } else if (Intrinsics.areEqual((Object)serverState, (Object)ServerState.UpToDate.INSTANCE)) {
            LOG.debug("Updating settings is not needed");
        } else if (serverState instanceof ServerState.Error) {
            // empty if block
        }
    }

    private final CurrentState collectCurrentState() {
        return new CurrentState(this.settingsLog.getMasterPosition(), this.settingsLog.getIdePosition(), this.settingsLog.getCloudPosition(), SettingsSyncLocalSettings.Companion.getInstance().getKnownAndAppliedServerId());
    }

    private final void stopSyncingAndRollback(CurrentState previousState, Throwable exception) {
        if (exception != null) {
            LOG.error("Couldn't apply settings. Settings sync will be disabled.", exception);
            SettingsSyncEventsStatistics.INSTANCE.getDISABLED_AUTOMATICALLY().log((Object)SettingsSyncEventsStatistics.AutomaticDisableReason.EXCEPTION);
        } else {
            LOG.info("Settings Sync is switched off. Rolling back.");
        }
        SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
        if (exception != null) {
            SettingsSyncStatusTracker settingsSyncStatusTracker = SettingsSyncStatusTracker.Companion.getInstance();
            String string = exception.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
            settingsSyncStatusTracker.updateOnError(string);
        }
        this.ideMediator.removeStreamProvider();
        SettingsSyncEvents.Companion.getInstance().removeListener(this.settingsChangeListener);
        this.pendingEvents.clear();
        if (previousState != null) {
            this.rollback(previousState);
        }
        this.queue.deactivate();
    }

    static /* synthetic */ void stopSyncingAndRollback$default(SettingsSyncBridge settingsSyncBridge, CurrentState currentState, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        settingsSyncBridge.stopSyncingAndRollback(currentState, throwable);
    }

    private final void rollback(CurrentState previousState) {
        try {
            LOG.warn("Rolling back to previous state: " + previousState);
            SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(previousState.getKnownServerId());
            this.settingsLog.setIdePosition(previousState.getIdePosition());
            this.settingsLog.setCloudPosition(previousState.getCloudPosition());
            this.settingsLog.setMasterPosition(previousState.getMasterPosition());
        }
        catch (Throwable e) {
            LOG.error("Couldn't rollback to the previous successful state", e);
        }
    }

    private final void mergeAndPush(SettingsLog.Position previousIdePosition, SettingsLog.Position previousCloudPosition, PushRequestMode pushRequestMode) {
        SettingsLog.Position newIdePosition = this.settingsLog.getIdePosition();
        SettingsLog.Position newCloudPosition = this.settingsLog.getCloudPosition();
        SettingsLog.Position masterPosition = null;
        masterPosition = !Intrinsics.areEqual((Object)newIdePosition, (Object)previousIdePosition) || !Intrinsics.areEqual((Object)newCloudPosition, (Object)previousCloudPosition) ? this.settingsLog.advanceMaster() : this.settingsLog.getMasterPosition();
        if (!Intrinsics.areEqual((Object)newIdePosition, (Object)masterPosition)) {
            this.pushToIde(this.settingsLog.collectCurrentSnapshot(), masterPosition, null);
        }
        if (!Intrinsics.areEqual((Object)newCloudPosition, (Object)masterPosition) || pushRequestMode == PushRequestMode.MUST_PUSH || pushRequestMode == PushRequestMode.FORCE_PUSH) {
            this.pushAndHandleResult(pushRequestMode == PushRequestMode.FORCE_PUSH, masterPosition, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ SettingsSyncBridge this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    boolean bl;
                    block4: {
                        Iterable $this$none$iv = (Iterable)SettingsSyncBridge.access$getPendingEvents$p(this.this$0);
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$none$iv) {
                                SyncSettingsEvent.StandardEvent it = (SyncSettingsEvent.StandardEvent)element$iv;
                                boolean bl2 = false;
                                if (!(it instanceof SyncSettingsEvent.CloudChange)) continue;
                                bl = false;
                                break block4;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        SettingsSyncBridge.access$getUpdateChecker$p(this.this$0).scheduleUpdateFromServer();
                    }
                }
            }));
        } else {
            LOG.debug("Nothing to push");
        }
    }

    private final void pushAndHandleResult(boolean force, SettingsLog.Position positionToSetCloudBranch, Function0<Unit> onRejectedPush) {
        SettingsSyncPushResult pushResult = this.pushToCloud(this.settingsLog.collectCurrentSnapshot(), force);
        LOG.info("Result of pushing settings to the cloud: " + pushResult);
        SettingsSyncPushResult settingsSyncPushResult = pushResult;
        if (settingsSyncPushResult instanceof SettingsSyncPushResult.Success) {
            this.settingsLog.setCloudPosition(positionToSetCloudBranch);
            SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(((SettingsSyncPushResult.Success)pushResult).getServerVersionId());
            SettingsSyncStatusTracker.Companion.getInstance().updateOnSuccess();
        } else if (settingsSyncPushResult instanceof SettingsSyncPushResult.Error) {
            SettingsSyncStatusTracker.Companion.getInstance().updateOnError(SettingsSyncBundle.INSTANCE.message("notification.title.push.error", new Object[0]) + ": " + ((SettingsSyncPushResult.Error)pushResult).getMessage());
        } else if (Intrinsics.areEqual((Object)settingsSyncPushResult, (Object)SettingsSyncPushResult.Rejected.INSTANCE)) {
            onRejectedPush.invoke();
        }
    }

    private final SettingsSyncPushResult pushToCloud(SettingsSnapshot settingsSnapshot, boolean force) {
        String versionId = SettingsSyncLocalSettings.Companion.getInstance().getKnownAndAppliedServerId();
        if (force) {
            return this.remoteCommunicator.push(settingsSnapshot, true, versionId);
        }
        ServerState serverState = this.remoteCommunicator.checkServerState();
        if (serverState instanceof ServerState.UpdateNeeded) {
            return SettingsSyncPushResult.Rejected.INSTANCE;
        }
        if (serverState instanceof ServerState.FileNotExists) {
            return this.remoteCommunicator.push(settingsSnapshot, true, versionId);
        }
        return this.remoteCommunicator.push(settingsSnapshot, false, versionId);
    }

    private final void pushToIde(SettingsSnapshot settingsSnapshot, SettingsLog.Position targetPosition, SettingsSyncState syncSettings) {
        this.ideMediator.applyToIde(settingsSnapshot, syncSettings);
        this.settingsLog.setIdePosition(targetPosition);
        LOG.info("Applied settings to the IDE.");
    }

    @TestOnly
    public final void waitForAllExecuted(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.queue.flush();
        this.queue.waitForAllExecuted(timeout, timeUnit);
    }

    @VisibleForTesting
    public final void suspendEventProcessing$intellij_settingsSync() {
        this.queue.suspend();
    }

    @VisibleForTesting
    public final void resumeEventProcessing$intellij_settingsSync() {
        this.queue.resume();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ ConcurrentList access$getPendingEvents$p(SettingsSyncBridge $this) {
        return $this.pendingEvents;
    }

    public static final /* synthetic */ SettingsSyncUpdateChecker access$getUpdateChecker$p(SettingsSyncBridge $this) {
        return $this.updateChecker;
    }

    public static final /* synthetic */ void access$processPendingEvents(SettingsSyncBridge $this) {
        $this.processPendingEvents();
    }

    public static final /* synthetic */ MergingUpdateQueue access$getQueue$p(SettingsSyncBridge $this) {
        return $this.queue;
    }

    public static final /* synthetic */ updateObject.1 access$getUpdateObject$p(SettingsSyncBridge $this) {
        return $this.updateObject;
    }

    public static final /* synthetic */ void access$processExclusiveEvent(SettingsSyncBridge $this, SyncSettingsEvent.ExclusiveEvent event) {
        $this.processExclusiveEvent(event);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncBridge.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0007H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$CurrentState;", "", "masterPosition", "Lcom/intellij/settingsSync/SettingsLog$Position;", "idePosition", "cloudPosition", "knownServerId", "", "(Lcom/intellij/settingsSync/SettingsLog$Position;Lcom/intellij/settingsSync/SettingsLog$Position;Lcom/intellij/settingsSync/SettingsLog$Position;Ljava/lang/String;)V", "getCloudPosition", "()Lcom/intellij/settingsSync/SettingsLog$Position;", "getIdePosition", "getKnownServerId", "()Ljava/lang/String;", "getMasterPosition", "toString", "intellij.settingsSync"})
    private static final class CurrentState {
        @NotNull
        private final SettingsLog.Position masterPosition;
        @NotNull
        private final SettingsLog.Position idePosition;
        @NotNull
        private final SettingsLog.Position cloudPosition;
        @Nullable
        private final String knownServerId;

        public CurrentState(@NotNull SettingsLog.Position masterPosition, @NotNull SettingsLog.Position idePosition, @NotNull SettingsLog.Position cloudPosition, @Nullable String knownServerId) {
            Intrinsics.checkNotNullParameter((Object)masterPosition, (String)"masterPosition");
            Intrinsics.checkNotNullParameter((Object)idePosition, (String)"idePosition");
            Intrinsics.checkNotNullParameter((Object)cloudPosition, (String)"cloudPosition");
            this.masterPosition = masterPosition;
            this.idePosition = idePosition;
            this.cloudPosition = cloudPosition;
            this.knownServerId = knownServerId;
        }

        @NotNull
        public final SettingsLog.Position getMasterPosition() {
            return this.masterPosition;
        }

        @NotNull
        public final SettingsLog.Position getIdePosition() {
            return this.idePosition;
        }

        @NotNull
        public final SettingsLog.Position getCloudPosition() {
            return this.cloudPosition;
        }

        @Nullable
        public final String getKnownServerId() {
            return this.knownServerId;
        }

        @NotNull
        public String toString() {
            return "CurrentState(masterPosition=" + this.masterPosition + ", idePosition=" + this.idePosition + ", cloudPosition=" + this.cloudPosition + ", knownServerId=" + this.knownServerId + ")";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "", "()V", "JustInit", "MigrateFromOldStorage", "PushToServer", "TakeFromServer", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$JustInit;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$MigrateFromOldStorage;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$PushToServer;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$TakeFromServer;", "intellij.settingsSync"})
    public static abstract class InitMode {
        private InitMode() {
        }

        public /* synthetic */ InitMode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$JustInit;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "()V", "intellij.settingsSync"})
        public static final class JustInit
        extends InitMode {
            @NotNull
            public static final JustInit INSTANCE = new JustInit();

            private JustInit() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$MigrateFromOldStorage;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "migration", "Lcom/intellij/settingsSync/SettingsSyncMigration;", "(Lcom/intellij/settingsSync/SettingsSyncMigration;)V", "getMigration", "()Lcom/intellij/settingsSync/SettingsSyncMigration;", "intellij.settingsSync"})
        public static final class MigrateFromOldStorage
        extends InitMode {
            @NotNull
            private final SettingsSyncMigration migration;

            public MigrateFromOldStorage(@NotNull SettingsSyncMigration migration) {
                Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
                super(null);
                this.migration = migration;
            }

            @NotNull
            public final SettingsSyncMigration getMigration() {
                return this.migration;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$PushToServer;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "()V", "intellij.settingsSync"})
        public static final class PushToServer
        extends InitMode {
            @NotNull
            public static final PushToServer INSTANCE = new PushToServer();

            private PushToServer() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$TakeFromServer;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "cloudEvent", "Lcom/intellij/settingsSync/SyncSettingsEvent$CloudChange;", "(Lcom/intellij/settingsSync/SyncSettingsEvent$CloudChange;)V", "getCloudEvent", "()Lcom/intellij/settingsSync/SyncSettingsEvent$CloudChange;", "intellij.settingsSync"})
        public static final class TakeFromServer
        extends InitMode {
            @NotNull
            private final SyncSettingsEvent.CloudChange cloudEvent;

            public TakeFromServer(@NotNull SyncSettingsEvent.CloudChange cloudEvent) {
                Intrinsics.checkNotNullParameter((Object)cloudEvent, (String)"cloudEvent");
                super(null);
                this.cloudEvent = cloudEvent;
            }

            @NotNull
            public final SyncSettingsEvent.CloudChange getCloudEvent() {
                return this.cloudEvent;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$PushRequestMode;", "", "(Ljava/lang/String;I)V", "PUSH_IF_NEEDED", "MUST_PUSH", "FORCE_PUSH", "intellij.settingsSync"})
    private static final class PushRequestMode
    extends Enum<PushRequestMode> {
        public static final /* enum */ PushRequestMode PUSH_IF_NEEDED = new PushRequestMode();
        public static final /* enum */ PushRequestMode MUST_PUSH = new PushRequestMode();
        public static final /* enum */ PushRequestMode FORCE_PUSH = new PushRequestMode();
        private static final /* synthetic */ PushRequestMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PushRequestMode[] values() {
            return (PushRequestMode[])$VALUES.clone();
        }

        public static PushRequestMode valueOf(String value) {
            return Enum.valueOf(PushRequestMode.class, value);
        }

        @NotNull
        public static EnumEntries<PushRequestMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pushRequestModeArray = new PushRequestMode[]{PushRequestMode.PUSH_IF_NEEDED, PushRequestMode.MUST_PUSH, PushRequestMode.FORCE_PUSH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

