/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparisonUtils {
    private static final Map<IElementType, OperatorTexts> operators = ComparisonUtils.createOperatorsMap();

    private ComparisonUtils() {
    }

    private static Map<IElementType, OperatorTexts> createOperatorsMap() {
        HashMap<IElementType, OperatorTexts> operators = new HashMap<IElementType, OperatorTexts>(8);
        operators.put(JSTokenTypes.EQEQ, new OperatorTexts("==", "!=", "=="));
        operators.put(JSTokenTypes.EQEQEQ, new OperatorTexts("===", "!==", "==="));
        operators.put(JSTokenTypes.NE, new OperatorTexts("!=", "==", "!="));
        operators.put(JSTokenTypes.NEQEQ, new OperatorTexts("!==", "===", "!=="));
        operators.put(JSTokenTypes.GT, new OperatorTexts(">", "<=", "<"));
        operators.put(JSTokenTypes.LT, new OperatorTexts("<", ">=", ">"));
        operators.put(JSTokenTypes.GE, new OperatorTexts(">=", "<", "<="));
        operators.put(JSTokenTypes.LE, new OperatorTexts("<=", ">", ">="));
        return operators;
    }

    public static boolean isComparison(@Nullable JSExpression exp) {
        return exp instanceof JSBinaryExpression && operators.containsKey(((JSBinaryExpression)exp).getOperationSign());
    }

    public static String getOperatorText(@NotNull IElementType operator) {
        if (operator == null) {
            ComparisonUtils.$$$reportNull$$$0(0);
        }
        return operators.get(operator).getText();
    }

    public static String getFlippedComparison(@NotNull IElementType str) {
        if (str == null) {
            ComparisonUtils.$$$reportNull$$$0(1);
        }
        return operators.get(str).getFlippedText();
    }

    public static String getFlippedOperatorText(@NotNull IElementType sign) {
        if (sign == null) {
            ComparisonUtils.$$$reportNull$$$0(2);
        }
        return ComparisonUtils.getFlippedComparison(sign);
    }

    public static boolean isEqualityComparison(@NotNull JSBinaryExpression operator) {
        IElementType sign;
        if (operator == null) {
            ComparisonUtils.$$$reportNull$$$0(3);
        }
        return JSTokenTypes.EQEQ.equals(sign = operator.getOperationSign()) || JSTokenTypes.NE.equals(sign);
    }

    public static String getNegatedComparison(@NotNull IElementType str) {
        if (str == null) {
            ComparisonUtils.$$$reportNull$$$0(4);
        }
        return operators.get(str).getNegatedText();
    }

    public static String getNegatedOperatorText(@NotNull IElementType sign) {
        if (sign == null) {
            ComparisonUtils.$$$reportNull$$$0(5);
        }
        return ComparisonUtils.getNegatedComparison(sign);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/inspectjs/utils/ComparisonUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOperatorText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFlippedComparison";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFlippedOperatorText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualityComparison";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNegatedComparison";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNegatedOperatorText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OperatorTexts {
        private final String text;
        private final String negatedText;
        private final String flippedText;

        OperatorTexts(String text2, String negatedText, String flippedText) {
            this.text = text2;
            this.negatedText = negatedText;
            this.flippedText = flippedText;
        }

        public String getText() {
            return this.text;
        }

        public String getNegatedText() {
            return this.negatedText;
        }

        public String getFlippedText() {
            return this.flippedText;
        }
    }
}

