/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.confusing.PointlessBooleanExpressionJSInspection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface CalculationResult {
    default public CalculationResult asSimplified() {
        return this;
    }

    default public boolean isSimplified() {
        return true;
    }

    @NotNull
    default public CalculationResult withExpression(@NotNull JSExpression expression) {
        if (expression == null) {
            CalculationResult.$$$reportNull$$$0(0);
        }
        CalculationResult calculationResult = this;
        if (calculationResult == null) {
            CalculationResult.$$$reportNull$$$0(1);
        }
        return calculationResult;
    }

    @NotNull
    public String getSimplifiedText();

    @NotNull
    public JSExpression getInitialExpression();

    @NotNull
    default public Set<CalculationResult> getSimplifiedResults() {
        Set<CalculationResult> set = this.isSimplified() ? Collections.singleton(this) : Collections.emptySet();
        if (set == null) {
            CalculationResult.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static CalculationResult createConstantResult(@NotNull CalculationResult result2, @NotNull JSExpression initialExpression) {
        if (result2 == null) {
            CalculationResult.$$$reportNull$$$0(3);
        }
        if (initialExpression == null) {
            CalculationResult.$$$reportNull$$$0(4);
        }
        if (CalculationResult.isTrueResult(result2)) {
            return new ConstantResult(initialExpression, ConstantType.TRUE);
        }
        if (CalculationResult.isNullResult(result2)) {
            return new ConstantResult(initialExpression, ConstantType.NULL);
        }
        if (CalculationResult.isUndefinedResult(result2)) {
            return new ConstantResult(initialExpression, ConstantType.UNDEFINED);
        }
        return new ConstantResult(initialExpression, ConstantType.FALSE);
    }

    public static boolean isTrueResult(@NotNull CalculationResult result2) {
        if (result2 == null) {
            CalculationResult.$$$reportNull$$$0(5);
        }
        return result2 instanceof ConstantResult && ((ConstantResult)result2).myType == ConstantType.TRUE;
    }

    public static boolean isFalseResult(@NotNull CalculationResult result2) {
        if (result2 == null) {
            CalculationResult.$$$reportNull$$$0(6);
        }
        return result2 instanceof ConstantResult && ((ConstantResult)result2).myType == ConstantType.FALSE;
    }

    public static boolean isNullResult(@NotNull CalculationResult result2) {
        if (result2 == null) {
            CalculationResult.$$$reportNull$$$0(7);
        }
        return result2 instanceof ConstantResult && ((ConstantResult)result2).myType == ConstantType.NULL;
    }

    public static boolean isUndefinedResult(@NotNull CalculationResult result2) {
        if (result2 == null) {
            CalculationResult.$$$reportNull$$$0(8);
        }
        return result2 instanceof ConstantResult && ((ConstantResult)result2).myType == ConstantType.UNDEFINED;
    }

    public static boolean isFalseNullUndefinedResult(@NotNull CalculationResult result2) {
        if (result2 == null) {
            CalculationResult.$$$reportNull$$$0(9);
        }
        return result2 instanceof ConstantResult && ((ConstantResult)result2).myType != ConstantType.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/confusing/CalculationResult";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/confusing/CalculationResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplifiedResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withExpression";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConstantResult";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTrueResult";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFalseResult";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNullResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUndefinedResult";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFalseNullUndefinedResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static final class ConstantResult
    implements CalculationResult {
        @NotNull
        private final JSExpression myInitialExpression;
        @NotNull
        public final ConstantType myType;

        public ConstantResult(@NotNull JSExpression initialExpression, @NotNull ConstantType type2) {
            if (initialExpression == null) {
                ConstantResult.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                ConstantResult.$$$reportNull$$$0(1);
            }
            this.myInitialExpression = initialExpression;
            this.myType = type2;
        }

        @NotNull
        public ConstantResult equalsResult(@NotNull ConstantResult result2, @NotNull JSExpression initialExpression, @NotNull IElementType sign) {
            if (result2 == null) {
                ConstantResult.$$$reportNull$$$0(2);
            }
            if (initialExpression == null) {
                ConstantResult.$$$reportNull$$$0(3);
            }
            if (sign == null) {
                ConstantResult.$$$reportNull$$$0(4);
            }
            if (!(!JSTokenTypes.EQEQ.equals(sign) || this.myType != ConstantType.NULL && this.myType != ConstantType.UNDEFINED || result2.myType != ConstantType.NULL && result2.myType != ConstantType.UNDEFINED)) {
                return new ConstantResult(initialExpression, ConstantType.TRUE);
            }
            return this.myType == result2.myType ? new ConstantResult(initialExpression, ConstantType.TRUE) : new ConstantResult(initialExpression, ConstantType.FALSE);
        }

        @NotNull
        public ConstantResult notEqualsResult(@NotNull ConstantResult result2, @NotNull JSExpression initialExpression, @NotNull IElementType sign) {
            if (result2 == null) {
                ConstantResult.$$$reportNull$$$0(5);
            }
            if (initialExpression == null) {
                ConstantResult.$$$reportNull$$$0(6);
            }
            if (sign == null) {
                ConstantResult.$$$reportNull$$$0(7);
            }
            if (!(!JSTokenTypes.NE.equals(sign) || this.myType != ConstantType.NULL && this.myType != ConstantType.UNDEFINED || result2.myType != ConstantType.NULL && result2.myType != ConstantType.UNDEFINED)) {
                return new ConstantResult(initialExpression, ConstantType.FALSE);
            }
            return this.myType == result2.myType ? new ConstantResult(initialExpression, ConstantType.FALSE) : new ConstantResult(initialExpression, ConstantType.TRUE);
        }

        @Override
        @NotNull
        public String getSimplifiedText() {
            String string = this.myType.getText();
            if (string == null) {
                ConstantResult.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public ConstantResult withExpression(@NotNull JSExpression expression) {
            if (expression == null) {
                ConstantResult.$$$reportNull$$$0(9);
            }
            return new ConstantResult(expression, this.myType);
        }

        @Override
        @NotNull
        public JSExpression getInitialExpression() {
            JSExpression jSExpression = this.myInitialExpression;
            if (jSExpression == null) {
                ConstantResult.$$$reportNull$$$0(10);
            }
            return jSExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/confusing/CalculationResult$ConstantResult";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/confusing/CalculationResult$ConstantResult";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimplifiedText";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "equalsResult";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "notEqualsResult";
                    break;
                }
                case 8: 
                case 10: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 10 -> new IllegalStateException(string);
            };
        }
    }

    public static enum ConstantType {
        TRUE("true"),
        FALSE("false"),
        UNDEFINED("undefined"),
        NULL("null");

        private final String text;

        private ConstantType(String text2) {
            this.text = text2;
        }

        String getText() {
            return this.text;
        }
    }

    public static final class NotResult
    implements CalculationResult {
        @NotNull
        private final CalculationResult myResult;
        @NotNull
        private final JSExpression myInitialExpression;

        NotResult(@NotNull JSExpression expression, boolean conditionContext, @NotNull JSExpression initialExpression) {
            if (expression == null) {
                NotResult.$$$reportNull$$$0(0);
            }
            if (initialExpression == null) {
                NotResult.$$$reportNull$$$0(1);
            }
            this.myInitialExpression = initialExpression;
            this.myResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(expression, conditionContext);
        }

        @Override
        @NotNull
        public JSExpression getInitialExpression() {
            JSExpression jSExpression = this.myInitialExpression;
            if (jSExpression == null) {
                NotResult.$$$reportNull$$$0(2);
            }
            return jSExpression;
        }

        @Override
        @NotNull
        public String getSimplifiedText() {
            JSExpression expression;
            if (this.myResult instanceof ConstantResult) {
                return CalculationResult.isTrueResult(this.myResult) ? "false" : "true";
            }
            if (this.myResult instanceof SimpleResult && (expression = ((SimpleResult)this.myResult).myExpression) != null) {
                String string = "!" + JSParenthesesUtils.getParenthesized(expression, 3);
                if (string == null) {
                    NotResult.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = "!" + this.myResult.getSimplifiedText();
            if (string == null) {
                NotResult.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialExpression";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/confusing/CalculationResult$NotResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/confusing/CalculationResult$NotResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimplifiedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ParenthesizedResult
    implements CalculationResult {
        @NotNull
        private final JSExpression myInitialExpression;
        @NotNull
        private final CalculationResult myResult;

        ParenthesizedResult(@NotNull CalculationResult result2, @NotNull JSExpression initialExpression) {
            if (result2 == null) {
                ParenthesizedResult.$$$reportNull$$$0(0);
            }
            if (initialExpression == null) {
                ParenthesizedResult.$$$reportNull$$$0(1);
            }
            this.myResult = result2;
            this.myInitialExpression = initialExpression;
        }

        @Override
        @NotNull
        public String getSimplifiedText() {
            JSExpression expression;
            if (this.myResult instanceof SimpleResult && ((expression = ((SimpleResult)this.myResult).myExpression) instanceof JSCallExpression || expression instanceof JSReferenceExpression || expression instanceof JSLiteralExpression)) {
                String string = this.myResult.getSimplifiedText();
                if (string == null) {
                    ParenthesizedResult.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.myResult instanceof NotResult) {
                String string = this.myResult.getSimplifiedText();
                if (string == null) {
                    ParenthesizedResult.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = "(" + this.myResult.getSimplifiedText() + ")";
            if (string == null) {
                ParenthesizedResult.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public JSExpression getInitialExpression() {
            JSExpression jSExpression = this.myInitialExpression;
            if (jSExpression == null) {
                ParenthesizedResult.$$$reportNull$$$0(5);
            }
            return jSExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialExpression";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/confusing/CalculationResult$ParenthesizedResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/confusing/CalculationResult$ParenthesizedResult";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimplifiedText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static final class SimpleResult
    implements CalculationResult {
        @Nullable
        private final JSExpression myExpression;
        private final boolean myCanBeSimplified;
        private final JSExpression myInitialExpression;

        SimpleResult(@Nullable JSExpression expression) {
            this(expression, expression, false);
        }

        SimpleResult(@Nullable JSExpression expression, boolean canBeSimplified) {
            this(expression, expression, canBeSimplified);
        }

        SimpleResult(@Nullable JSExpression expression, JSExpression initialExpression, boolean canBeSimplified) {
            this.myExpression = expression;
            this.myCanBeSimplified = canBeSimplified;
            this.myInitialExpression = initialExpression;
        }

        @Override
        public CalculationResult asSimplified() {
            return this.myCanBeSimplified ? this : new SimpleResult(this.myExpression, true);
        }

        @Override
        @NotNull
        public CalculationResult withExpression(@NotNull JSExpression expression) {
            if (expression == null) {
                SimpleResult.$$$reportNull$$$0(0);
            }
            return new SimpleResult(this.myExpression, expression, this.myCanBeSimplified);
        }

        @Override
        @NotNull
        public JSExpression getInitialExpression() {
            JSExpression jSExpression = this.myInitialExpression;
            if (jSExpression == null) {
                SimpleResult.$$$reportNull$$$0(1);
            }
            return jSExpression;
        }

        @Override
        public boolean isSimplified() {
            return this.myCanBeSimplified;
        }

        @Override
        @NotNull
        public String getSimplifiedText() {
            return this.myExpression != null ? this.myExpression.getText() : "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/confusing/CalculationResult$SimpleResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/confusing/CalculationResult$SimpleResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withExpression";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ComplexResult
    implements CalculationResult {
        @NotNull
        private final CalculationResult myLeftResult;
        @NotNull
        private final CalculationResult myRightResult;
        @NotNull
        private final IElementType mySign;
        @NotNull
        private final JSExpression myExpression;

        ComplexResult(@NotNull CalculationResult leftResult, @NotNull CalculationResult rightResult, @NotNull JSExpression expression, @NotNull IElementType sign) {
            if (leftResult == null) {
                ComplexResult.$$$reportNull$$$0(0);
            }
            if (rightResult == null) {
                ComplexResult.$$$reportNull$$$0(1);
            }
            if (expression == null) {
                ComplexResult.$$$reportNull$$$0(2);
            }
            if (sign == null) {
                ComplexResult.$$$reportNull$$$0(3);
            }
            this.myLeftResult = leftResult;
            this.myRightResult = rightResult;
            this.myExpression = expression;
            this.mySign = sign;
        }

        @Override
        @NotNull
        public JSExpression getInitialExpression() {
            JSExpression jSExpression = this.myExpression;
            if (jSExpression == null) {
                ComplexResult.$$$reportNull$$$0(4);
            }
            return jSExpression;
        }

        @Override
        @NotNull
        public Set<CalculationResult> getSimplifiedResults() {
            if (this.myLeftResult.isSimplified() != this.myRightResult.isSimplified()) {
                if (this.myLeftResult.isSimplified()) {
                    Set<CalculationResult> set = Collections.singleton(this.myLeftResult);
                    if (set == null) {
                        ComplexResult.$$$reportNull$$$0(5);
                    }
                    return set;
                }
                if (this.myRightResult.isSimplified()) {
                    Set<CalculationResult> set = Collections.singleton(this.myRightResult);
                    if (set == null) {
                        ComplexResult.$$$reportNull$$$0(6);
                    }
                    return set;
                }
            }
            Set<CalculationResult> set = Collections.singleton(this);
            if (set == null) {
                ComplexResult.$$$reportNull$$$0(7);
            }
            return set;
        }

        @Override
        @NotNull
        public CalculationResult withExpression(@NotNull JSExpression expression) {
            if (expression == null) {
                ComplexResult.$$$reportNull$$$0(8);
            }
            return new ComplexResult(this.myLeftResult, this.myRightResult, expression, this.mySign);
        }

        @Override
        @NotNull
        public String getSimplifiedText() {
            String string = this.myLeftResult.getSimplifiedText() + " " + ComplexResult.getSign(this.mySign) + " " + this.myRightResult.getSimplifiedText();
            if (string == null) {
                ComplexResult.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        private static String getSign(IElementType sign) {
            if (JSTokenTypes.EQEQ.equals(sign)) {
                return "==";
            }
            if (JSTokenTypes.ANDAND.equals(sign)) {
                return "&&";
            }
            if (JSTokenTypes.OROR.equals(sign)) {
                return "||";
            }
            if (JSTokenTypes.EQEQEQ.equals(sign)) {
                return "===";
            }
            if (JSTokenTypes.NE.equals(sign)) {
                return "!=";
            }
            if (JSTokenTypes.NEQEQ.equals(sign)) {
                return "!==";
            }
            if (JSTokenTypes.LT.equals(sign)) {
                return "<";
            }
            if (JSTokenTypes.GT.equals(sign)) {
                return ">";
            }
            if (JSTokenTypes.LE.equals(sign)) {
                return "<=";
            }
            if (JSTokenTypes.GE.equals(sign)) {
                return ">=";
            }
            if (JSTokenTypes.INSTANCEOF_KEYWORD.equals(sign)) {
                return "instanceof";
            }
            if (JSTokenTypes.IN_KEYWORD.equals(sign)) {
                return "in";
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightResult";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/confusing/CalculationResult$ComplexResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/confusing/CalculationResult$ComplexResult";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialExpression";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimplifiedResults";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimplifiedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7, 9 -> new IllegalStateException(string);
            };
        }
    }
}

