/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.util.RecursionUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class InfiniteRecursionJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("infinite.recursion.problem.descriptor", new Object[0]);
        if (string == null) {
            InfiniteRecursionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteRecursionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/InfiniteRecursionJSInspection", "buildErrorString"));
    }

    private static class InfiniteRecursionVisitor
    extends BaseInspectionVisitor {
        private InfiniteRecursionVisitor() {
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                InfiniteRecursionVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function2);
            if (!RecursionUtils.functionMayRecurse(function2)) {
                return;
            }
            if (!RecursionUtils.functionDefinitelyRecurses(function2)) {
                return;
            }
            this.registerFunctionError(function2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/bugs/InfiniteRecursionJSInspection$InfiniteRecursionVisitor", "visitJSFunctionDeclaration"));
        }
    }
}

