/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerCheckerTransferredData;
import com.intellij.lang.typescript.tsc.gen.Type;
import com.intellij.lang.typescript.tsc.gen.TypeBase;
import com.intellij.lang.typescript.tsc.gen.TypeObjectProperty;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0006J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bR \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerTransferredData;", "", "()V", "lastChecker", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerCheckerTransferredData;", "dropCaches", "", "getJSType", "Lcom/intellij/lang/javascript/psi/JSType;", "type", "Lcom/intellij/lang/typescript/tsc/gen/Type;", "getOrCreateChecker", "ideTypeCheckerId", "getType", "typeId", "putJSType", "jsType", "intellij.javascript.impl"})
public final class TypeScriptCompilerTransferredData {
    @NotNull
    private final AtomicReference<Pair<Integer, TypeScriptCompilerCheckerTransferredData>> lastChecker = new AtomicReference<Pair>(new Pair((Object)-1, (Object)new TypeScriptCompilerCheckerTransferredData()));

    @Nullable
    public final Type getType(int ideTypeCheckerId, int typeId) {
        Pair<Integer, TypeScriptCompilerCheckerTransferredData> pair = this.lastChecker.get();
        if (pair == null) {
            return null;
        }
        Pair<Integer, TypeScriptCompilerCheckerTransferredData> checkerPair = pair;
        if (((Number)checkerPair.getFirst()).intValue() != ideTypeCheckerId) {
            return null;
        }
        return ((TypeScriptCompilerCheckerTransferredData)checkerPair.getSecond()).getTypes().get(typeId);
    }

    @Nullable
    public final JSType getJSType(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Object object = ((TypeBase)type2).getData().get(TypeObjectProperty.ideCachedJSType);
        return object instanceof JSType ? (JSType)object : null;
    }

    public final void putJSType(@NotNull Type type2, @NotNull JSType jsType) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)jsType, (String)"jsType");
        ((Map)((TypeBase)type2).getData()).put(TypeObjectProperty.ideCachedJSType, jsType);
    }

    @NotNull
    public final TypeScriptCompilerCheckerTransferredData getOrCreateChecker(int ideTypeCheckerId) {
        Pair newData;
        Pair<Integer, TypeScriptCompilerCheckerTransferredData> checkerPair;
        do {
            if (((Number)(checkerPair = this.lastChecker.get()).getFirst()).intValue() == ideTypeCheckerId) {
                return (TypeScriptCompilerCheckerTransferredData)checkerPair.getSecond();
            }
            if (((Number)checkerPair.getFirst()).intValue() <= ideTypeCheckerId) continue;
            return new TypeScriptCompilerCheckerTransferredData();
        } while (!this.lastChecker.compareAndSet(checkerPair, (Pair<Integer, TypeScriptCompilerCheckerTransferredData>)(newData = new Pair((Object)ideTypeCheckerId, (Object)new TypeScriptCompilerCheckerTransferredData()))));
        return (TypeScriptCompilerCheckerTransferredData)newData.getSecond();
    }

    public final void dropCaches() {
        this.lastChecker.set((Pair<Integer, TypeScriptCompilerCheckerTransferredData>)new Pair((Object)-1, (Object)new TypeScriptCompilerCheckerTransferredData()));
    }
}

