/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/typescript/psi/ES6ReferenceImporter;", "Lcom/intellij/codeInsight/daemon/ReferenceImporter;", "()V", "computeAutoImportAtOffset", "Ljava/util/function/BooleanSupplier;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "allowCaretNearReference", "", "isAcceptableContext", "element", "Lcom/intellij/psi/PsiElement;", "isAddUnambiguousImportsOnTheFlyEnabled", "intellij.javascript.impl"})
public final class ES6ReferenceImporter
implements ReferenceImporter {
    @Nullable
    public BooleanSupplier computeAutoImportAtOffset(@NotNull Editor editor, @NotNull PsiFile file, int offset, boolean allowCaretNearReference) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = JSImportHandlingUtil.findUnresolvedImportableReference(editor, file, offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement expression = psiElement;
        if (Intrinsics.areEqual((Object)true, (Object)expression.getUserData(JSImportAction.NO_HINT_KEY)) || !this.isAcceptableContext(file, expression)) {
            return null;
        }
        return JSimportUtilKt.getSupplier(expression, editor);
    }

    public boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSApplicationSettings settings2 = JSApplicationSettings.getInstance();
        if (file instanceof JSFile) {
            return DialectDetector.isTypeScript((PsiElement)file) ? settings2.hasTSUnambiguousImportsOnTheFlyEffective(((JSFile)file).getProject()) : settings2.hasJSUnambiguousImportsOnTheFlyEffective(((JSFile)file).getProject()) && ES6PsiUtil.isExternalModule((PsiElement)file);
        }
        if (file instanceof HtmlCompatibleFile) {
            return settings2.hasTSUnambiguousImportsOnTheFlyEffective(((HtmlCompatibleFile)file).getProject()) || settings2.hasJSUnambiguousImportsOnTheFlyEffective(((HtmlCompatibleFile)file).getProject());
        }
        return false;
    }

    private final boolean isAcceptableContext(PsiFile file, PsiElement element) {
        if (file instanceof JSFile) {
            return true;
        }
        JSApplicationSettings settings2 = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings2.hasTSUnambiguousImportsOnTheFlyEffective(file.getProject()) : settings2.hasJSUnambiguousImportsOnTheFlyEffective(file.getProject()) && ES6PsiUtil.findExternalModule(element) != null;
    }
}

