/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.javascript.library.typings.TypingsNotReadyException;
import com.intellij.lang.typescript.lsp.JSServiceDownloader;
import com.intellij.lang.typescript.lsp.LspDownloadService;
import com.intellij.lang.typescript.lsp.LspServerDownloadingKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0007\u001a \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"downloadLspServer", "Ljava/util/concurrent/CompletableFuture;", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "npmPackage", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "getLspServerExecutablePath", "", "packageName", "relativeScriptPath", "scheduleLspServerDownloading", "", "downloader", "Lcom/intellij/lang/typescript/lsp/JSServiceDownloader;", "scheduleLspServerDownloadingTask", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nlspServerDownloading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 lspServerDownloading.kt\ncom/intellij/lang/typescript/lsp/LspServerDownloadingKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,156:1\n13#2:157\n31#3,2:158\n*S KotlinDebug\n*F\n+ 1 lspServerDownloading.kt\ncom/intellij/lang/typescript/lsp/LspServerDownloadingKt\n*L\n84#1:157\n96#1:158,2\n*E\n"})
public final class LspServerDownloadingKt {
    @Nullable
    public static final String getLspServerExecutablePath(@NotNull TypeScriptPackageName packageName, @NotNull String relativeScriptPath, @NotNull Project project) {
        String path2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                Intrinsics.checkNotNullParameter((Object)relativeScriptPath, (String)"relativeScriptPath");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                path2 = (String)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(packageName, project, null){
                    int label;
                    final /* synthetic */ TypeScriptPackageName $packageName;
                    final /* synthetic */ Project $project;
                    {
                        this.$packageName = $packageName;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                String string;
                                ResultKt.throwOnFailure((Object)object);
                                try {
                                    String string2;
                                    String string3 = TypeScriptExternalDefinitionsRegistry.Companion.getExactModuleTypingsPath(this.$packageName, this.$project);
                                    if (string3 != null) {
                                        String string4 = string3;
                                        TypeScriptPackageName typeScriptPackageName = this.$packageName;
                                        boolean bl = false;
                                        string2 = !TypeScriptExternalDefinitionsRegistry.Companion.getInstance().areExternalDefinitionsInstalling(typeScriptPackageName) ? string4 : null;
                                    } else {
                                        string2 = null;
                                    }
                                    string = string2;
                                }
                                catch (TypingsNotReadyException e) {
                                    boolean $i$f$logger = false;
                                    Logger logger = Logger.getInstance(LspDownloadService.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                    logger.info("Package is not ready: " + e.getMessage());
                                    string = null;
                                }
                                return string;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                if (path2 == null) break block2;
                Path path3 = Paths.get(path2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                Path path4 = path3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block3;
            }
            return null;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LspDownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Found typings: " + path2);
        return path2 + FileUtil.toSystemDependentName((String)relativeScriptPath);
    }

    @Deprecated(message="Use getLspServerExecutablePath(TypeScriptPackageName, String, Project) instead")
    @Nullable
    public static final String getLspServerExecutablePath(@NotNull TypeScriptPackageName packageName, @NotNull String relativeScriptPath) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)relativeScriptPath, (String)"relativeScriptPath");
        String string = TypeScriptExternalDefinitionsRegistry.Companion.getExactModuleTypingsPath$default(TypeScriptExternalDefinitionsRegistry.Companion, packageName, null, 2, null);
        if (string == null) {
            return null;
        }
        String path2 = string;
        Path path3 = Paths.get(path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path path4 = path3;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? null : path2 + FileUtil.toSystemDependentName((String)relativeScriptPath);
    }

    public static final void scheduleLspServerDownloading(@NotNull Project project, @NotNull JSServiceDownloader downloader) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<LspDownloadService> serviceClass$iv = LspDownloadService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LspDownloadService downloadService = (LspDownloadService)object;
        downloadService.scheduleDownload(downloader);
    }

    private static final void scheduleLspServerDownloadingTask(Project project, JSServiceDownloader downloader) {
        TypeScriptPackageName serverPackage = downloader.getPackageDescriptor().getServerPackage();
        Object[] objectArray = new Object[]{serverPackage.getName()};
        String string = JavaScriptBundle.message("npm.downloading_package", objectArray);
        objectArray = Task.Backgroundable.ALWAYS_BACKGROUND;
        new Task.Backgroundable(project, downloader, serverPackage, string, (PerformInBackgroundOption)objectArray){
            final /* synthetic */ Project $project;
            final /* synthetic */ JSServiceDownloader $downloader;
            final /* synthetic */ TypeScriptPackageName $serverPackage;
            {
                this.$project = $project;
                this.$downloader = $downloader;
                this.$serverPackage = $serverPackage;
                super($project, $super_call_param$1, true, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (this.$downloader.getExecutable(this.$project) != null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(LspDownloadService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Package is ready, skipping download");
                    this.$downloader.restartService(this.$project);
                    return;
                }
                indicator.setIndeterminate(true);
                CompletableFuture future = LspServerDownloadingKt.access$downloadLspServer(this.$project, indicator, this.$serverPackage);
                future.whenComplete((arg_0, arg_1) -> scheduleLspServerDownloadingTask.1.run$lambda$0((Function2)new Function2<Path, Throwable, Unit>(this.$downloader, this.$project){
                    final /* synthetic */ JSServiceDownloader $downloader;
                    final /* synthetic */ Project $project;
                    {
                        this.$downloader = $downloader;
                        this.$project = $project;
                        super(2);
                    }

                    public final void invoke(@Nullable Path packagePath, Throwable throwable) {
                        if (packagePath != null) {
                            this.$downloader.restartService(this.$project);
                        }
                    }
                }, arg_0, arg_1));
            }

            private static final void run$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        }.queue();
    }

    private static final CompletableFuture<Path> downloadLspServer(Project project, ProgressIndicator indicator, TypeScriptPackageName npmPackage) {
        CompletableFuture<Path> completableFuture = CompletableFuture.supplyAsync(() -> LspServerDownloadingKt.downloadLspServer$lambda$0(indicator, npmPackage, project), AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final Path downloadLspServer$lambda$0(ProgressIndicator $indicator, TypeScriptPackageName $npmPackage, Project $project) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$npmPackage, (String)"$npmPackage");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        TypeScriptExternalDefinitionsRegistry definitionsRegistry = TypeScriptExternalDefinitionsRegistry.Companion.getInstance();
        ProgressWrapper installProgress = (ProgressWrapper)new SensitiveProgressWrapper($indicator);
        Future<Path> future = definitionsRegistry.installPackageWithoutVfsRefresh$intellij_javascript_impl($npmPackage, $project, (ProgressIndicator)installProgress);
        try {
            path2 = future.get(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Object[] objectArray = new Object[]{$npmPackage.getName()};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
        catch (ExecutionException e) {
            Object[] objectArray = new Object[]{$npmPackage.getName()};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
        catch (TimeoutException e) {
            installProgress.cancel();
            Object[] objectArray = new Object[]{$npmPackage.getName()};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
        return path2;
    }

    public static final /* synthetic */ void access$scheduleLspServerDownloadingTask(Project project, JSServiceDownloader downloader) {
        LspServerDownloadingKt.scheduleLspServerDownloadingTask(project, downloader);
    }

    public static final /* synthetic */ CompletableFuture access$downloadLspServer(Project project, ProgressIndicator indicator, TypeScriptPackageName npmPackage) {
        return LspServerDownloadingKt.downloadLspServer(project, indicator, npmPackage);
    }
}

