/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.typescript.lsp.LspServerDownloader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH$J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\rH&J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "", "lspServerDownloader", "Lcom/intellij/lang/typescript/lsp/LspServerDownloader;", "(Lcom/intellij/lang/typescript/lsp/LspServerDownloader;)V", "forceEnabled", "", "getLspServerDownloader", "()Lcom/intellij/lang/typescript/lsp/LspServerDownloader;", "isEnabledByContextAndSettings", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEnabledByEnvironment", "isEnabledInSettings", "isFileAcceptableForLspServer", "file", "isForceEnabledInTests", "isLspServerEnabledAndAvailable", "isProjectContext", "markForceEnabled", "", "value", "intellij.javascript.impl"})
@ApiStatus.Experimental
public abstract class LspServerActivationRule {
    @NotNull
    private final LspServerDownloader lspServerDownloader;
    private boolean forceEnabled;

    public LspServerActivationRule(@NotNull LspServerDownloader lspServerDownloader) {
        Intrinsics.checkNotNullParameter((Object)lspServerDownloader, (String)"lspServerDownloader");
        this.lspServerDownloader = lspServerDownloader;
    }

    @NotNull
    public final LspServerDownloader getLspServerDownloader() {
        return this.lspServerDownloader;
    }

    public abstract boolean isFileAcceptableForLspServer(@NotNull VirtualFile var1);

    protected abstract boolean isProjectContext(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean isEnabledInSettings(@NotNull Project var1);

    public final boolean isLspServerEnabledAndAvailable(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.isFileAcceptableForLspServer(context2) && this.isEnabledByContextAndSettings(project, context2) && this.lspServerDownloader.getExecutableOrRefresh(project) != null;
    }

    protected final boolean isEnabledByContextAndSettings(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isForceEnabledInTests()) {
            return true;
        }
        return this.isEnabledByEnvironment(project, context2) && this.isEnabledInSettings(project) && this.isProjectContext(project, context2);
    }

    protected boolean isEnabledByEnvironment(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !ApplicationManager.getApplication().isUnitTestMode();
    }

    private final boolean isForceEnabledInTests() {
        return ApplicationManager.getApplication().isUnitTestMode() && this.forceEnabled;
    }

    @TestOnly
    public final void markForceEnabled(boolean value) {
        this.forceEnabled = value;
    }
}

