/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.typescript.lsp.JSServiceDownloader;
import com.intellij.lang.typescript.lsp.LspDownloadService;
import com.intellij.lang.typescript.lsp.LspServerDownloadingKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/typescript/lsp/LspDownloadService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "attempts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "Ljava/util/concurrent/atomic/AtomicInteger;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dispose", "", "flush", "scheduleDownload", "downloader", "Lcom/intellij/lang/typescript/lsp/JSServiceDownloader;", "intellij.javascript.impl"})
public final class LspDownloadService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final ConcurrentHashMap<TypeScriptPackageName, AtomicInteger> attempts;

    public LspDownloadService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.queue = new MergingUpdateQueue("Lsp downloading queue", 300, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.attempts = new ConcurrentHashMap();
    }

    public final void scheduleDownload(@NotNull JSServiceDownloader downloader) {
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        TypeScriptPackageName serverPackage = downloader.getPackageDescriptor().getServerPackage();
        this.queue.queue(new Update(serverPackage, this, downloader){
            final /* synthetic */ TypeScriptPackageName $serverPackage;
            final /* synthetic */ LspDownloadService this$0;
            final /* synthetic */ JSServiceDownloader $downloader;
            {
                this.$serverPackage = $serverPackage;
                this.this$0 = $receiver;
                this.$downloader = $downloader;
                super((Object)$serverPackage);
            }

            public void run() {
                if (TypeScriptExternalDefinitionsRegistry.Companion.getInstance().areExternalDefinitionsInstalling(this.$serverPackage)) {
                    return;
                }
                AtomicInteger atomicInteger = LspDownloadService.access$getAttempts$p(this.this$0).computeIfAbsent(this.$serverPackage, arg_0 -> scheduleDownload.1.run$lambda$0(scheduleDownload.run.counter.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)atomicInteger, (String)"computeIfAbsent(...)");
                AtomicInteger counter2 = atomicInteger;
                int value = counter2.incrementAndGet();
                if (value > 10 && value % 100 != 0) {
                    return;
                }
                LspServerDownloadingKt.access$scheduleLspServerDownloadingTask(LspDownloadService.access$getProject$p(this.this$0), this.$downloader);
            }

            private static final AtomicInteger run$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (AtomicInteger)$tmp0.invoke(p0);
            }
        });
    }

    public final void flush() {
        this.queue.flush();
    }

    public void dispose() {
    }

    public static final /* synthetic */ ConcurrentHashMap access$getAttempts$p(LspDownloadService $this) {
        return $this.attempts;
    }

    public static final /* synthetic */ Project access$getProject$p(LspDownloadService $this) {
        return $this.project;
    }
}

