/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsNodeDescriptor;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsPackageResolver;
import com.intellij.lang.typescript.lsp.LspServerDownloadingKt;
import com.intellij.lang.typescript.lsp.LspServerPackageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/typescript/lsp/JSServiceDownloader;", "", "packageDescriptor", "Lcom/intellij/lang/typescript/lsp/LspServerPackageDescriptor;", "(Lcom/intellij/lang/typescript/lsp/LspServerPackageDescriptor;)V", "getPackageDescriptor", "()Lcom/intellij/lang/typescript/lsp/LspServerPackageDescriptor;", "createNodePackageField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "project", "Lcom/intellij/openapi/project/Project;", "getExecutable", "", "packageRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "getExecutableForDefaultKey", "getExecutableOrRefresh", "getSelectedPackageRef", "restartService", "", "Lcom/intellij/lang/typescript/lsp/LspServerDownloader;", "Lcom/intellij/lang/typescript/lsp/TSPluginDownloader;", "intellij.javascript.impl"})
@ApiStatus.Experimental
public abstract class JSServiceDownloader {
    @NotNull
    private final LspServerPackageDescriptor packageDescriptor;

    private JSServiceDownloader(LspServerPackageDescriptor packageDescriptor) {
        this.packageDescriptor = packageDescriptor;
    }

    @NotNull
    public final LspServerPackageDescriptor getPackageDescriptor() {
        return this.packageDescriptor;
    }

    @NotNull
    public NodePackageRef getSelectedPackageRef(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ExternalDefinitionsNodePackageKt.createPackageRef("Default", this.packageDescriptor.getServerPackage());
    }

    @Nullable
    public final String getExecutable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NodePackageRef packageRef = this.getSelectedPackageRef(project);
        return this.getExecutable(project, packageRef);
    }

    @Nullable
    public final String getExecutable(@NotNull Project project, @NotNull NodePackageRef packageRef) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageRef, (String)"packageRef");
        String ref = ExternalDefinitionsNodePackageKt.extractRefText(packageRef);
        if (Intrinsics.areEqual((Object)ref, (Object)"Default")) {
            return this.getExecutableForDefaultKey(project);
        }
        String string = FileUtil.toSystemDependentName((String)this.packageDescriptor.getPackageRelativePath(project, packageRef));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String suffix = string;
        return StringsKt.endsWith$default((String)ref, (String)suffix, (boolean)false, (int)2, null) ? ref : ref + suffix;
    }

    @Nullable
    protected String getExecutableForDefaultKey(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return LspServerDownloadingKt.getLspServerExecutablePath(this.packageDescriptor.getServerPackage(), this.packageDescriptor.getDefaultPackageRelativePath(), project);
    }

    @Nullable
    public final String getExecutableOrRefresh(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String executable = this.getExecutable(project);
        if (executable != null) {
            return executable;
        }
        LspServerDownloadingKt.scheduleLspServerDownloading(project, this);
        return null;
    }

    @NotNull
    public final NodePackageField createNodePackageField(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JSExternalDefinitionsNodeDescriptor serverDescriptor = new JSExternalDefinitionsNodeDescriptor(this.packageDescriptor.getServerPackage());
        return new NodePackageField(project, (NodePackageDescriptor)serverDescriptor, () -> JSServiceDownloader.createNodePackageField$lambda$0(project), (NodePackageRefResolver)new JSExternalDefinitionsPackageResolver(project, serverDescriptor));
    }

    public void restartService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().invokeLater(() -> JSServiceDownloader.restartService$lambda$1(project));
    }

    private static final NodeJsInterpreter createNodePackageField$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return NodeJsInterpreterManager.getInstance($project).getInterpreter();
    }

    private static final void restartService$lambda$1(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        TypeScriptService.Companion.restartServices($project);
    }

    public /* synthetic */ JSServiceDownloader(LspServerPackageDescriptor packageDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(packageDescriptor);
    }
}

