/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSNodeServicesProfilerActionKt;
import com.intellij.lang.typescript.lsp.LspServerActivationRule;
import com.intellij.lang.typescript.lsp.LspServerDownloader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0014J\n\u0010!\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u001fH\u0016J\u000e\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u001fJ\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lcom/intellij/lang/typescript/lsp/JSLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "activationRule", "Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "presentableName", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;Ljava/lang/String;)V", "getActivationRule", "()Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "lspServerListener", "Lcom/intellij/platform/lsp/api/LspServerListener;", "getLspServerListener", "()Lcom/intellij/platform/lsp/api/LspServerListener;", "nodeTarget", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "getNodeTarget", "()Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "setNodeTarget", "(Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;)V", "<set-?>", "Lcom/intellij/util/text/SemVer;", "version", "getVersion", "()Lcom/intellij/util/text/SemVer;", "setVersion", "(Lcom/intellij/util/text/SemVer;)V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "findLocalFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "getCommandLineArgsFromRegistry", "getFilePath", "file", "isSupportedFile", "", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJSLspServerDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLspServerDescriptor.kt\ncom/intellij/lang/typescript/lsp/JSLspServerDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public abstract class JSLspServerDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final LspServerActivationRule activationRule;
    @Nullable
    private NodeTargetRun nodeTarget;
    @Nullable
    private SemVer version;
    @NotNull
    private final LspServerListener lspServerListener;

    public JSLspServerDescriptor(@NotNull Project project, @NotNull LspServerActivationRule activationRule, @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activationRule, (String)"activationRule");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        super(project, presentableName);
        this.activationRule = activationRule;
        this.lspServerListener = new LspServerListener(this){
            final /* synthetic */ JSLspServerDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void serverInitialized(@NotNull InitializeResult params) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    ServerInfo serverInfo = params.getServerInfo();
                    SemVer semVer = SemVer.parseFromText((String)(serverInfo != null ? serverInfo.getVersion() : null));
                    if (semVer == null) break block0;
                    SemVer semVer2 = semVer;
                    JSLspServerDescriptor jSLspServerDescriptor = this.this$0;
                    SemVer it = semVer2;
                    boolean bl = false;
                    jSLspServerDescriptor.setVersion(it);
                }
            }
        };
    }

    @NotNull
    protected LspServerActivationRule getActivationRule() {
        return this.activationRule;
    }

    @Nullable
    protected final NodeTargetRun getNodeTarget() {
        return this.nodeTarget;
    }

    protected final void setNodeTarget(@Nullable NodeTargetRun nodeTargetRun) {
        this.nodeTarget = nodeTargetRun;
    }

    @Nullable
    public final SemVer getVersion() {
        return this.version;
    }

    protected final void setVersion(@Nullable SemVer semVer) {
        this.version = semVer;
    }

    @NotNull
    public final GeneralCommandLine createCommandLine() {
        throw new RuntimeException();
    }

    @NotNull
    public OSProcessHandler startServerProcess() {
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(this.getProject()).getInterpreter();
        if (!(interpreter2 instanceof NodeJsLocalInterpreter) && !(interpreter2 instanceof WslNodeInterpreter)) {
            throw new ExecutionException(JavaScriptBundle.message("lsp.interpreter.error", new Object[0]));
        }
        LspServerDownloader downloader = this.getActivationRule().getLspServerDownloader();
        NodePackageRef selectedPackageRef = downloader.getSelectedPackageRef(this.getProject());
        NodePackage nodePackage = selectedPackageRef.getConstantPackage();
        if (nodePackage == null) {
            Object[] objectArray = new Object[]{this.getPresentableName()};
            throw new ExecutionException(JavaScriptBundle.message("lsp.executable.error", objectArray));
        }
        NodePackage nodePackage2 = nodePackage;
        String executable = downloader.getExecutable(this.getProject());
        if (executable == null) {
            Object[] objectArray = new Object[]{nodePackage2.getName()};
            throw new ExecutionException(JavaScriptBundle.message("lsp.executable.error", objectArray));
        }
        NodeTargetRun target = new NodeTargetRun(interpreter2, this.getProject(), null, NodeTargetRunOptions.Companion.of$default(NodeTargetRunOptions.Companion, false, null, null, 6, null), null, 16, null);
        TargetedCommandLineBuilder builder2 = target.getCommandLineBuilder();
        JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(builder2, this.getPresentableName(), this::getCommandLineArgsFromRegistry);
        String string = this.getProject().getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            builder2.setWorkingDirectory(target.path(it));
        }
        if (JSNodeServicesProfilerActionKt.isNodeServicesProfilerEnabled(this.getProject())) {
            builder2.addParameter("--prof");
        }
        builder2.addParameter(target.path(executable));
        builder2.addParameter("--stdio");
        builder2.setCharset(Charsets.UTF_8);
        LspServerDescriptor.LOG.info("Starting " + ((Object)((Object)this)).getClass().getName() + " LSP server. Node.js version " + interpreter2.getCachedVersion() + ", path: " + interpreter2.getPresentableName());
        ProcessWithCmdLine process = (ProcessWithCmdLine)NodeProgressUtil.withInvisibleProgress(() -> JSLspServerDescriptor.startServerProcess$lambda$1(target));
        this.nodeTarget = target;
        this.version = nodePackage2.getVersion();
        return (OSProcessHandler)process.getProcessHandler();
    }

    @Nullable
    protected String getCommandLineArgsFromRegistry() {
        return null;
    }

    @NotNull
    public String getFilePath(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            Object object2;
            block5: {
                block4: {
                    object2 = this.nodeTarget;
                    if (object2 == null) break block4;
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if ((object2 = ((NodeTargetRun)object2).convertLocalPathToTargetPath(string)) != null) break block5;
                }
                object2 = super.getFilePath(file);
            }
            object = object2;
        }
        catch (IllegalArgumentException e) {
            LspServerDescriptor.LOG.error((Throwable)e);
            object = super.getFilePath(file);
        }
        return object;
    }

    @Nullable
    protected VirtualFile findLocalFileByPath(@NotNull String path2) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            NodeTargetRun nodeTargetRun = this.nodeTarget;
            Intrinsics.checkNotNull((Object)nodeTargetRun);
            virtualFile = super.findLocalFileByPath(nodeTargetRun.convertTargetPathToLocalPath(path2));
        }
        catch (IllegalArgumentException e) {
            LspServerDescriptor.LOG.error((Throwable)e);
            virtualFile = super.findLocalFileByPath(path2);
        }
        return virtualFile;
    }

    public final boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getActivationRule().isFileAcceptableForLspServer(file);
    }

    @NotNull
    public LspServerListener getLspServerListener() {
        return this.lspServerListener;
    }

    private static final ProcessWithCmdLine startServerProcess$lambda$1(NodeTargetRun $target) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        return $target.startProcessEx();
    }
}

