/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.inspection.TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix;
import com.intellij.lang.typescript.inspection.TypeScriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.lang.typescript.inspection.TypescriptRemoveTypeDeclarationQuickFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptExplicitMemberTypeInspection
extends JSInspection {
    public static final String SHORT_NAME = "TypeScriptExplicitMemberType";

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.settingLink((String)JavaScriptBundle.message("js.generated.types.settings.link", new Object[0]), (String)CodeStyleConfigurableWrapper.getConfigurableId((String)JavaScriptBundle.message("typescript.code.style.tab.name", new Object[0])), (String)ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]))});
        if (optPane == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(2);
        }
        CodeStyleSettings settings2 = CodeStyle.getSettings((PsiFile)holder.getFile());
        final TypeScriptCodeStyleSettings tsSettings = (TypeScriptCodeStyleSettings)settings2.getCustomSettings(TypeScriptCodeStyleSettings.class);
        return new JSElementVisitor(){

            @Override
            public void visitJSDestructuringElement(@NotNull JSDestructuringElement destructuringElement) {
                if (destructuringElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitNode(destructuringElement, (PsiElement)destructuringElement.getTarget(), tsSettings.PREFER_EXPLICIT_TYPES_VARS_FIELDS);
            }

            @Override
            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (node instanceof TypeScriptEnumField || !(node instanceof TypeScriptVariable) && !(node instanceof TypeScriptField) && !(node instanceof TypeScriptParameter)) {
                    return;
                }
                this.visitNode(node, node.getNameIdentifier(), tsSettings.PREFER_EXPLICIT_TYPES_VARS_FIELDS);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(node instanceof TypeScriptFunction)) {
                    return;
                }
                this.visitNode(node, node.getNameIdentifier(), tsSettings.PREFER_EXPLICIT_TYPES_FUNCTION_RETURNS);
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!(node instanceof TypeScriptFunction)) {
                    return;
                }
                PsiElement toHighlight = node.getNameIdentifier();
                if (toHighlight == null || !PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)toHighlight, (boolean)true)) {
                    ASTNode keyword;
                    ASTNode arrowNode = JSPsiImplUtils.getFunctionArrowNode(node);
                    toHighlight = arrowNode != null ? arrowNode.getPsi() : ((keyword = node.getNode().findChildByType(JSTokenTypes.FUNCTION_KEYWORD)) == null ? null : keyword.getPsi());
                }
                this.visitNode(node, toHighlight, tsSettings.PREFER_EXPLICIT_TYPES_FUNCTION_EXPRESSION_RETURNS);
            }

            private void visitNode(@NotNull JSElement node, PsiElement elementToHighlight, boolean preferExplicitTypes) {
                if (node == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!TypeScriptExplicitMemberTypeInspection.isSupportedDialect(node)) {
                    return;
                }
                if (PsiUtilCore.hasErrorElementChild((PsiElement)node)) {
                    return;
                }
                this.inspectForRedundantTypeDeclaration(node, preferExplicitTypes);
                this.inspectForMissingDeclaration(node, elementToHighlight, preferExplicitTypes);
            }

            private void inspectForMissingDeclaration(@NotNull JSElement node, @Nullable PsiElement elementToHighlight, boolean preferExplicitTypes) {
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (elementToHighlight == null) {
                    return;
                }
                if (TypeScriptPsiUtil.returnTypeAnnotationForbidden(node)) {
                    return;
                }
                if (!TypeScriptSpecifyTypeExplicitlyQuickFix.isAvailable((PsiElement)node)) {
                    return;
                }
                if (TypeScriptExplicitMemberTypeInspection.getTypeDeclarationElement(node) == null) {
                    ProblemHighlightType highlightType;
                    JSType inferredType = TypeScriptExplicitMemberTypeInspection.getInferredType(CompletionUtil.getOriginalOrSelf((PsiElement)node));
                    if (inferredType == null || inferredType instanceof JSUniqueSymbolTypeImpl) {
                        return;
                    }
                    ProblemHighlightType problemHighlightType = highlightType = preferExplicitTypes ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION;
                    if (holder.isOnTheFly() || preferExplicitTypes) {
                        LocalQuickFix[] allFixes = new LocalQuickFix[]{new TypeScriptSpecifyTypeExplicitlyQuickFix()};
                        if (node instanceof JSParameter && TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.shouldSuggestMultiParamFix((JSParameter)node)) {
                            allFixes = new LocalQuickFix[]{new TypeScriptSpecifyTypeExplicitlyQuickFix(), new TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix()};
                        }
                        holder.registerProblem(elementToHighlight, JavaScriptBundle.message("typescript.specify.type.explicitly", new Object[0]), highlightType, allFixes);
                    }
                }
            }

            private void inspectForRedundantTypeDeclaration(@NotNull JSElement declarationOwner, boolean preferExplicitTypes) {
                boolean isRedundant;
                JSElement declarationElement;
                if (declarationOwner == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((declarationElement = TypeScriptExplicitMemberTypeInspection.getTypeDeclarationElement(declarationOwner)) == null) {
                    return;
                }
                boolean bl = isRedundant = !preferExplicitTypes && TypeScriptExplicitMemberTypeInspection.isRedundantDeclaration(declarationOwner);
                if (!isRedundant) {
                    return;
                }
                LocalQuickFix[] quickFixes = new LocalQuickFix[]{new TypescriptRemoveTypeDeclarationQuickFix()};
                String message = JavaScriptBundle.message("typescript.redundant.declaration", new Object[0]);
                holder.registerProblem((PsiElement)declarationElement, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, quickFixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringElement";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declarationOwner";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptExplicitMemberTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDestructuringElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNode";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForMissingDeclaration";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForRedundantTypeDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isSupportedDialect(@NotNull JSElement node) {
        DialectOptionHolder dialect;
        if (node == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(3);
        }
        return (dialect = DialectDetector.dialectOfElement((PsiElement)node)) != null && dialect.isTypeScript;
    }

    private static boolean isRedundantDeclaration(@NotNull JSElement declarationOwner) {
        JSType typeFromDeclaration;
        if (declarationOwner == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(4);
        }
        if ((typeFromDeclaration = JSPsiImplUtils.getTypeFromDeclaration(declarationOwner = (JSElement)CompletionUtil.getOriginalOrSelf((PsiElement)declarationOwner))) instanceof JSUniqueSymbolTypeImpl) {
            return false;
        }
        return TypeScriptExplicitMemberTypeInspection.isRedundantDeclaration(TypeScriptExplicitMemberTypeInspection.getInferredType((PsiElement)declarationOwner), typeFromDeclaration, (PsiElement)declarationOwner);
    }

    private static boolean isRedundantDeclaration(@Nullable JSType inferredType, @Nullable JSType declaredType, @NotNull PsiElement declarationOwner) {
        if (declarationOwner == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(5);
        }
        inferredType = JSTypeUtils.getValuableType(inferredType, declarationOwner);
        return (declaredType = JSTypeUtils.getValuableType(declaredType, declarationOwner)) != null && inferredType != null && !JSTypeCastUtil.isAlwaysAssignableType(declaredType, null) && !JSTypeCastUtil.isAlwaysAssignableType(inferredType, null) && TypeScriptExplicitMemberTypeInspection.isEquivalent(inferredType, declaredType);
    }

    private static boolean isEquivalent(@NotNull JSType inferredType, @NotNull JSType declaredType) {
        if (inferredType == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(6);
        }
        if (declaredType == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(7);
        }
        if (declaredType instanceof JSExoticStringLiteralType) {
            declaredType = ((JSExoticStringLiteralType)((Object)declaredType)).asSimpleLiteralType();
        }
        ProcessingContext context2 = new ProcessingContext();
        context2.put(JSTypeBaseImpl.EQ_EVALUATED, (Object)Boolean.TRUE);
        return inferredType.isEquivalentTo(declaredType, context2);
    }

    @Nullable
    public static JSElement getTypeDeclarationElement(@NotNull JSElement element) {
        if (element == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(8);
        }
        if (element instanceof JSTypeDeclarationOwner) {
            return (JSElement)((JSTypeDeclarationOwner)element).getTypeElement();
        }
        if (element instanceof JSFunction) {
            return (JSElement)((JSFunction)element).getReturnTypeElement();
        }
        return null;
    }

    @Nullable
    public static JSType getInferredType(@NotNull PsiElement element) {
        JSType typeFromUsage;
        if (element == null) {
            TypeScriptExplicitMemberTypeInspection.$$$reportNull$$$0(9);
        }
        if ((typeFromUsage = TypeFromUsageDetector.detectTypeFromUsage(element)) != null) {
            return typeFromUsage;
        }
        if (!(element instanceof JSFieldVariable) || ((JSFieldVariable)element).getTypeElement() != null || JSDestructuringUtil.isDestructuring(element.getParent())) {
            return null;
        }
        return TypeScriptTypeRelations.expandAndOptimizeElementTypeRecursive(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptExplicitMemberTypeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationOwner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptExplicitMemberTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRedundantDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDeclarationElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

