/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.hint;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.psi.JSArgumentsHolder;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/typescript/hint/TypeScriptParameterInfoHandler;", "Lcom/intellij/javascript/JSParameterInfoHandler;", "()V", "fillSignaturesForArgumentList", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "context", "Lcom/intellij/lang/parameterInfo/CreateParameterInfoContext;", "argList", "Lcom/intellij/lang/javascript/psi/JSArgumentsHolder;", "skipTypeScript", "", "intellij.javascript.impl"})
public final class TypeScriptParameterInfoHandler
extends JSParameterInfoHandler {
    @Override
    @Nullable
    protected Sequence<JSFunctionType> fillSignaturesForArgumentList(@NotNull CreateParameterInfoContext context2, @NotNull JSArgumentsHolder argList) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argList, (String)"argList");
        Sequence<JSFunctionType> result2 = super.fillSignaturesForArgumentList(context2, argList);
        if (result2 != null) {
            return result2;
        }
        PsiFile file = context2.getFile();
        Project project = context2.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow || !TypeScriptLanguageServiceUtil.useServiceParameterInfo(project, virtualFile)) {
            return null;
        }
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNull((Object)virtualFile);
        TypeScriptService service2 = TypeScriptService.Companion.getForFile(project, virtualFile);
        if (service2 == null) {
            return null;
        }
        Intrinsics.checkNotNull((Object)file);
        Future<Stream<JSFunctionType>> future = service2.getSignatureHelp(file, context2);
        Stream<JSFunctionType> stream = JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.getShortTimeout(), 5L, null);
        return stream != null ? StreamsKt.asSequence(stream) : null;
    }

    @Override
    protected boolean skipTypeScript() {
        return false;
    }
}

