/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.editing.JavaScriptInlayParameterHintsProvider;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.typescript.editing.TypeScriptInlayHintsSupportedService;
import com.intellij.openapi.keymap.KeymapUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInlayParameterHintsProvider
extends JavaScriptInlayParameterHintsProvider {
    public static final Option NAMES_FOR_ALL_ARGS = new Option("js.param.hints.show.names.for.all.args", JavaScriptBundle.messagePointer("js.param.hints.show.names.for.all.args", new Object[0]), false);
    public static final Option NAMES_FOR_TAGGED_TEMPLATES = new Option("js.param.hints.show.names.for.tagged", JavaScriptBundle.messagePointer("js.param.hints.show.names.for.tagged", new Object[0]), true);

    @Override
    protected Option getShowNameForAllArgsOption() {
        return NAMES_FOR_ALL_ARGS;
    }

    @Override
    protected Option getShowNameForTaggedOption() {
        return NAMES_FOR_TAGGED_TEMPLATES;
    }

    @Override
    @NotNull
    public List<Option> getSupportedOptions() {
        List<Option> list2 = Arrays.asList(this.getShowNameForAllArgsOption(), this.getShowNameForTaggedOption());
        if (list2 == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    protected boolean isSuitableCallExpression(@Nullable JSCallLikeExpression expression) {
        if (expression == null) {
            return false;
        }
        if (((TypeScriptInlayHintsSupportedService)expression.getProject().getService(TypeScriptInlayHintsSupportedService.class)).isSupported(expression.getContainingFile())) {
            return this.getShowNameForTaggedOption().get() && expression instanceof ES6TaggedTemplateExpression;
        }
        return super.isSuitableCallExpression(expression);
    }

    @Override
    public String getBlacklistExplanationHTML() {
        return JavaScriptBundle.message("ts.param.hints.blacklist.pattern.explanation", KeymapUtil.getFirstKeyboardShortcutText((String)"ShowIntentionActions"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/editing/TypeScriptInlayParameterHintsProvider", "getSupportedOptions"));
    }
}

