/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isSupported", "", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.javascript.impl"})
public final class TypeScriptInlayHintsSupportedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String ENABLED_KEY = "typescript.service.provideInlayHints.enabled";

    public TypeScriptInlayHintsSupportedService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isSupported(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.get((String)ENABLED_KEY).asBoolean()) {
            return false;
        }
        if (!DialectDetector.isTypeScript((PsiElement)file)) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        TypeScriptService typeScriptService = TypeScriptService.Companion.getForFile(this.project, virtualFile2);
        if (typeScriptService == null) {
            return false;
        }
        TypeScriptService service2 = typeScriptService;
        if (!(service2 instanceof TypeScriptCompilerService)) {
            return false;
        }
        Object object = ReadAction.compute(() -> TypeScriptInlayHintsSupportedService.isSupported$lambda$0(service2, virtualFile2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        if (((Boolean)object).booleanValue()) {
            return false;
        }
        SemVer semVer = service2.getServiceVersion();
        if (semVer == null) {
            return true;
        }
        SemVer version2 = semVer;
        return version2.getMajor() >= 5 || version2.getMajor() == 4 && version2.getMinor() >= 4;
    }

    private static final Boolean isSupported$lambda$0(TypeScriptService $service, VirtualFile $virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$service, (String)"$service");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        return $service.isDisabledByContext($virtualFile);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService$Companion;", "", "()V", "ENABLED_KEY", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

