/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerFunctionDisplay;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerPropertyDisplay;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerSymbolDisplay;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSymbolDisplayPart;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001d\u0010\r\u001a\u00020\u00032\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a'\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\u0010\u0018\u001a/\u0010\u0019\u001a\u00020\u001a2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u001b\u001a\u00020\u001a2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u001b\u0010 \u001a\u00020\u001a2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002\u00a2\u0006\u0002\u0010!\u001a#\u0010\"\u001a\u00020\u001a2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010#\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"defaultParameters", "", "defaultParametersAndReturn", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerFunctionDisplay;", "functionKinds", "", "fillBraces", "", "braces", "Ljava/util/Deque;", "", "part", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;", "getParametersAndReturn", "parts", "", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerFunctionDisplay;", "getPropertyType", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)Ljava/lang/String;", "isCloseBrace", "isOpenBrace", "parseDisplayParts", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerSymbolDisplay;", "kind", "(Ljava/lang/String;[Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerSymbolDisplay;", "parseFunctionParameters", "", "startIndex", "signature", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;ILjava/lang/StringBuilder;)I", "skipDescriptionBraces", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)I", "skipWhitespaces", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;I)I", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServerServiceCompletionEntryParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServerServiceCompletionEntryParser.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceCompletionEntryParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,127:1\n1#2:128\n205#3,8:129\n*S KotlinDebug\n*F\n+ 1 TypeScriptServerServiceCompletionEntryParser.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceCompletionEntryParserKt\n*L\n85#1:129,8\n*E\n"})
public final class TypeScriptServerServiceCompletionEntryParserKt {
    @NotNull
    private static final Set<String> functionKinds;
    @NotNull
    private static final String defaultParameters = "(...)";
    @NotNull
    private static final TypeScriptServerFunctionDisplay defaultParametersAndReturn;

    @NotNull
    public static final TypeScriptServerSymbolDisplay parseDisplayParts(@Nullable String kind, @Nullable TypeScriptSymbolDisplayPart[] parts) {
        return CollectionsKt.contains((Iterable)functionKinds, (Object)kind) ? (TypeScriptServerSymbolDisplay)TypeScriptServerServiceCompletionEntryParserKt.getParametersAndReturn(parts) : (TypeScriptServerSymbolDisplay)new TypeScriptServerPropertyDisplay(TypeScriptServerServiceCompletionEntryParserKt.getPropertyType(parts));
    }

    private static final TypeScriptServerFunctionDisplay getParametersAndReturn(TypeScriptSymbolDisplayPart[] parts) {
        TypeScriptSymbolDisplayPart[] typeScriptSymbolDisplayPartArray = parts;
        if (typeScriptSymbolDisplayPartArray == null || typeScriptSymbolDisplayPartArray.length == 0) {
            return defaultParametersAndReturn;
        }
        int indexToStart = TypeScriptServerServiceCompletionEntryParserKt.skipDescriptionBraces(parts);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) {
            return defaultParametersAndReturn;
        }
        int indexToStartReadParameter = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, '(');
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStartReadParameter)) {
            return defaultParametersAndReturn;
        }
        int index = 0;
        index = TypeScriptServerServiceCompletionEntryParserKt.skipWhitespaces(parts, indexToStartReadParameter);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, index)) {
            return defaultParametersAndReturn;
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        index = TypeScriptServerServiceCompletionEntryParserKt.parseFunctionParameters(parts, index, sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        String signature = string;
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, index)) {
            return new TypeScriptServerFunctionDisplay(signature, null);
        }
        index = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
        return TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, index) ? new TypeScriptServerFunctionDisplay(signature, null) : new TypeScriptServerFunctionDisplay(signature, TypeScriptLanguageServiceResponseParser.readRestText(parts, index));
    }

    private static final int parseFunctionParameters(TypeScriptSymbolDisplayPart[] parts, int startIndex, StringBuilder signature) {
        Deque openedBraces = new ArrayDeque();
        openedBraces.add(true);
        signature.append("(");
        int n = parts.length;
        for (int i = startIndex; i < n; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (TypeScriptServerServiceCompletionEntryParserKt.isOpenBrace(part)) {
                openedBraces.add(true);
            } else if (TypeScriptServerServiceCompletionEntryParserKt.isCloseBrace(part)) {
                openedBraces.pop();
                if (openedBraces.isEmpty()) {
                    signature.append(")");
                    return i + 1;
                }
            }
            TypeScriptLanguageServiceResponseParser.appendText(signature, part);
        }
        signature.append(")");
        return -1;
    }

    private static final String getPropertyType(TypeScriptSymbolDisplayPart[] parts) {
        CharSequence charSequence;
        TypeScriptSymbolDisplayPart[] typeScriptSymbolDisplayPartArray = parts;
        if (typeScriptSymbolDisplayPartArray == null || typeScriptSymbolDisplayPartArray.length == 0) {
            return null;
        }
        int indexToStart = TypeScriptServerServiceCompletionEntryParserKt.skipDescriptionBraces(parts);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) {
            return null;
        }
        int cursor = TypeScriptServerServiceCompletionEntryParserKt.skipWhitespaces(parts, indexToStart);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
            return null;
        }
        cursor = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
            return null;
        }
        String string = TypeScriptLanguageServiceResponseParser.readRestText(parts, cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readRestText(...)");
        String typeText = string;
        CharSequence charSequence2 = typeText;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final int skipWhitespaces(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        int n;
        block3: {
            Sequence $this$indexOfFirst$iv = SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])parts), (int)startIndex);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TypeScriptSymbolDisplayPart it = (TypeScriptSymbolDisplayPart)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.kind, (Object)"space")) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n + startIndex;
    }

    private static final int skipDescriptionBraces(TypeScriptSymbolDisplayPart[] parts) {
        Deque braces = new ArrayDeque();
        boolean firstBraceAdded = false;
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (firstBraceAdded) {
                TypeScriptServerServiceCompletionEntryParserKt.fillBraces(braces, part);
                if (!braces.isEmpty()) continue;
                return i + 1;
            }
            if (!TypeScriptServerServiceCompletionEntryParserKt.isOpenBrace(part)) continue;
            int nextToken = i + 1;
            if (nextToken < parts.length && Intrinsics.areEqual((Object)"parameterName", (Object)parts[nextToken].kind)) {
                return i;
            }
            braces.add(true);
            firstBraceAdded = true;
        }
        return -1;
    }

    private static final void fillBraces(Deque<Boolean> braces, TypeScriptSymbolDisplayPart part) {
        if (Intrinsics.areEqual((Object)part.kind, (Object)"punctuation")) {
            String string = part.text;
            if (Intrinsics.areEqual((Object)string, (Object)")")) {
                braces.pop();
            } else if (Intrinsics.areEqual((Object)string, (Object)"(")) {
                braces.add(true);
            }
        }
    }

    private static final boolean isOpenBrace(TypeScriptSymbolDisplayPart part) {
        return Intrinsics.areEqual((Object)"punctuation", (Object)part.kind) && Intrinsics.areEqual((Object)part.text, (Object)"(");
    }

    private static final boolean isCloseBrace(TypeScriptSymbolDisplayPart part) {
        return Intrinsics.areEqual((Object)"punctuation", (Object)part.kind) && Intrinsics.areEqual((Object)part.text, (Object)")");
    }

    static {
        Object[] objectArray = new String[]{"call", "method", "function", "local function"};
        functionKinds = SetsKt.setOf((Object[])objectArray);
        defaultParametersAndReturn = new TypeScriptServerFunctionDisplay(defaultParameters, null);
    }
}

