/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webSymbols.context.WebSymbolContextChangeListener;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class TypeScriptCompilerSettingsTracker
implements ModificationTracker {
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile TypeScriptCompilerSettings mySettings;
    private long webSymbolsContextModificationCount;
    private final NotNullLazyValue<List<TypeScriptServerServiceSettings>> myAdditionalSettings;

    public static TypeScriptCompilerSettingsTracker getInstance(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(0);
        }
        return (TypeScriptCompilerSettingsTracker)project.getService(TypeScriptCompilerSettingsTracker.class);
    }

    public TypeScriptCompilerSettingsTracker(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(1);
        }
        this.webSymbolsContextModificationCount = 0L;
        this.myProject = project;
        this.myAdditionalSettings = NotNullLazyValue.atomicLazy(() -> TypeScriptCompilerSettingsTracker.getAdditionalSettings(this.myProject));
        project.getMessageBus().simpleConnect().subscribe(WebSymbolContextChangeListener.getTOPIC(), (Object)new WebSymbolContextChangeListener(){

            public void contextMayHaveChanged() {
                ++TypeScriptCompilerSettingsTracker.this.webSymbolsContextModificationCount;
            }
        });
    }

    @NotNull
    private TypeScriptCompilerSettings getSettings() {
        TypeScriptCompilerSettings settings2 = this.mySettings;
        if (settings2 == null) {
            this.mySettings = settings2 = TypeScriptCompilerSettings.getSettings(this.myProject);
        }
        TypeScriptCompilerSettings typeScriptCompilerSettings = settings2;
        if (typeScriptCompilerSettings == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(2);
        }
        return typeScriptCompilerSettings;
    }

    public long getModificationCount() {
        long result2 = this.getSettings().getModificationCount();
        long additional = 0L;
        if (!((List)this.myAdditionalSettings.getValue()).isEmpty()) {
            additional = ((List)this.myAdditionalSettings.getValue()).stream().mapToLong(el -> el.getModificationTracker().getModificationCount()).sum();
        }
        return result2 + additional + this.webSymbolsContextModificationCount;
    }

    @NotNull
    public static List<TypeScriptServerServiceSettings> getAdditionalSettings(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(3);
        }
        if (project.isDefault()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List list3 = StreamEx.of(TypeScriptCompilerService.getAll(project)).map(el -> el.getServiceSettings()).nonNull().toList();
        if (list3 == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettingsTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettingsTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

