/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSThisExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorFactory;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorWrapper;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.ActionScriptRefactoringUtil;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureFix
implements IntentionAction,
LocalQuickFix,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)JSChangeSignatureFix.class.getName());
    private final SmartPsiElementPointer<JSFunction> myFunction;
    private final boolean mySearchForBaseMethod;
    private volatile SmartPsiElementPointer<JSFunction> myActualFunction;
    @Nullable
    private final SmartPsiElementPointer<JSArgumentList> myExpectedArguments;
    @Nullable
    protected final SmartPsiElementPointer<JSParameterList> myExpectedParameterList;
    private final boolean myShowDialogOnIncompatibleOverride;
    @Nullable
    private String myOverriddenReturnType;
    private Map<String, String> myOverriddenParameterTypes;

    public JSChangeSignatureFix(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(0);
        }
        this(function2, (JSParameterList)null);
    }

    public JSChangeSignatureFix(@NotNull JSFunction function2, @Nullable JSParameterList expectedParameterList) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(1);
        }
        this(function2, expectedParameterList, true);
    }

    public JSChangeSignatureFix(@NotNull JSFunction function2, @Nullable JSParameterList expectedParameterList, boolean showDialogOnIncompatibleOverride) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(2);
        }
        this(function2, expectedParameterList, showDialogOnIncompatibleOverride, false);
    }

    public JSChangeSignatureFix(@NotNull JSFunction function2, @Nullable JSParameterList expectedParameterList, boolean showDialogOnIncompatibleOverride, boolean searchForBaseMethod) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(3);
        }
        this(function2, expectedParameterList, null, showDialogOnIncompatibleOverride, searchForBaseMethod);
    }

    public JSChangeSignatureFix(@NotNull JSFunction function2, @Nullable JSArgumentList expectedArguments) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(4);
        }
        this(function2, expectedArguments, false);
    }

    public JSChangeSignatureFix(@NotNull JSFunction function2, @Nullable JSArgumentList expectedArguments, boolean searchForBaseMethod) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(5);
        }
        this(function2, null, expectedArguments, true, searchForBaseMethod);
    }

    private JSChangeSignatureFix(@NotNull JSFunction function2, @Nullable JSParameterList expectedParameterList, @Nullable JSArgumentList expectedArgumentList, boolean showDialogOnIncompatibleOverride, boolean searchForBaseMethod) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(6);
        }
        this.myOverriddenParameterTypes = Collections.emptyMap();
        this.myFunction = SmartPointerManager.createPointer((PsiElement)function2);
        this.myExpectedParameterList = expectedParameterList == null ? null : SmartPointerManager.createPointer((PsiElement)expectedParameterList);
        this.myExpectedArguments = expectedArgumentList == null ? null : SmartPointerManager.createPointer((PsiElement)expectedArgumentList);
        this.myShowDialogOnIncompatibleOverride = showDialogOnIncompatibleOverride;
        this.mySearchForBaseMethod = searchForBaseMethod;
    }

    @NotNull
    public String getText() {
        JSFunction function2 = this.getFunction();
        if (function2 == null) {
            String string = JavaScriptBundle.message("change.method.signature.fix.family.name", new Object[0]);
            if (string == null) {
                JSChangeSignatureFix.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = JavaScriptBundle.message("change.method.signature.fix.text", JSFormatUtil.formatMethod(function2, 4353, 0, 0, null));
        if (string == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("change.method.signature.fix.family.name", new Object[0]);
        if (string == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        JSFunction function2;
        if (project == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(10);
        }
        if ((function2 = this.getFunction()) == null || !function2.isValid() || ModuleUtilCore.findModuleForPsiElement((PsiElement)function2) == null) {
            return false;
        }
        if (this.myExpectedParameterList != null) {
            JSParameterList parameterListElement = (JSParameterList)this.myExpectedParameterList.getElement();
            return parameterListElement != null && parameterListElement.isValid();
        }
        if (this.myExpectedArguments != null) {
            JSExpression[] arguments;
            JSArgumentList argumentList = (JSArgumentList)this.myExpectedArguments.getElement();
            for (JSExpression argument : arguments = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY) {
                if (argument.isValid()) continue;
                return false;
            }
            return JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)file, () -> this.handleCall(function2, arguments, true) != null);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(11);
        }
        PsiFile context2 = editor != null ? file.findElementAt(editor.getCaretModel().getOffset()) : file;
        this.invoke((PsiElement)context2);
    }

    public void invoke(PsiElement context2) throws IncorrectOperationException {
        JSFunction function2 = this.getFunction();
        if (function2 == null) {
            return;
        }
        Pair parameterInfos = JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(context2, () -> this.buildParameterInfos(function2));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runSilently((List)parameterInfos.first, function2);
        } else if (!((Boolean)parameterInfos.second).booleanValue() && !this.needToShowDialog(function2)) {
            this.runSilently((List)parameterInfos.first, function2);
        } else {
            this.createDialog(context2, (List)parameterInfos.first).show();
        }
    }

    @NotNull
    protected Pair<List<JSParameterInfo>, Boolean> buildParameterInfos(@NotNull JSFunction function2) {
        List<JSParameterInfo> paramInfos;
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(12);
        }
        boolean mustShowDialog = false;
        JSArgumentList argumentList = this.getExpectedArguments();
        if (argumentList != null) {
            Pair<Boolean, List<JSParameterInfo>> result2 = this.handleCall(function2, argumentList.getArguments(), false);
            LOG.assertTrue(result2 != null);
            mustShowDialog = (Boolean)result2.first;
            paramInfos = (List<JSParameterInfo>)result2.second;
        } else {
            paramInfos = this.myExpectedParameterList != null ? JSChangeSignatureFix.buildParameterInfosForExpected(function2, ((JSParameterList)this.myExpectedParameterList.getElement()).getParameters()) : JSMethodDescriptor.getParameters(function2, this.myOverriddenParameterTypes);
        }
        Pair pair = Pair.create(paramInfos, (Object)mustShowDialog);
        if (pair == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(13);
        }
        return pair;
    }

    protected JSChangeSignatureDialog createDialog(PsiElement context2, final List<JSParameterInfo> paramInfos) {
        JSFunction function2 = this.getFunction();
        JSMethodDescriptor parent = JSMethodDescriptorFactory.create(function2, false);
        JSMethodDescriptorWrapper descriptor = new JSMethodDescriptorWrapper(parent){

            @Override
            @NotNull
            public List<JSParameterInfo> getParameters() {
                List list2 = paramInfos;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            public String getReturnType() {
                String returnType = JSChangeSignatureFix.this.myOverriddenReturnType;
                if (returnType == null) {
                    returnType = super.getReturnType();
                }
                return returnType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSChangeSignatureFix$1", "getParameters"));
            }
        };
        final int firstAdded = ContainerUtil.indexOf(paramInfos, o -> o.getOldIndex() < 0);
        return new JSChangeSignatureDialog(descriptor, context2){

            @Override
            protected JSChangeSignatureProcessor createRefactoringProcessor() {
                JSChangeSignatureProcessor p = super.createRefactoringProcessor();
                JSChangeSignatureFix.this.setDeclarationFilter(p);
                JSChangeSignatureFix.this.setCallFilter(p);
                return p;
            }

            public JComponent getPreferredFocusedComponent() {
                if (JSChangeSignatureFix.this.myOverriddenReturnType != null && this.myReturnTypeField != null) {
                    return this.myReturnTypeField.getComponent();
                }
                return super.getPreferredFocusedComponent();
            }

            protected int getSelectedIdx() {
                return firstAdded >= 0 ? firstAdded : super.getSelectedIdx();
            }
        };
    }

    private boolean needToShowDialog(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(14);
        }
        if (!this.myShowDialogOnIncompatibleOverride) {
            return false;
        }
        if (JSInheritanceUtil.participatesInHierarchy(function2)) {
            return true;
        }
        JSCallExpression callExpression = this.getCallExpression();
        if (callExpression == null) {
            return true;
        }
        Ref hasUsages = new Ref((Object)Boolean.FALSE);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> hasUsages.set((Object)ReferencesSearch.search((PsiElement)function2, (SearchScope)function2.getUseScope()).anyMatch(ref -> {
            PsiElement element = ref.getElement();
            return element.getParent() instanceof JSCallExpression && element != callExpression.getMethodExpression();
        }))), JavaScriptBundle.message("javascript.refactoring.searching.usages", new Object[0]), true, function2.getProject())) {
            return true;
        }
        return (Boolean)hasUsages.get();
    }

    protected void runSilently(List<JSParameterInfo> paramInfos, @NotNull JSFunction function2) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(15);
        }
        JSAttributeList attributeList = function2 instanceof JSFunctionExpression && function2.getParent() instanceof JSVariable ? ((JSVariable)function2.getParent()).getAttributeList() : function2.getAttributeList();
        this.createProcessor(paramInfos, attributeList, function2).run();
    }

    protected JSChangeSignatureProcessor createProcessor(List<JSParameterInfo> paramInfos, JSAttributeList attributeList, @NotNull JSFunction function2) {
        String returnType;
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(16);
        }
        if ((returnType = this.myOverriddenReturnType) == null) {
            returnType = JSMethodDescriptorFactory.create(function2, false).getReturnType();
        }
        JSChangeSignatureProcessor p = new JSChangeSignatureProcessor(function2, attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL, function2.getName(), returnType, paramInfos.toArray(JSParameterInfo.EMPTY_ARRAY), Collections.emptySet(), Collections.emptySet());
        this.setDeclarationFilter(p);
        this.setCallFilter(p);
        return p;
    }

    public void setReturnType(@Nullable String overriddenReturnType) {
        this.myOverriddenReturnType = overriddenReturnType;
    }

    public void setParameterTypes(@NotNull Map<String, String> overriddenParameterTypes) {
        if (overriddenParameterTypes == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(17);
        }
        this.myOverriddenParameterTypes = overriddenParameterTypes;
    }

    private void setDeclarationFilter(JSChangeSignatureProcessor processor) {
        if (this.myExpectedParameterList != null) {
            JSFunction subjectFunction = (JSFunction)((JSParameterList)this.myExpectedParameterList.getElement()).getParent();
            processor.setDeclarationsFilter((Condition<JSPsiElementBase>)((Condition)jsFunction -> subjectFunction != jsFunction));
        }
    }

    private void setCallFilter(JSChangeSignatureProcessor processor) {
        JSCallExpression callExpression = this.getCallExpression();
        if (callExpression != null) {
            processor.setCallFilter((Condition<JSCallExpression>)((Condition)expression -> expression != callExpression));
        }
    }

    @Nullable
    private JSArgumentList getExpectedArguments() {
        return this.myExpectedArguments != null ? (JSArgumentList)this.myExpectedArguments.getElement() : null;
    }

    @Nullable
    private JSCallExpression getCallExpression() {
        JSArgumentList arguments = this.getExpectedArguments();
        return arguments != null ? (JSCallExpression)ObjectUtils.tryCast((Object)arguments.getParent(), JSCallExpression.class) : null;
    }

    @Nullable
    protected Pair<Boolean, List<JSParameterInfo>> handleCall(@NotNull JSFunction function2, JSExpression @NotNull [] arguments, boolean dryRun) {
        boolean showDialog;
        ArrayList<JSParameterInfo> result2;
        block19: {
            Trinity<Integer, Integer, Boolean> minMaxParameters;
            ProcessingContext processingContext;
            boolean hasTypesLang;
            JSParameterItem[] parameters;
            block21: {
                block20: {
                    if (function2 == null) {
                        JSChangeSignatureFix.$$$reportNull$$$0(18);
                    }
                    if (arguments == null) {
                        JSChangeSignatureFix.$$$reportNull$$$0(19);
                    }
                    parameters = function2.getParameterVariables();
                    result2 = new ArrayList<JSParameterInfo>(arguments.length);
                    showDialog = false;
                    hasTypesLang = DialectDetector.isActionScript(function2) || DialectDetector.isTypeScript(function2);
                    processingContext = JSTypeComparingContextService.createProcessingContextWithCache(function2);
                    minMaxParameters = ValidateTypesUtil.getMinMaxParameters(parameters);
                    if (arguments.length >= (Integer)minMaxParameters.first) break block20;
                    int ai = 0;
                    int pi = 0;
                    while (ai < arguments.length && pi < (Integer)minMaxParameters.first) {
                        JSType argumentJSType;
                        JSExpression argument = arguments[ai];
                        JSParameterItem parameter = parameters[pi];
                        JSType jsType = parameter.getJSType();
                        JSType jSType = argumentJSType = hasTypesLang ? JSResolveUtil.getExpressionJSType(argument) : null;
                        if (JSChangeSignatureFix.isAssignableType(jsType, argumentJSType, argument, processingContext)) {
                            result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                            ++pi;
                            ++ai;
                            continue;
                        }
                        ++pi;
                    }
                    if (result2.size() != arguments.length) {
                        return null;
                    }
                    while (pi < parameters.length) {
                        if (parameters[pi].isOptional()) {
                            showDialog = true;
                            result2.add(JSParameterInfo.build((JSParameterListElement)parameters[pi], pi));
                        }
                        ++pi;
                    }
                    break block19;
                }
                if (arguments.length <= (Integer)minMaxParameters.second) break block21;
                ArrayList<String> paramsNames = new ArrayList<String>();
                for (JSParameterItem parameter : parameters) {
                    paramsNames.add(parameter.getName());
                }
                int pi = 0;
                int lastRequiredParamIndex = -1;
                for (int ai = 0; ai < arguments.length; ++ai) {
                    PsiElement thisContext;
                    JSType argumentJSType;
                    JSExpression argument = arguments[ai];
                    JSParameterItem parameter = pi < parameters.length ? parameters[pi] : null;
                    JSType jSType = argumentJSType = hasTypesLang ? JSResolveUtil.getExpressionJSType(argument) : null;
                    if (argument instanceof JSThisExpression && argumentJSType instanceof TypeScriptGenericThisTypeImpl && (thisContext = JSThisExpressionImpl.resolveThisContext(function2)) != ((JSThisExpression)argument).resolve()) {
                        argumentJSType = ((TypeScriptGenericThisTypeImpl)argumentJSType).getOwnerType();
                    }
                    if (parameter != null && JSChangeSignatureFix.isAssignableType(parameter.getJSType(), argumentJSType, argument, processingContext)) {
                        result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                        ++pi;
                        continue;
                    }
                    String name = dryRun ? null : JSChangeSignatureFix.generateParameterName(argument, paramsNames, function2);
                    String defaultValue = argument.getText();
                    if (!dryRun && StringUtil.isNotEmpty((String)defaultValue) && DialectDetector.isActionScript(function2)) {
                        JSExpression psiElement = JSPsiElementFactory.createJSExpression(defaultValue, (PsiElement)argument);
                        psiElement.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)argument);
                        PsiElement fixed = ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)psiElement, new ArrayList<String>(), new ArrayList<String>(), Collections.emptyList(), null, false, false);
                        defaultValue = fixed.getText();
                    }
                    String argumentTypeText = argumentJSType != null ? JSTypeUtils.copyWithLanguageOfContext(argumentJSType, function2).getTypeText(JSType.TypeTextFormat.CODE) : "";
                    result2.add(new JSParameterInfo(name, argumentTypeText, "", defaultValue, -1));
                    lastRequiredParamIndex = result2.size() - 1;
                }
                if (result2.size() != arguments.length) {
                    return null;
                }
                if (!DialectDetector.isActionScript(function2)) break block19;
                for (int i = 0; i < lastRequiredParamIndex; ++i) {
                    ((JSParameterInfo)result2.get(i)).setInitializer("");
                }
                break block19;
            }
            int pi = 0;
            for (int ai = 0; pi < parameters.length || ai < arguments.length; ++pi, ++ai) {
                if (pi < parameters.length && ai < arguments.length) {
                    JSType argumentJSType;
                    JSParameterItem parameter = parameters[pi];
                    JSExpression argument = arguments[ai];
                    JSType parameterJSType = parameter.getJSType();
                    JSType jSType = argumentJSType = hasTypesLang ? JSResolveUtil.getExpressionJSType(argument) : null;
                    if (parameter.isRest()) {
                        result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                        break;
                    }
                    if (JSChangeSignatureFix.isAssignableType(parameterJSType, argumentJSType, argument, processingContext)) {
                        result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                        continue;
                    }
                    String argumentType = argumentJSType.getTypeText(JSType.TypeTextFormat.CODE);
                    JSParameterInfo parameterInfo = JSParameterInfo.build((JSParameterListElement)parameter, pi);
                    parameterInfo.setTypeText(argumentType);
                    parameterInfo.setInitializer("");
                    result2.add(parameterInfo);
                    continue;
                }
                if (pi >= parameters.length) {
                    LOG.assertTrue(((Boolean)minMaxParameters.third).booleanValue());
                    break;
                }
                result2.add(JSParameterInfo.build((JSParameterListElement)parameters[pi], pi));
            }
        }
        return Pair.create((Object)showDialog, result2);
    }

    private static boolean isAssignableType(@Nullable JSType parameterType, @Nullable JSType argumentType, @NotNull JSExpression argument, @NotNull ProcessingContext processingContext) {
        if (argument == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(20);
        }
        if (processingContext == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(21);
        }
        if (argumentType == null || parameterType == null) {
            return true;
        }
        boolean assignable = parameterType.isDirectlyAssignableType(argumentType, processingContext);
        boolean isActionScript = DialectDetector.isActionScript((PsiElement)argument);
        if (!isActionScript) {
            return assignable;
        }
        if (!assignable) {
            return false;
        }
        if (parameterType instanceof JSBooleanType) {
            return argumentType instanceof JSBooleanType;
        }
        return !ValidateTypesUtil.checkIfNullIsAssignedToNumeric(argument, parameterType, argumentType);
    }

    @NotNull
    private static String generateParameterName(@NotNull JSExpression argument, Collection<String> existingNames, @NotNull JSFunction function2) {
        if (argument == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(22);
        }
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(23);
        }
        Object name = null;
        if (argument instanceof JSReferenceExpression) {
            name = JSNameSuggestionsUtil.trimPrefix((JSReferenceExpression)argument, ((JSReferenceExpression)argument).getReferenceName());
        }
        if (argument instanceof JSNamedElement) {
            name = argument.getName();
        }
        if (name != null && JSChangeSignatureProcessor.getCollidingLocal(function2, (String)name, (Condition<? super PsiElement>)Conditions.alwaysTrue()) == null && !existingNames.contains(name)) {
            String string = name;
            if (string == null) {
                JSChangeSignatureFix.$$$reportNull$$$0(24);
            }
            return string;
        }
        List names = JSNameSuggestionsUtil.generateVariableNamesFromExpression(argument, function2, "", existingNames, JSNamedEntityKind.Parameter);
        if ((names = ContainerUtil.filter(names, aName -> JSChangeSignatureProcessor.getCollidingLocal(function2, aName, (Condition<? super PsiElement>)Conditions.alwaysTrue()) == null)).isEmpty()) {
            int postfix = 1;
            name = "p";
            while (existingNames.contains(name)) {
                name = "p" + postfix++;
            }
        } else {
            name = (String)names.iterator().next();
        }
        existingNames.add((String)name);
        String string = name;
        if (string == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    protected static List<JSParameterInfo> buildParameterInfosForExpected(@NotNull JSFunction function2, JSParameterListElement @NotNull [] expectedParams) {
        if (function2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(26);
        }
        if (expectedParams == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(27);
        }
        JSParameterListElement[] actualParams = function2.getParameters();
        ArrayList<JSParameterInfo> result2 = new ArrayList<JSParameterInfo>(expectedParams.length);
        HashMap<String, Integer> actualName2Index = new HashMap<String, Integer>(actualParams.length);
        for (int i = 0; i < actualParams.length; ++i) {
            actualName2Index.put(actualParams[i].getName(), i);
        }
        JSParameterListElement[] jSParameterListElementArray = expectedParams;
        int n = jSParameterListElementArray.length;
        for (int i = 0; i < n; ++i) {
            JSParameterListElement expectedParam;
            Integer prevIndex = (Integer)actualName2Index.get((expectedParam = jSParameterListElementArray[i]).getName());
            JSParameterInfo parameterInfo = JSParameterInfo.build(expectedParam, prevIndex != null ? prevIndex : -1);
            parameterInfo.setCallValue(JSTypeUtils.defaultValueOfType(parameterInfo.getTypeText()));
            result2.add(parameterInfo);
        }
        ArrayList<JSParameterInfo> arrayList = result2;
        if (arrayList == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(29);
        }
        if (descriptor == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(30);
        }
        this.invoke(descriptor.getPsiElement());
    }

    @Nullable
    protected JSFunction getFunction() {
        JSQualifiedNamedElement member;
        JSPsiElementBase topMember;
        JSFunction topFunction;
        if (this.myActualFunction != null) {
            return (JSFunction)this.myActualFunction.getElement();
        }
        JSFunction function2 = (JSFunction)this.myFunction.getElement();
        if (this.mySearchForBaseMethod && function2 != null && (topFunction = JSChangeSignatureUtil.getFunctionFromMember((PsiElement)(topMember = JSInheritanceUtil.findTopMembers(member = JSChangeSignatureUtil.getMemberFromFunction(function2)).iterator().next()))) != null) {
            this.myActualFunction = SmartPointerManager.createPointer((PsiElement)topFunction);
            return topFunction;
        }
        this.myActualFunction = this.myFunction;
        return function2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 13, 24, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSChangeSignatureFix";
                break;
            }
            case 10: 
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenParameterTypes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedParams";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSChangeSignatureFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterInfos";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "generateParameterName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterInfosForExpected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterInfos";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "needToShowDialog";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runSilently";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setParameterTypes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleCall";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterInfosForExpected";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 13, 24, 25, 28 -> new IllegalStateException(string);
        };
    }
}

