/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.inspections.JSAnnotatorInspection;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemGroup;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnnotatorProblemReporter {
    private final AnnotationHolder myHolder;
    private final boolean myShouldReportInspectionProblems;

    public JSAnnotatorProblemReporter(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
        this.myShouldReportInspectionProblems = JSAnnotatorProblemReporter.shouldReportInspectionProblems(holder.getCurrentAnnotationSession().getFile());
    }

    public JSAnnotatorProblemReporter(@NotNull PsiFile file) {
        if (file == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(1);
        }
        this.myHolder = null;
        this.myShouldReportInspectionProblems = JSAnnotatorProblemReporter.shouldReportInspectionProblems(file);
    }

    public void registerGenericError(@NotNull ASTNode nameIdentifier, @NotNull @InspectionMessage String message, IntentionAction ... intentionActions) {
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(2);
        }
        if (message == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(3);
        }
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(4);
        }
        this.registerGenericError(nameIdentifier.getPsi(), message, intentionActions);
    }

    public void registerGenericError(@NotNull PsiElement nameIdentifier, @NotNull @InspectionMessage String message, IntentionAction ... intentionActions) {
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(5);
        }
        if (message == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(6);
        }
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(7);
        }
        this.registerProblem(nameIdentifier, null, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, intentionActions);
    }

    public void registerProblem(@Nullable PsiElement nameIdentifier, @Nullable TextRange range, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType type2, @Nullable String inspectionId, LocalQuickFix @NotNull [] fixes, IntentionAction @NotNull [] intentionActions) {
        JSAnnotatorProblemGroup problemGroup;
        HighlightSeverity severity;
        FileViewProvider viewProvider;
        if (message == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(8);
        }
        if (fixes == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(9);
        }
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(10);
        }
        if (inspectionId != null && !this.myShouldReportInspectionProblems) {
            return;
        }
        boolean isAnnotatorInspection = inspectionId == null;
        String string = inspectionId = isAnnotatorInspection ? this.getAnnotatorInspectionId() : inspectionId;
        if (range == null && nameIdentifier != null) {
            range = nameIdentifier.getTextRange();
        }
        if (range == null) {
            return;
        }
        PsiFile file = nameIdentifier != null ? nameIdentifier.getContainingFile() : null;
        LocalInspectionToolWrapper localInspectionToolWrapper = null;
        HighlightDisplayKey displayKey = null;
        InspectionProfile inspectionProfile = null;
        Set suppressors = null;
        if (nameIdentifier != null && inspectionId != null) {
            inspectionProfile = JSAnnotatorProblemReporter.getInspectionProfile(nameIdentifier);
            localInspectionToolWrapper = JSAnnotatorProblemReporter.getInspectionToolWrapper(nameIdentifier, inspectionId, inspectionProfile);
            displayKey = HighlightDisplayKey.find((String)inspectionId);
            if (localInspectionToolWrapper == null || !inspectionProfile.isToolEnabled(displayKey, (PsiElement)file)) {
                return;
            }
            if (!IntentionAndInspectionFilter.isInspectionSupportedForElement(inspectionId, nameIdentifier)) {
                return;
            }
            if (nameIdentifier.isValid()) {
                suppressors = InspectionProfileEntry.getSuppressors((PsiElement)nameIdentifier);
                for (InspectionSuppressor suppressor2 : suppressors) {
                    if (!suppressor2.isSuppressedFor(nameIdentifier, inspectionId)) continue;
                    return;
                }
                LocalInspectionTool tool = (LocalInspectionTool)localInspectionToolWrapper.getTool();
                if (SuppressionUtil.inspectionResultSuppressed((PsiElement)nameIdentifier, (LocalInspectionTool)tool)) {
                    return;
                }
            }
        }
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        @NlsSafe String ref = nameIdentifier != null ? ProblemDescriptorUtil.extractHighlightedText((TextRange)range, (PsiElement)nameIdentifier) : "";
        message = StringUtil.replace((String)message, (String)"#ref", (String)ref);
        if ((type2 == ProblemHighlightType.ERROR || type2 == ProblemHighlightType.GENERIC_ERROR) && file != null && (viewProvider = file.getViewProvider()).isPhysical() && !ProjectScope.getProjectScope((Project)file.getProject()).contains(viewProvider.getVirtualFile())) {
            type2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        if (type2 == ProblemHighlightType.ERROR || type2 == ProblemHighlightType.GENERIC_ERROR) {
            severity = HighlightSeverity.ERROR;
        } else if (type2 == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
            severity = HighlightSeverity.WARNING;
        } else if (type2 == ProblemHighlightType.WEAK_WARNING) {
            severity = HighlightSeverity.WEAK_WARNING;
        } else if (type2 == ProblemHighlightType.INFORMATION) {
            severity = HighlightSeverity.INFORMATION;
        } else if (localInspectionToolWrapper != null) {
            if (displayKey == null) {
                return;
            }
            HighlightDisplayLevel defaultLevel = inspectionProfile.getErrorLevel(displayKey, nameIdentifier);
            if (defaultLevel == HighlightDisplayLevel.ERROR) {
                type2 = type2 == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                severity = HighlightSeverity.ERROR;
            } else {
                severity = defaultLevel == HighlightDisplayLevel.WARNING ? HighlightSeverity.WARNING : HighlightSeverity.WEAK_WARNING;
            }
        } else {
            severity = HighlightSeverity.WEAK_WARNING;
        }
        if (type2 == null) {
            type2 = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)severity);
        }
        if (isAnnotatorInspection && suppressors != null) {
            String finalInspectionId = inspectionId;
            SuppressIntentionAction[] actions = (SuppressIntentionAction[])suppressors.stream().flatMap(suppressor -> Arrays.stream(suppressor.getSuppressActions(nameIdentifier, finalInspectionId))).map(fix -> SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction((SuppressQuickFix)fix)).toArray(SuppressIntentionAction[]::new);
            problemGroup = new JSAnnotatorProblemGroup(actions, finalInspectionId);
        } else {
            problemGroup = null;
        }
        List<Object> fixesToRegister = nameIdentifier != null && file != null ? JSAnnotatorProblemReporter.getFixes(nameIdentifier, fixes, intentionActions, file, displayKey) : Collections.emptyList();
        this.createAnnotation(range, message, type2, displayKey, severity, (ProblemGroup)problemGroup, (List<? extends IntentionAction>)fixesToRegister);
    }

    protected void createAnnotation(@NotNull TextRange range, @NotNull @InspectionMessage String message, @NotNull ProblemHighlightType type2, @Nullable HighlightDisplayKey displayKey, @NotNull HighlightSeverity severity, @Nullable ProblemGroup problemGroup, @NotNull List<? extends IntentionAction> fixesToRegister) {
        if (range == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(11);
        }
        if (message == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(13);
        }
        if (severity == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(14);
        }
        if (fixesToRegister == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(15);
        }
        AnnotationBuilder builder2 = this.myHolder.newAnnotation(severity, message).range(range).highlightType(type2);
        if (problemGroup != null) {
            builder2 = builder2.problemGroup(problemGroup);
        }
        for (IntentionAction intentionAction : fixesToRegister) {
            AnnotationBuilder.FixBuilder fixBuilder = builder2.newFix(intentionAction);
            if (displayKey != null) {
                fixBuilder = fixBuilder.key(displayKey);
            }
            builder2 = fixBuilder.registerFix();
        }
        builder2.create();
    }

    private static boolean shouldReportInspectionProblems(@NotNull PsiFile psiFile2) {
        VirtualFile file;
        if (psiFile2 == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(16);
        }
        if ((file = psiFile2.getVirtualFile()) instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if (file == null || file instanceof LightVirtualFile) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)psiFile2.getProject());
        return fileIndex.isInContent(file) && !fileIndex.isInLibrary(file);
    }

    @NotNull
    private static InspectionProfile getInspectionProfile(@NotNull PsiElement nameIdentifier) {
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(17);
        }
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)nameIdentifier.getProject()).getCurrentProfile();
        if (inspectionProfileImpl == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(18);
        }
        return inspectionProfileImpl;
    }

    private static LocalInspectionToolWrapper getInspectionToolWrapper(@NotNull PsiElement nameIdentifier, @NotNull String inspectionId, @NotNull InspectionProfile inspectionProfile) {
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(19);
        }
        if (inspectionId == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(20);
        }
        if (inspectionProfile == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(21);
        }
        return (LocalInspectionToolWrapper)inspectionProfile.getInspectionTool(inspectionId, nameIdentifier);
    }

    public static AnnotationBuilder registerIntentionAndFixes(@NotNull PsiElement nameIdentifier, LocalQuickFix @NotNull [] fixes, IntentionAction @NotNull [] intentionActions, @NotNull AnnotationBuilder builder2, @NotNull PsiFile file, @Nullable HighlightDisplayKey displayKey) {
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(22);
        }
        if (builder2 == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(23);
        }
        if (file == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(24);
        }
        if (fixes == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(25);
        }
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(26);
        }
        for (IntentionAction fix : JSAnnotatorProblemReporter.getFixes(nameIdentifier, fixes, intentionActions, file, displayKey)) {
            AnnotationBuilder.FixBuilder fb = builder2.newFix(fix);
            if (displayKey != null) {
                fb = fb.key(displayKey);
            }
            builder2 = fb.registerFix();
        }
        return builder2;
    }

    @NotNull
    private static List<IntentionAction> getFixes(@NotNull PsiElement nameIdentifier, LocalQuickFix @NotNull [] fixes, IntentionAction @NotNull [] intentionActions, @NotNull PsiFile file, @Nullable HighlightDisplayKey displayKey) {
        String displayName;
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(27);
        }
        if (file == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(28);
        }
        if (fixes == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(29);
        }
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(30);
        }
        ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
        boolean fixRegistered = false;
        SmartPsiElementPointer pointer2 = null;
        for (LocalQuickFix localQuickFix : fixes) {
            if (!(localQuickFix instanceof IntentionAction)) continue;
            result2.add((IntentionAction)localQuickFix);
            fixRegistered = true;
            if (!(localQuickFix instanceof FixAndIntentionAction)) continue;
            pointer2 = ((FixAndIntentionAction)localQuickFix).registerElementRefForFix(nameIdentifier, pointer2);
        }
        for (LocalQuickFix localQuickFix : intentionActions) {
            fixRegistered = true;
            result2.add((IntentionAction)localQuickFix);
        }
        if (!file.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) && displayKey != null && !fixRegistered && (displayName = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)displayKey)) != null) {
            result2.add((IntentionAction)new EmptyIntentionAction(displayName));
        }
        ArrayList<IntentionAction> arrayList = result2;
        if (arrayList == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public static TextRange shortenTextRange(@NotNull PsiElement place, @NotNull TextRange range) {
        Document document2;
        if (place == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(32);
        }
        if (range == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(33);
        }
        if (place instanceof JSFunctionExpression || place instanceof JSClassExpression) {
            ASTNode rangeEndNode;
            ASTNode node = place.getNode();
            ASTNode rangeStartNode = node.findChildByType(place instanceof JSFunctionExpression ? JSTokenTypes.FUNCTION_KEYWORD : JSTokenTypes.CLASS_KEYWORD);
            PsiElement rangeEndElement = ((JSNamedExpression)place).getOwnNameIdentifier();
            ASTNode aSTNode = rangeEndNode = rangeEndElement != null ? rangeEndElement.getNode() : rangeStartNode;
            if (rangeStartNode != null && rangeEndNode != null) {
                int rangeEndOffset = Math.max(rangeStartNode.getTextRange().getEndOffset(), rangeEndNode.getTextRange().getEndOffset());
                TextRange keywordAndNameRange = TextRange.create((int)rangeStartNode.getStartOffset(), (int)rangeEndOffset);
                TextRange intersection = range.intersection(keywordAndNameRange);
                if (intersection != null && !intersection.isEmpty()) {
                    range = intersection;
                }
            }
        }
        if ((document2 = PsiDocumentManager.getInstance((Project)place.getProject()).getDocument(place.getContainingFile())) != null && document2.getLineNumber(range.getStartOffset()) < document2.getLineNumber(range.getEndOffset())) {
            range = new TextRange(range.getStartOffset(), document2.getLineEndOffset(document2.getLineNumber(range.getStartOffset())));
        }
        TextRange textRange2 = range;
        if (textRange2 == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(34);
        }
        return textRange2;
    }

    @Nullable
    protected String getAnnotatorInspectionId() {
        return JSAnnotatorInspection.SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 31, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 17: 
            case 19: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionActions";
                break;
            }
            case 9: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixesToRegister";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 18: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionProfile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerGenericError";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldReportInspectionProblems";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionProfile";
                break;
            }
            case 18: 
            case 31: 
            case 34: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionToolWrapper";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionAndFixes";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 31, 34 -> new IllegalStateException(string);
        };
    }
}

