/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.structureView.JSNodeFactory;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.lang.javascript.structureView.SimpleItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructureViewElement
extends JSStructureViewElementBase {
    private static final JSNodeFactory NODE_FACTORY = new JSNodeFactory(){

        @Override
        @NotNull
        public JSStructureViewElementBase create(@Nullable String name, @Nullable Icon icon, @NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return new JSStructureViewElement(element, new SimpleItemPresentation(name, null, icon));
        }

        @Override
        @NotNull
        public JSStructureViewElementBase create(@Nullable String name, @Nullable Icon icon, @Nullable String description, @NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(1);
            }
            return new JSStructureViewElement(element, new SimpleItemPresentation(name, description, icon));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/structureView/JSStructureViewElement$1", "create"));
        }
    };
    @NotNull
    private final OwnAndAncestorSiblings myAndAncestorSiblings;
    private final boolean myEcma;

    public JSStructureViewElement(@NotNull PsiElement element, boolean ecma) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(0);
        }
        super(element, null, false);
        this.myAndAncestorSiblings = OwnAndAncestorSiblings.EMPTY;
        this.myEcma = ecma;
    }

    public JSStructureViewElement(@NotNull PsiElement element, @Nullable ItemPresentation presentation) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(1);
        }
        super(element, presentation, false);
        this.myAndAncestorSiblings = OwnAndAncestorSiblings.EMPTY;
        this.myEcma = false;
    }

    private JSStructureViewElement(@NotNull List<PsiElement> elements, @Nullable OwnAndAncestorSiblings myAndAncestorSiblings, boolean ecma) {
        if (elements == null) {
            JSStructureViewElement.$$$reportNull$$$0(2);
        }
        this(elements, myAndAncestorSiblings, null, ecma, false);
    }

    protected JSStructureViewElement(@NotNull List<PsiElement> elements, @Nullable OwnAndAncestorSiblings myAndAncestorSiblings, @Nullable ItemPresentation presentation, boolean ecma, boolean inherited) {
        if (elements == null) {
            JSStructureViewElement.$$$reportNull$$$0(3);
        }
        super(elements, presentation, inherited);
        this.myAndAncestorSiblings = myAndAncestorSiblings != null ? myAndAncestorSiblings : OwnAndAncestorSiblings.EMPTY;
        this.myEcma = ecma;
    }

    @Override
    @NotNull
    protected JSStructureViewElementBase copyWithInheritedImpl() {
        return new JSStructureViewElement(this.getAllElements(), this.myAndAncestorSiblings, this.getPresentation(), this.myEcma, true);
    }

    @Override
    protected JSNodeFactory getNodeFactory() {
        return NODE_FACTORY;
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getOwnChildren() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            List<StructureViewTreeElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSStructureViewElement.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (this.myNodeProvider != null) {
            List<StructureViewTreeElement> list3 = this.myNodeProvider.getNodes(element, NODE_FACTORY);
            if (list3 == null) {
                JSStructureViewElement.$$$reportNull$$$0(5);
            }
            return list3;
        }
        JSQualifiedName ns = JSStructureViewElement.getProvidedNamespaceByElement(element);
        List<StructureViewTreeElement> list4 = this.collectMyElements(new HashSet<String>(), ns, element.getContainingFile());
        if (list4 == null) {
            JSStructureViewElement.$$$reportNull$$$0(6);
        }
        return list4;
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getInherited() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            List<StructureViewTreeElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSStructureViewElement.$$$reportNull$$$0(7);
            }
            return list2;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof JSFile && ((JSFile)file).isMinified()) {
            List<StructureViewTreeElement> list3 = Collections.emptyList();
            if (list3 == null) {
                JSStructureViewElement.$$$reportNull$$$0(8);
            }
            return list3;
        }
        List<StructureViewTreeElement> elementsFromSupers = null;
        HashSet<String> childrenNames = new HashSet<String>();
        JSNamespace providedNs = element instanceof JSElementBase ? JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element, true, null) : null;
        JSQualifiedName namespace = providedNs != null ? providedNs.getQualifiedName() : null;
        this.collectMyElements(childrenNames, namespace, element.getContainingFile());
        if (element instanceof JSClass) {
            OwnAndAncestorSiblings childAndAncestorSiblings = new OwnAndAncestorSiblings(childrenNames, this.myAndAncestorSiblings);
            elementsFromSupers = this.getInheritedForClass((JSClass)element, (Function<? super PsiElement, ? extends JSStructureViewElementBase>)((Function)superClass -> this.createStructureViewElement((PsiElement)superClass, childAndAncestorSiblings)));
        } else if (!this.myEcma) {
            JSQualifiedName parent;
            JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
            if (parent != null && "Object".equals(parent.getQualifiedName())) {
                providedNs = null;
            }
            if (element instanceof JSPsiElementBase && !JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)element) && (!(element instanceof JSFunction) || element instanceof JSFunctionExpression) && (!(element instanceof JSVariable) || !JSSymbolUtil.isMeaningfulLocalVariableInitializer(((JSVariable)element).getInitializerOrStub()) || ((JSVariable)element).isLocal()) || !(element instanceof JSNamedElement) && (namespace == null || !JSSymbolUtil.isConstructorName(namespace.getQualifiedName())) || element instanceof JSProperty || element instanceof JSImplicitElement && !JSStructureViewElement.isClass((JSImplicitElement)element)) {
                providedNs = null;
            }
            if (providedNs != null && providedNs.getQualifiedName() != null) {
                providedNs = JSNamedTypeFactory.copyWithJSContext(providedNs, JSContext.INSTANCE);
                GlobalSearchScope scope2 = JSResolveUtil.getResolveScope((PsiElement)file);
                elementsFromSupers = this.getInheritedElements(element, providedNs, scope2, childrenNames);
            }
        }
        List<StructureViewTreeElement> list4 = elementsFromSupers != null ? elementsFromSupers : Collections.emptyList();
        if (list4 == null) {
            JSStructureViewElement.$$$reportNull$$$0(9);
        }
        return list4;
    }

    @Nullable
    private List<StructureViewTreeElement> getInheritedElements(@NotNull PsiElement element, @NotNull JSNamespace providedNs, @NotNull GlobalSearchScope scope2, @NotNull Set<String> outReferencedNames) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(10);
        }
        if (providedNs == null) {
            JSStructureViewElement.$$$reportNull$$$0(11);
        }
        if (scope2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(12);
        }
        if (outReferencedNames == null) {
            JSStructureViewElement.$$$reportNull$$$0(13);
        }
        HashSet visitedTypes = new HashSet();
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(element, providedNs, true, true, true, (Processor<? super JSType>)((Processor)type2 -> {
            JSNamespace ns = JSTypeUtils.getNamespaceMatchingType(type2, false);
            if (ns != null) {
                visitedTypes.add(ns);
            }
            return true;
        }));
        MultiMap result2 = new MultiMap();
        for (JSNamespace type3 : visitedTypes) {
            JSQualifiedName name = type3.getQualifiedName();
            if (name == null) continue;
            this.addElementsFromNamespace((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)result2, scope2, name.getQualifiedName());
        }
        OwnAndAncestorSiblings childAncestorAndSiblings = new OwnAndAncestorSiblings(outReferencedNames, this.myAndAncestorSiblings);
        List superElements = ContainerUtil.map(this.convertPsiToElements((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)result2, childAncestorAndSiblings), el -> ((JSStructureViewElement)((Object)el)).copyWithInherited());
        return !superElements.isEmpty() ? superElements : null;
    }

    private static boolean isClass(JSImplicitItem element) {
        JSImplicitElement.Type type2 = element.getType();
        return type2 == JSImplicitElement.Type.Class || type2 == JSImplicitElement.Type.Interface;
    }

    @Nullable
    private static JSQualifiedName getProvidedNamespaceByElement(PsiElement element) {
        JSNamespace jsNamespace;
        if (element instanceof JSElementBase && (jsNamespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element, true, null)) != null) {
            return jsNamespace.getQualifiedName();
        }
        return null;
    }

    protected JSStructureViewElementBase createStructureViewElement(PsiElement element, @Nullable OwnAndAncestorSiblings ownAndAncestorSiblings) {
        return this.createStructureViewElement(Collections.singletonList(element), ownAndAncestorSiblings);
    }

    private JSStructureViewElementBase createStructureViewElement(List<PsiElement> elements, @Nullable OwnAndAncestorSiblings ownAndAncestorSiblings) {
        return new JSStructureViewElement(elements, ownAndAncestorSiblings, this.myEcma);
    }

    protected List<StructureViewTreeElement> collectMyElements(@NotNull Set<String> outChildrenNames, JSQualifiedName ns, PsiFile contextFile) {
        if (outChildrenNames == null) {
            JSStructureViewElement.$$$reportNull$$$0(14);
        }
        return this.doCollectMyElements(outChildrenNames, ns, contextFile, this.getElement(), this.getAllElements(), false);
    }

    private List<StructureViewTreeElement> doCollectMyElements(@NotNull Set<String> outChildrenNames, JSQualifiedName ns, PsiFile contextFile, PsiElement mainElement, List<PsiElement> mainElements, boolean oneElementOnly) {
        boolean myElementIsFile;
        boolean shouldFindNsInDepth;
        if (outChildrenNames == null) {
            JSStructureViewElement.$$$reportNull$$$0(15);
        }
        boolean bl = shouldFindNsInDepth = (myElementIsFile = mainElement instanceof PsiFile) && mainElement.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || mainElement instanceof JSImplicitElement;
        if (mainElement instanceof JSDefinitionExpression && "prototype".equals(((JSDefinitionExpression)mainElement).getName())) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> visitedFiles = new HashSet<PsiFile>();
        visitedFiles.add(contextFile);
        MultiMap children = MultiMap.createLinked();
        Function childrenProvider = el -> JSStructureViewElement.gatherChildElements(el, visitedFiles);
        JSStructureViewElementBase.ChildElementProcessor childProcessor = (el, name) -> this.addChildElement(el, name, ns, mainElement, shouldFindNsInDepth, (MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children);
        if (this.fillChildrenElement(mainElements, (MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children, (Function<? super PsiElement, ? extends Collection<? extends PsiElement>>)childrenProvider, childProcessor, oneElementOnly)) {
            return this.convertPsiToElements((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children, this.myAndAncestorSiblings);
        }
        if (ns != null && !oneElementOnly) {
            this.addElementsFromNamespaceFromFile(ns, contextFile, (MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children);
        }
        outChildrenNames.addAll(children.keySet());
        return this.convertPsiToElements((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children, new OwnAndAncestorSiblings(outChildrenNames, this.myAndAncestorSiblings));
    }

    private void addElementsFromNamespaceFromFile(@NotNull JSQualifiedName ns, @NotNull PsiFile contextFile, @NotNull MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children) {
        if (ns == null) {
            JSStructureViewElement.$$$reportNull$$$0(16);
        }
        if (contextFile == null) {
            JSStructureViewElement.$$$reportNull$$$0(17);
        }
        if (children == null) {
            JSStructureViewElement.$$$reportNull$$$0(18);
        }
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.addElementsFromNamespace(children, GlobalSearchScope.fileScope((PsiFile)contextFile), ns.getQualifiedName()));
    }

    private boolean addChildElement(JSStructureViewElementBase.PsiElementWithNodeProvider element, String name, JSQualifiedName ns, PsiElement parentElement, boolean shouldFindNsInDepth, MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children) {
        PsiElement psiElement = element.getElement();
        if (JSStructureViewElement.isElementInMyNamespace(psiElement, ns, parentElement, shouldFindNsInDepth)) {
            this.addElement(children, element, name);
            return true;
        }
        if (psiElement instanceof JSPsiElementBase) {
            String childName;
            JSQualifiedName namespace = ((JSPsiElementBase)psiElement).getJSNamespace().getQualifiedName();
            JSQualifiedName childNs = JSStructureViewElement.findFirstLevelChildNs(ns, namespace);
            childNs = childNs == null && JSStructureViewElement.shouldAddNamespaceFromDefinition(psiElement, namespace, this.myAndAncestorSiblings) ? namespace : childNs;
            String string = childName = childNs != null ? childNs.getName() : null;
            if (childNs != null && this.myAndAncestorSiblings.contains(name) && Comparing.equal((Object)childNs, (Object)namespace)) {
                return true;
            }
            if (childNs != null && !childName.equals("Window")) {
                JSStructureImplicitNamespace implicitNamespace = new JSStructureImplicitNamespace(childNs, (JSPsiElementBase)psiElement);
                children.putValue((Object)childName, (Object)new JSStructureViewElementBase.PsiElementWithNodeProvider((PsiElement)implicitNamespace));
                return true;
            }
        }
        return false;
    }

    private static boolean shouldAddNamespaceFromDefinition(PsiElement element, JSQualifiedName namespace, OwnAndAncestorSiblings ownAndAncestorSiblings) {
        return namespace != null && element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getInitializerOrStub() instanceof JSFunctionItem && !ownAndAncestorSiblings.contains(namespace.getName());
    }

    private void addElementsFromNamespace(MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children, GlobalSearchScope scope2, String namespace) {
        boolean isObject = "Object".equals(namespace);
        for (JSPsiElementBase namedElement : JSClassResolver.getInstance().findNamespaceMembersIncludingLocal(namespace, scope2)) {
            String name;
            if (isObject && namedElement.getJSContext() == JSContext.STATIC || (name = this.getName((PsiElement)namedElement, children.size())) == null) continue;
            this.addElement(children, new JSStructureViewElementBase.PsiElementWithNodeProvider((PsiElement)namedElement), name);
        }
    }

    @Override
    protected String getName(@NotNull PsiElement element, int count) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(19);
        }
        if (element instanceof JSPackageStatement) {
            return null;
        }
        if (element instanceof JSDefinitionExpression) {
            PsiFile file;
            JSFunction function2;
            JSClass clazz;
            JSDefinitionExpression definition2 = (JSDefinitionExpression)element;
            if ("prototype".equals(definition2.getName()) && definition2.getJSContext() != JSContext.INSTANCE) {
                return null;
            }
            if (this.myEcma && (clazz = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)(function2 = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)definition2, (Class[])new Class[]{JSFunction.class})), (Class[])new Class[]{JSClass.class})) != null) {
                return null;
            }
            if ("exports".equals(definition2.getName()) && (file = definition2.getContainingFile()) instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                return null;
            }
            if (definition2.getJSNamespace().getQualifiedName() == null && !(definition2.getInitializerOrStub() instanceof JSFunctionItem) && !this.hasStructureElements(element)) {
                return null;
            }
        }
        return super.getName(element, count);
    }

    @Override
    protected boolean hasStructureElements(PsiElement element) {
        List<StructureViewTreeElement> elements = this.doCollectMyElements(new HashSet<String>(), JSStructureViewElement.getProvidedNamespaceByElement(element), element.getContainingFile(), element, Collections.singletonList(element), true);
        return !elements.isEmpty();
    }

    private static Collection<? extends PsiElement> gatherChildElements(PsiElement element, Set<PsiFile> visitedFiles) {
        JSExpression value;
        if (element instanceof JSStructureImplicitNamespace) {
            return Collections.singleton(element.getParent());
        }
        if (element instanceof JSAssignmentExpression) {
            JSAssignmentExpression value2 = (JSAssignmentExpression)element;
            SmartList result2 = new SmartList();
            while (value2 instanceof JSStubElementImpl) {
                PsiElement definition2 = ((JSStubElementImpl)((Object)value2)).getStubOrPsiChild(JSStubElementTypes.DEFINITION_EXPRESSION);
                ContainerUtil.addIfNotNull((Collection)result2, (Object)definition2);
                value2 = (JSAssignmentExpression)((JSStubElementImpl)((Object)value2)).getStubOrPsiChild(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            }
            return result2;
        }
        if (element instanceof JSDefinitionExpression && (value = ((JSDefinitionExpression)element).getInitializerOrStub()) != null) {
            return Collections.singleton(value);
        }
        if (element instanceof JSIncludeDirective) {
            PsiFile file = ((JSIncludeDirective)element).resolveFile();
            element = file != null && !visitedFiles.contains(file) ? file : element;
            visitedFiles.add(file);
        }
        return JSStructureViewElement.getPsiOrStubChildren(element);
    }

    @NotNull
    private List<StructureViewTreeElement> convertPsiToElements(MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children, final OwnAndAncestorSiblings ownAndAncestorSiblings) {
        List list2 = JBIterable.from((Iterable)children.entrySet()).flatMap((Function)new Function<Map.Entry<String, Collection<JSStructureViewElementBase.PsiElementWithNodeProvider>>, List<StructureViewTreeElement>>(){

            public List<StructureViewTreeElement> fun(Map.Entry<String, Collection<JSStructureViewElementBase.PsiElementWithNodeProvider>> entry) {
                Collection<JSStructureViewElementBase.PsiElementWithNodeProvider> value = entry.getValue();
                ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(3);
                boolean hasProvider = false;
                for (JSStructureViewElementBase.PsiElementWithNodeProvider elementWithNodeProvider : value) {
                    hasProvider = JSStructureViewElement.this.collectExtensionElements(elementWithNodeProvider, result2);
                }
                if (!result2.isEmpty() || hasProvider) {
                    return result2;
                }
                List elements = ContainerUtil.map(value, val -> val.getElement());
                if (value.size() <= 1) {
                    return Collections.singletonList(this.sortAndCreate(elements));
                }
                SmartList staticElements = new SmartList();
                SmartList exportSpecifiers = new SmartList();
                SmartList otherElements = new SmartList();
                boolean hasInstanceMember = false;
                for (PsiElement element : elements) {
                    if (element instanceof ES6ExportSpecifier) {
                        exportSpecifiers.add((Object)element);
                        continue;
                    }
                    if (element instanceof JSPsiElementBase) {
                        JSContext context2 = ((JSPsiElementBase)element).getJSContext();
                        if (context2 == JSContext.STATIC) {
                            staticElements.add((Object)element);
                            continue;
                        }
                        if (context2 == JSContext.INSTANCE) {
                            hasInstanceMember = true;
                        }
                    }
                    otherElements.add((Object)element);
                }
                if (!staticElements.isEmpty() && hasInstanceMember) {
                    result2.add(this.sortAndCreate((List<PsiElement>)staticElements));
                } else {
                    otherElements.addAll((Collection)staticElements);
                }
                if (!otherElements.isEmpty()) {
                    result2.add(this.sortAndCreate((List<PsiElement>)otherElements));
                }
                if (!exportSpecifiers.isEmpty()) {
                    result2.add(this.sortAndCreate((List<PsiElement>)exportSpecifiers));
                }
                return result2;
            }

            private StructureViewTreeElement sortAndCreate(List<PsiElement> value) {
                JSStructureViewElement.this.sortChildrenByImplicitElements(value);
                return JSStructureViewElement.this.createStructureViewElement(value, ownAndAncestorSiblings);
            }
        }).toList();
        if (list2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(20);
        }
        return list2;
    }

    private static boolean isElementInMyNamespace(PsiElement element, JSQualifiedName myNs, PsiElement parentElement, boolean shouldFindNsInDepth) {
        JSInheritanceCallEvaluator.JSInheritanceCallResult inheritance;
        JSExpression initializer;
        if (!(element instanceof JSElementBase)) {
            return true;
        }
        JSQualifiedName namespace = ((JSElementBase)element).getJSNamespace().getQualifiedName();
        if (namespace == null) {
            return true;
        }
        if (namespace.equals(myNs)) {
            return true;
        }
        String name = namespace.getName();
        if (parentElement instanceof PsiFile) {
            if (Comparing.equal((Object)namespace.getParent(), (Object)myNs) && "Window".equals(name)) {
                return true;
            }
            if (!shouldFindNsInDepth && element instanceof JSClass && JSStructureViewElement.findFirstLevelChildNs(myNs, namespace) != null) {
                return true;
            }
        } else if (!StringUtil.isEmpty((String)name) && myNs != null && name.equals(myNs.getName()) && Comparing.equal((Object)JSStructureViewElement.getParentSkippingWindow(namespace), (Object)JSStructureViewElement.getParentSkippingWindow(myNs))) {
            return true;
        }
        return parentElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parentElement).getInitializer()) instanceof JSCallExpression && (inheritance = JSInheritanceCallEvaluator.findInheritance((JSCallExpression)initializer)) != null && inheritance.destination != initializer && inheritance.isCallExpressionMatchesDestination;
    }

    private static JSQualifiedName getParentSkippingWindow(@Nullable JSQualifiedName namespace) {
        JSQualifiedName parent;
        JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
        if (parent != null && "Window".equals(parent.getName())) {
            return parent.getParent();
        }
        return parent;
    }

    private static JSQualifiedName findFirstLevelChildNs(JSQualifiedName parent, JSQualifiedName namespace) {
        while (namespace != null) {
            JSQualifiedName parentNs = namespace.getParent();
            if (Comparing.equal((Object)parentNs, (Object)parent)) {
                return namespace;
            }
            namespace = parentNs;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSStructureViewElement element = (JSStructureViewElement)((Object)o);
        return this.myEcma == element.myEcma && this.myAndAncestorSiblings.equals(element.myAndAncestorSiblings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myAndAncestorSiblings, this.myEcma);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providedNs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outReferencedNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChildrenNames";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnChildren";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherited";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPsiToElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 20: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInheritedElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectMyElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doCollectMyElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addElementsFromNamespaceFromFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 20 -> new IllegalStateException(string);
        };
    }

    protected static class OwnAndAncestorSiblings {
        private static final OwnAndAncestorSiblings EMPTY = new OwnAndAncestorSiblings(Collections.emptySet(), null);
        @NotNull
        private final Set<String> mySiblings;
        @Nullable
        private final OwnAndAncestorSiblings myAncestorSiblings;

        private OwnAndAncestorSiblings(@NotNull Set<String> siblings2, @Nullable OwnAndAncestorSiblings ancestorSiblings) {
            if (siblings2 == null) {
                OwnAndAncestorSiblings.$$$reportNull$$$0(0);
            }
            this.mySiblings = siblings2;
            this.myAncestorSiblings = ancestorSiblings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OwnAndAncestorSiblings siblings2 = (OwnAndAncestorSiblings)o;
            return this.mySiblings.equals(siblings2.mySiblings) && Objects.equals(this.myAncestorSiblings, siblings2.myAncestorSiblings);
        }

        public int hashCode() {
            return Objects.hash(this.mySiblings, this.myAncestorSiblings);
        }

        public boolean contains(String name) {
            return this.mySiblings.contains(name) || this.myAncestorSiblings != null && this.myAncestorSiblings.contains(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siblings", "com/intellij/lang/javascript/structureView/JSStructureViewElement$OwnAndAncestorSiblings", "<init>"));
        }
    }

    private static final class JSStructureImplicitNamespace
    extends JSImplicitElementImpl {
        private JSStructureImplicitNamespace(JSQualifiedName parent, JSPsiElementBase element) {
            super(new JSImplicitElementImpl.Builder(parent, (PsiElement)element).setType(JSStructureImplicitNamespace.isClassMemberDefinition((PsiElement)element) ? JSImplicitElement.Type.Class : JSImplicitElement.Type.Namespace));
        }

        private static boolean isClassMemberDefinition(PsiElement element) {
            return element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getJSContext() == JSContext.INSTANCE;
        }
    }
}

