/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.settings.JSRootConfigurationPanel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRootConfigurable
implements SearchableConfigurable {
    public static final String ID = "Settings.JavaScript";
    private JSRootConfigurationPanel myMainPanel;
    private final JSRootConfiguration myRootConfiguration;
    private final Project myProject;

    public JSRootConfigurable(@NotNull Project project) {
        if (project == null) {
            JSRootConfigurable.$$$reportNull$$$0(0);
        }
        this.myRootConfiguration = JSRootConfiguration.getInstance(project);
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return JavaScriptBundle.message("settings.javascript.root.configurable.name", new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        return this.getMainPanel();
    }

    public boolean isModified() {
        @Nullable String storedLanguageLevel = this.myRootConfiguration.getStoredLanguageLevel();
        @NotNull JSLanguageLevel panelLanguageLevel = this.myMainPanel.getLanguageLevel();
        return storedLanguageLevel == null && !panelLanguageLevel.equals((Object)JSLanguageLevel.DEFAULT) || storedLanguageLevel != null && !panelLanguageLevel.equals((Object)JSLanguageLevel.ofId(storedLanguageLevel)) || !this.myMainPanel.getFlowPanel().getFlowSettings().equals(FlowJSSettingsManager.getInstance(this.myProject).getRawSettings());
    }

    public void apply() throws ConfigurationException {
        JSLanguageLevel newLanguageLevel = this.myMainPanel.getLanguageLevel();
        this.applyFlowSettings(newLanguageLevel);
        this.myRootConfiguration.storeLanguageLevelAndUpdateCaches(newLanguageLevel);
    }

    private void applyFlowSettings(JSLanguageLevel newLanguageLevel) throws ConfigurationException {
        String errorMessage;
        boolean serviceEnabled;
        FlowJSSettings settings2 = this.myMainPanel.getFlowPanel().getFlowSettings();
        if (this.myProject.isDefault()) {
            FlowJSSettingsManager.getInstance(this.myProject).loadState(settings2);
            return;
        }
        FlowJSSettings oldSettings = FlowJSSettingsManager.getInstance(this.myProject).getRawSettings();
        boolean bl = serviceEnabled = newLanguageLevel == JSLanguageLevel.FLOW && settings2.getFlowExecutable() != null && settings2.isTypeCheckingEnabled();
        if (serviceEnabled && (errorMessage = FlowJSServerService.isFlowServerAvailable(settings2.getFlowExecutable(), this.myProject)) != null) {
            throw new ConfigurationException(JavaScriptBundle.message("js.flow.enable.flow.service.error.message", errorMessage));
        }
        boolean mayKeepRunningServer = newLanguageLevel == JSLanguageLevel.FLOW && newLanguageLevel == this.myRootConfiguration.getLanguageLevel() && StringUtil.equals((CharSequence)oldSettings.getFlowExecutablePath(), (CharSequence)settings2.getFlowExecutablePath()) && oldSettings.isTypeCheckingEnabled() == settings2.isTypeCheckingEnabled();
        WriteAction.run(() -> {
            FlowJSSettingsManager.getInstance(this.myProject).loadState(settings2);
            if (!mayKeepRunningServer) {
                for (FlowJSServerService service2 : FlowJSServerManager.getInstance(this.myProject).getAllServers()) {
                    service2.shutdown();
                }
            }
        });
        if (newLanguageLevel == JSLanguageLevel.FLOW || this.myRootConfiguration.getLanguageLevel() == JSLanguageLevel.FLOW) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public void reset() {
        JSLanguageLevel storedLanguageLevel = JSLanguageLevel.ofId(this.myRootConfiguration.getStoredLanguageLevel());
        this.myMainPanel.setLanguageLevel(storedLanguageLevel);
        FlowJSSettings settings2 = FlowJSSettingsManager.getInstance(this.myProject).getRawSettings();
        this.myMainPanel.getFlowPanel().setFlowSettings(settings2);
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
    }

    @NotNull
    public JPanel getMainPanel() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JSRootConfigurationPanel(this.myProject);
        }
        JPanel jPanel = this.myMainPanel.getPanel();
        if (jPanel == null) {
            JSRootConfigurable.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> {
            if (option != null && StringUtil.containsIgnoreCase((String)option, (String)"flow") && this.myMainPanel.getPanel().isShowing()) {
                this.myMainPanel.myJSLanguageVersion.showPopup();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/settings/JSRootConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/settings/JSRootConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

