/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.MessageStreamLoggerKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "Ljava/io/Closeable;", "logPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getLogPath$intellij_javascript_impl", "()Ljava/nio/file/Path;", "writer", "Ljava/io/PrintWriter;", "getWriter", "()Ljava/io/PrintWriter;", "writer$delegate", "Lkotlin/Lazy;", "close", "", "logInbound", "jsonBody", "", "logOutbound", "intellij.javascript.impl"})
public final class MessageStreamLogger
implements Closeable {
    @NotNull
    private final Path logPath;
    @NotNull
    private final Lazy writer$delegate;

    public MessageStreamLogger(@NotNull Path logPath) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        this.logPath = logPath;
        this.writer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PrintWriter>(this){
            final /* synthetic */ MessageStreamLogger this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PrintWriter invoke() {
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
                return new PrintWriter(new BufferedOutputStream(Files.newOutputStream(this.this$0.getLogPath$intellij_javascript_impl(), openOptionArray)));
            }
        }));
    }

    @NotNull
    public final Path getLogPath$intellij_javascript_impl() {
        return this.logPath;
    }

    private final PrintWriter getWriter() {
        Lazy lazy = this.writer$delegate;
        return (PrintWriter)lazy.getValue();
    }

    public final void logInbound(@NotNull CharSequence jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.getWriter().write(MessageStreamLoggerKt.access$getTIMESTAMP_FORMAT$p().format(new Date(System.currentTimeMillis())) + " IN  " + jsonBody + "\n");
    }

    public final void logOutbound(@NotNull CharSequence jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.getWriter().write(MessageStreamLoggerKt.access$getTIMESTAMP_FORMAT$p().format(new Date(System.currentTimeMillis())) + " OUT " + jsonBody + "\n");
    }

    @Override
    public void close() {
        this.getWriter().close();
    }
}

