/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.MessageStreamLogger;
import com.intellij.lang.javascript.service.MessageStreamLoggerServiceKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/service/LoggerBucket;", "", "fileName", "", "(Ljava/lang/String;)V", "activeLoggers", "", "Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "lock", "Ljava/lang/Object;", "cleanup", "", "connect", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "millisToPrintableTime", "millis", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nMessageStreamLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/LoggerBucket\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n13#2:103\n1747#3,3:104\n1855#3,2:107\n*S KotlinDebug\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/LoggerBucket\n*L\n40#1:103\n47#1:104,3\n92#1:107,2\n*E\n"})
final class LoggerBucket {
    @NotNull
    private final String fileName;
    @NotNull
    private final Object lock;
    @NotNull
    private final List<MessageStreamLogger> activeLoggers;

    public LoggerBucket(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        this.lock = new Object();
        this.activeLoggers = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final MessageStreamLogger connect(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Object object = this.lock;
        synchronized (object) {
            block9: {
                boolean bl = false;
                if (this.activeLoggers.size() < 5) break block9;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(LoggerBucket.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot create a logger for " + this.fileName + ", too many active loggers");
                MessageStreamLogger messageStreamLogger = null;
                return messageStreamLogger;
            }
            long currentTimeMillis = System.currentTimeMillis();
            String newFileName = null;
            while (true) {
                boolean bl;
                block10: {
                    newFileName = this.fileName + "-" + this.millisToPrintableTime(currentTimeMillis) + ".log";
                    Iterable $this$any$iv = this.activeLoggers;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MessageStreamLogger it = (MessageStreamLogger)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)((Object)it.getLogPath$intellij_javascript_impl().getFileName()).toString(), (Object)newFileName)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    Path path2 = MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p().resolve(newFileName);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    if (!Files.exists(path2, new LinkOption[0])) break;
                }
                ++currentTimeMillis;
            }
            Files.createDirectories(MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p(), new FileAttribute[0]);
            Path path3 = MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p().resolve(newFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path logPath = path3;
            MessageStreamLogger logger = new MessageStreamLogger(logPath);
            this.activeLoggers.add(logger);
            Disposer.register((Disposable)parentDisposable, () -> LoggerBucket.connect$lambda$4$lambda$2(logger, this));
            ApplicationKt.getApplication().executeOnPooledThread(() -> LoggerBucket.connect$lambda$4$lambda$3(this));
            MessageStreamLogger messageStreamLogger = logger;
            return messageStreamLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        Regex fileNamePattern = new Regex(this.fileName + "-\\d{8}-\\d{6}-\\d{3}\\.log");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            List<Object> files2 = Files.list(MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p()).filter(arg_0 -> LoggerBucket.cleanup$lambda$7$lambda$5((Function1)new Function1<Path, Boolean>(fileNamePattern, this){
                final /* synthetic */ Regex $fileNamePattern;
                final /* synthetic */ LoggerBucket this$0;
                {
                    this.$fileNamePattern = $fileNamePattern;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(Path it) {
                    boolean bl;
                    String fileName = ((Object)it.getFileName()).toString();
                    if (this.$fileNamePattern.matches((CharSequence)fileName)) {
                        boolean bl2;
                        block5: {
                            Iterable $this$any$iv = LoggerBucket.access$getActiveLoggers$p(this.this$0);
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    MessageStreamLogger activeLogger = (MessageStreamLogger)element$iv;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual((Object)((Object)activeLogger.getLogPath$intellij_javascript_impl().getFileName()).toString(), (Object)fileName)) continue;
                                    bl2 = true;
                                    break block5;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            }, arg_0)).sorted().toList();
            int toKeep = 5 - this.activeLoggers.size();
            if (toKeep >= files2.size()) {
                return;
            }
            int toRemove = Math.min(files2.size(), files2.size() - toKeep);
            Intrinsics.checkNotNull(files2);
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)files2, (int)toRemove);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                Files.deleteIfExists(it);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String millisToPrintableTime(long millis) {
        String string = MessageStreamLoggerServiceKt.access$getLOG_FILENAME_SUFFIX_FORMAT$p().format(new Date(millis));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void connect$lambda$4$lambda$2(MessageStreamLogger $logger, LoggerBucket this$0) {
        Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $logger.close();
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.activeLoggers.remove($logger);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void connect$lambda$4$lambda$3(LoggerBucket this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cleanup();
    }

    private static final boolean cleanup$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getActiveLoggers$p(LoggerBucket $this) {
        return $this.activeLoggers;
    }
}

