/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JSLanguageServiceUpdateContext {
    @NotNull
    private final Map<VirtualFile, Document> myUnsavedContents;
    @NotNull
    private final Map<VirtualFile, Document> myOpenContents;
    @NotNull
    private final Map<VirtualFile, Document> myFilesOpenBySideEffect;
    @NotNull
    private final Map<VirtualFile, Long> myTimestamps;

    public JSLanguageServiceUpdateContext(@NotNull Map<VirtualFile, Document> unsavedContents, @NotNull Map<VirtualFile, Document> openContents, @NotNull Map<VirtualFile, Document> filesOpenBySideEffect, @NotNull Map<VirtualFile, Long> timestamps) {
        if (unsavedContents == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(0);
        }
        if (openContents == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(1);
        }
        if (filesOpenBySideEffect == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(2);
        }
        if (timestamps == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(3);
        }
        if (!(timestamps.keySet().containsAll(unsavedContents.keySet()) && timestamps.keySet().containsAll(openContents.keySet()) && timestamps.keySet().containsAll(filesOpenBySideEffect.keySet()))) {
            Logger.getInstance(JSLanguageServiceUpdateContext.class).error((Throwable)new IllegalArgumentException("Timestamps contains not all files: unsavedContents=" + unsavedContents.keySet() + ", openContents=" + openContents.keySet() + ", filesOpnBySideEffect=" + filesOpenBySideEffect.keySet() + ", timestamps=" + timestamps.keySet()));
        }
        this.myUnsavedContents = unsavedContents;
        this.myOpenContents = openContents;
        this.myFilesOpenBySideEffect = filesOpenBySideEffect;
        this.myTimestamps = timestamps;
    }

    @NotNull
    public Map<VirtualFile, Document> getUnsavedContents() {
        Map<VirtualFile, Document> map = this.myUnsavedContents;
        if (map == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public Map<VirtualFile, Document> getOpenContents() {
        Map<VirtualFile, Document> map = this.myOpenContents;
        if (map == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    public Map<VirtualFile, Document> getFilesOpenBySideEffect() {
        Map<VirtualFile, Document> map = this.myFilesOpenBySideEffect;
        if (map == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public Map<VirtualFile, Long> getTimestamps() {
        Map<VirtualFile, Long> map = this.myTimestamps;
        if (map == null) {
            JSLanguageServiceUpdateContext.$$$reportNull$$$0(7);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JSLanguageServiceUpdateContext)) {
            return false;
        }
        JSLanguageServiceUpdateContext context2 = (JSLanguageServiceUpdateContext)o;
        return Objects.equals(this.myUnsavedContents, context2.myUnsavedContents) && Objects.equals(this.myOpenContents, context2.myOpenContents) && Objects.equals(this.myFilesOpenBySideEffect, context2.myFilesOpenBySideEffect) && Objects.equals(this.myTimestamps, context2.myTimestamps);
    }

    public int hashCode() {
        return Objects.hash(this.myUnsavedContents, this.myOpenContents, this.myFilesOpenBySideEffect, this.myTimestamps);
    }

    public String toString() {
        return "JSLanguageServiceUpdateContext{myUnsavedContents=" + this.myUnsavedContents + ", myOpenContents=" + this.myOpenContents + ", myFilesOpenBySideEffect=" + this.myFilesOpenBySideEffect + ", myTimestamps=" + this.myTimestamps + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsavedContents";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openContents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesOpenBySideEffect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamps";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceUpdateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceUpdateContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedContents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenContents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesOpenBySideEffect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestamps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

