/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class JSLanguageServiceResultContainer {
    @NotNull
    private final List<String> myProcessedFiles;
    @NotNull
    private final List<String> myEmittedFiles;
    @NotNull
    private final List<? extends JSAnnotationError> myAnnotationResults;

    public JSLanguageServiceResultContainer(@NotNull @Unmodifiable List<? extends JSAnnotationError> annotationResults, @NotNull List<String> processedFiles, @NotNull List<String> emittedFiles) {
        if (annotationResults == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(0);
        }
        if (processedFiles == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(1);
        }
        if (emittedFiles == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(2);
        }
        this.myProcessedFiles = processedFiles;
        this.myAnnotationResults = annotationResults;
        this.myEmittedFiles = emittedFiles;
    }

    @NotNull
    public List<String> getEmittedFiles() {
        List<String> list2 = this.myEmittedFiles;
        if (list2 == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public List<String> getProcessedFiles() {
        List<String> list2 = this.myProcessedFiles;
        if (list2 == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public @Unmodifiable ImmutableList<JSAnnotationError> getAnnotationResults() {
        ImmutableList immutableList = ContainerUtil.immutableList(this.myAnnotationResults);
        if (immutableList == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @NotNull
    public @Unmodifiable List<? extends JSAnnotationError> getResults() {
        List<? extends JSAnnotationError> list2 = this.myAnnotationResults;
        if (list2 == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static JSLanguageServiceResultContainer compose(@NotNull List<JSLanguageServiceResultContainer> containers) {
        if (containers == null) {
            JSLanguageServiceResultContainer.$$$reportNull$$$0(7);
        }
        ArrayList<String> myProcessedFiles = new ArrayList<String>();
        ArrayList<String> myEmittedFiles = new ArrayList<String>();
        ArrayList<? extends JSAnnotationError> myAnnotationResults = new ArrayList<JSAnnotationError>();
        for (JSLanguageServiceResultContainer container : containers) {
            myProcessedFiles.addAll(container.myProcessedFiles);
            myEmittedFiles.addAll(container.myEmittedFiles);
            myAnnotationResults.addAll(container.myAnnotationResults);
        }
        return new JSLanguageServiceResultContainer(myAnnotationResults, myProcessedFiles, myEmittedFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResults";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emittedFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmittedFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationResults";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

