/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.Consumer;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceQueueImpl
extends JSLanguageServiceExecutorImpl
implements JSLanguageServiceQueue {
    @NotNull
    private static final Scope TELEMETRY_SCOPE = new Scope("jsLanguageService", null, true);
    @NotNull
    private final JSLanguageServiceCacheData myCacheData;
    @NotNull
    private final Lock myCacheSyncLock;

    public JSLanguageServiceQueueImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter, @NotNull JSLanguageServiceCacheData cacheData) {
        if (project == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(0);
        }
        if (protocol == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(2);
        }
        if (cacheData == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(3);
        }
        super(project, protocol, connector, reporter);
        this.myCacheSyncLock = new ReentrantLock();
        this.myCacheData = cacheData;
        LowMemoryWatcher.register(this::resetCaches, (Disposable)this);
    }

    @Override
    public void resetCaches() {
        this.myCacheData.clear();
    }

    @Override
    @Nullable
    public final <T> CompletableFuture<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand input, @NotNull JSLanguageServiceCacheableCommandProcessor<? extends T> processor) {
        if (input == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(5);
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeWithCacheImpl(input, processor);
                    return t;
                }
                catch (Throwable err) {
                    if (!(err instanceof ControlFlowException)) {
                        JSLanguageServiceQueue.Holder.LOGGER.error(err.getMessage(), err);
                    }
                }
                finally {
                    this.endAction();
                }
                return null;
            }, this.myExecutorService);
        }
        catch (RejectedExecutionException exception) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    private <T> T executeWithCacheImpl(@NotNull JSLanguageServiceCacheableCommand input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(7);
        }
        long startTime = System.currentTimeMillis();
        Object valueFromCache = this.myCacheData.getValueFromCache(input);
        if (valueFromCache != null) {
            if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.debug("Used service cache " + input);
            }
            return processor.processFromCache(input, valueFromCache);
        }
        JSLanguageServiceObject objectToSend = this.myCacheData.updateCacheAndGetServiceObject(input);
        if (objectToSend == null) {
            if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.debug("Skip processing: " + input);
            }
            return null;
        }
        this.startAction(input);
        JSLanguageServiceAnswer answer = this.await(input, objectToSend);
        if (answer == null || answer.isEmpty() || this.myState != JSLanguageServiceExecutor.State.STARTED) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("There is no result");
            this.myCacheData.putCacheValue(input, answer, null);
            return null;
        }
        T result2 = processor.process(input, objectToSend, answer);
        this.myCacheData.putCacheValue(input, answer, result2);
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            long totalTime = System.currentTimeMillis() - startTime;
            JSLanguageServiceQueue.Holder.LOGGER.debug("Total process queue command " + input.getCommand() + " time, millis: " + totalTime);
        }
        return result2;
    }

    @Override
    @Nullable
    public final <T> CompletableFuture<T> execute(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(9);
        }
        try {
            String serviceName;
            Span span = TelemetryManager.Companion.getTracer(TELEMETRY_SCOPE).spanBuilder(command.getCommand()).startSpan();
            JSLanguageServiceProtocol protocol = this.getProtocol();
            if (protocol instanceof JSLanguageServiceNodeStdProtocolBase) {
                JSLanguageServiceNodeStdProtocolBase base = (JSLanguageServiceNodeStdProtocolBase)protocol;
                v0 = base.myServiceName;
            } else {
                v0 = serviceName = null;
            }
            if (serviceName == null) {
                serviceName = "other";
            }
            span.setAttribute("js.service", serviceName);
            return JSLanguageServiceQueueImpl.supplyAndProcessWithSpan(span, () -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeImpl(command, processor);
                    return t;
                }
                catch (Throwable e) {
                    if (!(e instanceof ControlFlowException)) {
                        JSLanguageServiceQueue.Holder.LOGGER.error(e);
                    }
                    throw e;
                }
                finally {
                    this.endAction();
                }
            }, this.myExecutorService);
        }
        catch (RejectedExecutionException exception) {
            JSLanguageServiceQueue.Holder.LOGGER.warn(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @NotNull
    private static <T> CompletableFuture<T> supplyAndProcessWithSpan(@NotNull Span span, @NotNull Supplier<T> supplier, @NotNull Executor executor) {
        CompletableFuture<T> completableFuture;
        if (span == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(10);
        }
        if (supplier == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(11);
        }
        if (executor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(12);
        }
        try {
            CompletableFuture<T> future = CompletableFuture.supplyAsync(supplier, executor);
            future.whenComplete((r, t) -> span.end());
            completableFuture = future;
        }
        catch (Throwable t2) {
            span.end();
            throw t2;
        }
        if (completableFuture == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(13);
        }
        return completableFuture;
    }

    @Nullable
    public <T> T executeImpl(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(15);
        }
        long startTime = System.currentTimeMillis();
        JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
        if (serviceObject == null) {
            return null;
        }
        this.startAction(command);
        JSLanguageServiceAnswer answer = this.await(command, serviceObject);
        if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        T process = processor.process(serviceObject, answer);
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Total process queue " + command.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
        }
        return process;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<? super JSLanguageServiceAnswer> answerConsumer) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(16);
        }
        return this.executeNoBlocking(command, answerConsumer, null);
    }

    @Override
    @Nullable
    public final CompletableFuture<Void> executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<? super JSLanguageServiceAnswer> answerConsumer, @Nullable Consumer<? super JSLanguageServiceObject> serviceObjectConsumer) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(17);
        }
        try {
            return JSLanguageServiceUtil.cancellableSynchronized(this.myCacheSyncLock, () -> {
                JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
                return CompletableFuture.supplyAsync(() -> {
                    block5: {
                        if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                            return null;
                        }
                        if (answerConsumer != null) {
                            this.startAction(command);
                        }
                        try {
                            this.executeNoBlockingImpl(command, answerConsumer, serviceObjectConsumer, serviceObject);
                        }
                        catch (IOException e) {
                            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof ControlFlowException) break block5;
                            JSLanguageServiceQueue.Holder.LOGGER.error(throwable.getMessage(), throwable);
                        }
                    }
                    return null;
                }, this.myExecutorService);
            });
        }
        catch (RejectedExecutionException exception) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private void executeNoBlockingImpl(final @NotNull JSLanguageServiceCommand command, final @Nullable Consumer<? super JSLanguageServiceAnswer> consumer, @Nullable Consumer<? super JSLanguageServiceObject> afterSendData, @Nullable JSLanguageServiceObject serviceObject) throws Exception {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(18);
        }
        if (serviceObject == null) {
            return;
        }
        final long startTime = System.currentTimeMillis();
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Send data for: " + command.getCommand());
        }
        this.sendData(command, serviceObject, consumer == null ? null : new JSLanguageServiceAnswerConsumer(){

            @Override
            public void consume(JSLanguageServiceAnswer message) {
                if (JSLanguageServiceQueueImpl.this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    return;
                }
                JSLanguageServiceQueueImpl.this.endAction();
                if (message != null) {
                    consumer.consume((Object)message);
                    if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                        long processingTime = System.currentTimeMillis() - startTime;
                        JSLanguageServiceQueue.Holder.LOGGER.debug("Total process queue non-blocking command " + command.getCommand() + " time, millis: " + processingTime);
                    }
                }
            }
        });
        if (afterSendData != null) {
            afterSendData.consume((Object)serviceObject);
        }
    }

    @Nullable
    private JSLanguageServiceAnswer await(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data) {
        block11: {
            if (command == null) {
                JSLanguageServiceQueueImpl.$$$reportNull$$$0(19);
            }
            if (data == null) {
                JSLanguageServiceQueueImpl.$$$reportNull$$$0(20);
            }
            try {
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug("Start await \"" + command.getCommand() + "\"");
                }
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicReference ref = new AtomicReference();
                Object cancellationToken = this.sendData(command, data, new JSLanguageServiceAnswerConsumer(){

                    @Override
                    public void consume(JSLanguageServiceAnswer message) {
                        ref.set(message);
                        latch.countDown();
                    }
                });
                if (JSLanguageServiceUtil.TIMEOUT_DISABLED) {
                    latch.await();
                } else if (!latch.await(command.getTimeout(), TimeUnit.MILLISECONDS)) {
                    this.handleCommandTimeout(command, cancellationToken);
                }
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug("Language Service answer was received: " + command.getCommand());
                }
                return (JSLanguageServiceAnswer)ref.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            catch (Throwable err) {
                if (err instanceof ControlFlowException) break block11;
                JSLanguageServiceQueue.Holder.LOGGER.error(err.getMessage(), err);
            }
        }
        return null;
    }

    protected void handleCommandTimeout(@NotNull JSLanguageServiceCommand command, @NotNull Object cancellationToken) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(21);
        }
        if (cancellationToken == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(22);
        }
        this.getProtocol().cancelCommand(cancellationToken);
        this.infoLog("Timeout waiting answer for: " + command.getCommand());
    }

    @NotNull
    protected Object sendData(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer consumer) throws Exception {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(23);
        }
        if (data == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(24);
        }
        JSLanguageServiceUtil.assertServiceRequestAllowed();
        Object object = this.getProtocol().sendCommand(command, data, consumer);
        if (object == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(25);
        }
        return object;
    }

    @Override
    protected void doDispose() {
        super.doDispose();
        Disposer.dispose((Disposable)this.myCacheData);
    }

    @Override
    @NotNull
    public JSLanguageServiceProtocol getProtocol() {
        JSLanguageServiceProtocol jSLanguageServiceProtocol = (JSLanguageServiceProtocol)this.myServiceConnector;
        if (jSLanguageServiceProtocol == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(26);
        }
        return jSLanguageServiceProtocol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheData";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 13: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "supplyAndProcessWithSpan";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sendData";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeWithCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeWithCacheImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supplyAndProcessWithSpan";
                break;
            }
            case 13: 
            case 25: 
            case 26: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeNoBlocking";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "executeNoBlockingImpl";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "await";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "handleCommandTimeout";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sendData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 25, 26 -> new IllegalStateException(string);
        };
    }
}

