/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSMemberSearchParameters;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

abstract class JSMembersSearchImpl<T extends JSPsiElementBase>
implements QueryExecutor<T, JSMemberSearchParameters<T>> {
    @NotNull
    private final Class<T> myMemberClass;

    JSMembersSearchImpl(@NotNull Class<T> memberClass) {
        if (memberClass == null) {
            JSMembersSearchImpl.$$$reportNull$$$0(0);
        }
        this.myMemberClass = memberClass;
    }

    public boolean execute(@NotNull JSMemberSearchParameters<T> queryParameters, @NotNull Processor<? super T> consumer) {
        T baseMember;
        JSClass baseClass;
        if (queryParameters == null) {
            JSMembersSearchImpl.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            JSMembersSearchImpl.$$$reportNull$$$0(2);
        }
        if ((baseClass = JSUtils.getMemberContainingClass(baseMember = queryParameters.getBaseMember())) == null) {
            return true;
        }
        return this.makeQuery(queryParameters, baseClass).forEach(currentClass -> {
            boolean lookInSupers = baseClass.isInterface() && !currentClass.isInterface();
            String memberName = baseMember.getName();
            if (memberName == null) {
                return true;
            }
            if (baseMember instanceof JSFunction) {
                JSFunction function2 = JSInheritanceUtil.findMethodInClass((JSFunction)baseMember, currentClass, lookInSupers);
                if (this.isAcceptable(function2)) {
                    return consumer.process((Object)function2);
                }
                JSQualifiedNamedElement member = JSInheritanceUtil.findMember(memberName, currentClass, JSInheritanceUtil.SearchedMemberType.Fields, null, lookInSupers);
                if (this.isAcceptable(member)) {
                    return consumer.process((Object)member);
                }
            } else if (baseMember instanceof JSField || baseMember instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)baseMember)) {
                JSQualifiedNamedElement member = JSInheritanceUtil.findMember(memberName, currentClass, JSInheritanceUtil.SearchedMemberType.Fields, null, lookInSupers);
                if (this.isAcceptable(member)) {
                    return consumer.process((Object)member);
                }
                boolean hasSetterOrGetter = false;
                if (!currentClass.isInterface()) {
                    JSQualifiedNamedElement setter;
                    JSQualifiedNamedElement getter = JSInheritanceUtil.findMember(memberName, currentClass, JSInheritanceUtil.SearchedMemberType.Methods, JSFunction.FunctionKind.GETTER, lookInSupers);
                    if (this.isAcceptable(getter)) {
                        hasSetterOrGetter = true;
                        if (!consumer.process((Object)getter)) {
                            return false;
                        }
                    }
                    if (this.isAcceptable(setter = JSInheritanceUtil.findMember(memberName, currentClass, JSInheritanceUtil.SearchedMemberType.Methods, JSFunction.FunctionKind.SETTER, lookInSupers))) {
                        hasSetterOrGetter = true;
                        if (!consumer.process((Object)setter)) {
                            return false;
                        }
                    }
                }
                if (!hasSetterOrGetter && this.isAcceptable(member = JSInheritanceUtil.findMember(memberName, currentClass, JSInheritanceUtil.SearchedMemberType.Methods, null, lookInSupers))) {
                    return consumer.process((Object)member);
                }
            }
            return true;
        });
    }

    private boolean isAcceptable(JSQualifiedNamedElement member) {
        return member != null && this.myMemberClass.isInstance(member) && JSInheritanceUtil.canHaveSuperMember((JSAttributeListOwner)((Object)member));
    }

    protected abstract Query<JSClass> makeQuery(JSMemberSearchParameters<T> var1, JSClass var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/search/JSMembersSearchImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class JSOverridingMembersSearch<T2 extends JSPsiElementBase>
    extends JSMembersSearchImpl<T2> {
        JSOverridingMembersSearch(@NotNull Class<T2> memberClass) {
            if (memberClass == null) {
                JSOverridingMembersSearch.$$$reportNull$$$0(0);
            }
            super(memberClass);
        }

        @Override
        protected Query<JSClass> makeQuery(JSMemberSearchParameters<T2> queryParameters, JSClass parent) {
            return JSClassSearch.searchClassInheritors(parent, queryParameters.isCheckDeepInheritance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberClass", "com/intellij/lang/javascript/search/JSMembersSearchImpl$JSOverridingMembersSearch", "<init>"));
        }
    }

    static final class JSImplementingMembersSearch<T1 extends JSPsiElementBase>
    extends JSMembersSearchImpl<T1> {
        JSImplementingMembersSearch(@NotNull Class<T1> memberClass) {
            if (memberClass == null) {
                JSImplementingMembersSearch.$$$reportNull$$$0(0);
            }
            super(memberClass);
        }

        @Override
        protected Query<JSClass> makeQuery(JSMemberSearchParameters<T1> queryParameters, JSClass parent) {
            return JSClassSearch.searchInterfaceImplementations(parent, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberClass", "com/intellij/lang/javascript/search/JSMembersSearchImpl$JSImplementingMembersSearch", "<init>"));
        }
    }
}

