/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.ui;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.lang.javascript.ui.JSClassChooserDialog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ComboboxEditorTextField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtilRt;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSReferenceEditor
extends ComponentWithBrowseButton<JComponent>
implements TextAccessor {
    private final Project myProject;
    private final String myRecentsKey;
    private GlobalSearchScope myScope;
    private @NlsContexts.DialogMessage @Nullable String myChooserBlockMessage;

    protected abstract ActionListener createActionListener();

    protected JSReferenceEditor(String text2, @NotNull Project project, @Nullable String recentsKey, GlobalSearchScope scope2, @Nullable JavaScriptParserBase.ForceContext typeContext, @Nullable Condition<JSClass> filter, final @NlsContexts.DialogTitle @NotNull String chooserTitle, boolean needPackages, @Nullable PsiElement context2) {
        if (project == null) {
            JSReferenceEditor.$$$reportNull$$$0(0);
        }
        if (chooserTitle == null) {
            JSReferenceEditor.$$$reportNull$$$0(1);
        }
        super((JComponent)(recentsKey != null ? JSReferenceEditor.createEditorCombo(project, JSReferenceEditor.createDocument(StringUtil.notNullize((String)text2), project, scope2, typeContext, filter, needPackages, context2)) : new JSEditorTextField(project, JSReferenceEditor.createDocument(StringUtil.notNullize((String)text2), project, scope2, typeContext, filter, needPackages, context2))), null);
        this.myProject = project;
        this.myRecentsKey = recentsKey;
        this.myScope = scope2;
        if (this.myRecentsKey != null) {
            List recentEntries = RecentsManager.getInstance((Project)this.myProject).getRecentEntries(recentsKey);
            if (recentEntries != null) {
                ((EditorComboBox)this.getChildComponent()).setHistory(ArrayUtilRt.toStringArray((Collection)recentEntries));
            }
            if (text2 != null) {
                ((EditorComboBox)this.getChildComponent()).prependItem(text2);
            }
        }
        final ActionListener actionListener = this.createActionListener();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JSReferenceEditor.this.myChooserBlockMessage != null) {
                    Messages.showErrorDialog((String)JSReferenceEditor.this.myChooserBlockMessage, (String)chooserTitle);
                } else {
                    actionListener.actionPerformed(e);
                }
            }
        });
    }

    public void setScope(GlobalSearchScope scope2) {
        this.myScope = scope2;
        PsiFile codeFragment = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getDocument());
        ((PsiCodeFragment)codeFragment).forceResolveScope(scope2);
        this.invalidateHighlight();
    }

    public void invalidateHighlight() {
        this.setText(this.getText(), true);
    }

    public void setChooserBlockingMessage(@NlsContexts.DialogMessage @Nullable String message) {
        this.myChooserBlockMessage = message;
    }

    @Deprecated
    public void setHeightProvider(Computable<Integer> heightProvider) {
        if (this.getChildComponent() instanceof MyEditorComboBox) {
            ((MyEditorComboBox)((Object)this.getChildComponent())).setHeightProvider(heightProvider);
        }
    }

    public static EditorComboBox createEditorCombo(Project project, Document document2) {
        return new MyEditorComboBox(document2, project);
    }

    private static Document createDocument(String text2, Project project, GlobalSearchScope scope2, @Nullable JavaScriptParserBase.ForceContext typeContext, final @Nullable Condition<JSClass> filter, final boolean needPackages, @Nullable PsiElement context2) {
        JSExpressionCodeFragment fragment = JSElementFactory.createExpressionCodeFragment(project, text2, null, JavaScriptSupportLoader.ECMA_SCRIPT_L4, scope2, JSElementFactory.TopLevelCompletion.NO, typeContext);
        fragment.putUserData(JSResolveUtil.contextKey, context2);
        fragment.putUserData(ResolveProcessor.PROCESSING_OPTIONS, new ResolveProcessor.ProcessingOptions(){

            @Override
            public boolean needPackages() {
                return needPackages;
            }

            @Override
            @Nullable
            public Condition<JSClass> getFilter() {
                return filter;
            }
        });
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }

    public void addDocumentListener(DocumentListener listener2) {
        this.getDocument().addDocumentListener(listener2);
    }

    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getDocument());
    }

    private Document getDocument() {
        return this.getChildComponent() instanceof EditorComboBox ? ((EditorComboBox)this.getChildComponent()).getDocument() : ((EditorTextField)this.getChildComponent()).getDocument();
    }

    public String getText() {
        return this.getDocument().getText().trim();
    }

    public void setText(String text2) {
        this.setText(text2, false);
    }

    private void setText(String text2, boolean keepCaret) {
        if (text2 == null) {
            text2 = "";
        }
        if (this.getChildComponent() instanceof EditorComboBox) {
            EditorEx editor;
            ((EditorComboBox)this.getChildComponent()).setText(text2);
            if (!keepCaret && StringUtil.isNotEmpty((String)text2) && (editor = ((EditorComboBox)this.getChildComponent()).getEditorEx()) != null) {
                editor.getCaretModel().moveToOffset(text2.length());
            }
        } else {
            Editor editor;
            ((EditorTextField)this.getChildComponent()).setText(text2);
            if (!keepCaret && StringUtil.isNotEmpty((String)text2) && (editor = ((EditorTextField)this.getChildComponent()).getEditor()) != null) {
                editor.getCaretModel().moveToOffset(text2.length());
            }
        }
    }

    public void updateRecents() {
        if (this.myRecentsKey != null) {
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(this.myRecentsKey, this.getText());
        }
    }

    protected GlobalSearchScope getScope() {
        return this.myScope;
    }

    public static JSReferenceEditor forClassName(String text2, @NotNull Project project, @Nullable String recentsKey, GlobalSearchScope scope2, @Nullable JavaScriptParserBase.ForceContext typeContext, @Nullable Condition<JSClass> classFilter, @NlsContexts.DialogTitle @NotNull String chooserTitle) {
        if (project == null) {
            JSReferenceEditor.$$$reportNull$$$0(2);
        }
        if (chooserTitle == null) {
            JSReferenceEditor.$$$reportNull$$$0(3);
        }
        return JSReferenceEditor.forClassName(text2, project, recentsKey, scope2, typeContext, classFilter, chooserTitle, null);
    }

    public static JSReferenceEditor forClassName(String text2, final @NotNull Project project, @Nullable String recentsKey, GlobalSearchScope scope2, @Nullable JavaScriptParserBase.ForceContext typeContext, final @Nullable Condition<JSClass> classFilter, final @NlsContexts.DialogTitle @NotNull String chooserTitle, @Nullable PsiElement context2) {
        if (project == null) {
            JSReferenceEditor.$$$reportNull$$$0(4);
        }
        if (chooserTitle == null) {
            JSReferenceEditor.$$$reportNull$$$0(5);
        }
        return new JSReferenceEditor(text2, project, recentsKey, scope2, typeContext, classFilter, chooserTitle, false, context2){

            @Override
            protected ActionListener createActionListener() {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JSClass clazz;
                        if (DumbService.getInstance((Project)project).isDumb()) {
                            Messages.showWarningDialog((String)JavaScriptBundle.message("class.chooser.not.available.in.dumb.mode", new Object[0]), (String)chooserTitle);
                            return;
                        }
                        PsiElement initialClass = this.getText() != null ? JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(this.getText(), this.getScope()) : null;
                        JSClassChooserDialog chooser = new JSClassChooserDialog(project, chooserTitle, this.getScope(), initialClass instanceof JSClass ? (JSClass)initialClass : null, (Condition<? super JSClass>)classFilter);
                        if (chooser.showDialog() && (clazz = chooser.getSelectedClass()) != null) {
                            this.setText(clazz.getQualifiedName());
                        }
                    }
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooserTitle";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "forClassName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyEditorComboBox
    extends EditorComboBox {
        private Computable<Integer> myHeightProvider;

        MyEditorComboBox(Document document2, Project project) {
            super(document2, project, (FileType)JavaScriptSupportLoader.JAVASCRIPT);
        }

        public void setHeightProvider(Computable<Integer> heightProvider) {
            this.myHeightProvider = heightProvider;
        }

        public Dimension getPreferredSize() {
            Dimension result2 = new Dimension(super.getPreferredSize());
            if (this.myHeightProvider != null) {
                result2.height = (Integer)this.myHeightProvider.compute();
            }
            return result2;
        }

        protected ComboboxEditorTextField createEditorTextField(final Document document2, final Project project, FileType fileType, boolean isViewer) {
            return new ComboboxEditorTextField(document2, project, fileType, isViewer){

                @NotNull
                protected EditorEx createEditor() {
                    EditorEx e = super.createEditor();
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document2);
                    e.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file.getName()));
                    EditorEx editorEx = e;
                    if (editorEx == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return editorEx;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor$MyEditorComboBox$1", "createEditor"));
                }
            };
        }
    }
}

