/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceConstant;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceConstant.JSIntroduceConstantDialog;
import com.intellij.lang.javascript.refactoring.introduceConstant.JSIntroduceConstantSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexIntroduceConstantHandler
extends JSBaseIntroduceHandler<JSElement, JSIntroduceConstantSettings, JSIntroduceConstantDialog> {
    private boolean myIntroducingInTheSameClass;
    private boolean myShortRefIsAmbigousOrUnequal;

    @Override
    protected String getRefactoringName() {
        return JavaScriptBundle.message("javascript.introduce.constant.title", new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.constant.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.constant.error.expression.has.void.type";
    }

    @Override
    protected JSIntroduceConstantDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope2) {
        return new JSIntroduceConstantDialog(project, occurrences, expression, scope2);
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> baseIntroduceContext, JSElement anchor) {
        @NonNls String baseDeclText = "static const " + ((JSIntroduceConstantSettings)baseIntroduceContext.settings).getVariableName();
        return FlexIntroduceConstantHandler.prependAccessModifier(baseIntroduceContext, baseDeclText);
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> context2, boolean replaceAllOccurrences) {
        JSElement element = FlexIntroduceConstantHandler.findClassAnchor((PsiElement)context2.expressionDescriptor.first);
        String className = ((JSIntroduceConstantSettings)context2.settings).getClassName();
        if (!StringUtil.isEmpty((String)className)) {
            PsiElement qName = JSResolveUtil.findType(className, (PsiElement)context2.expressionDescriptor.first, true);
            assert (qName instanceof JSClass);
            if (element != null && qName == JSResolveUtil.findParent((PsiElement)element)) {
                this.myIntroducingInTheSameClass = true;
            }
            return (JSElement)qName;
        }
        return element;
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> context2, Project project, @Nullable JSLanguageDialect languageDialect, JSElement anchorStatement, Editor editor) throws IncorrectOperationException {
        String qName = ((JSIntroduceConstantSettings)context2.settings).getClassName();
        if (!StringUtil.isEmpty((String)qName) && !this.myIntroducingInTheSameClass && StringUtil.getPackageName((String)qName).length() > 0) {
            this.myShortRefIsAmbigousOrUnequal = JSResolveUtil.shortReferenceIsAmbiguousOrUnequal(JSResolveUtil.getShortTypeName(qName, true), (PsiElement)context2.expressionDescriptor.first, qName, true);
            if (!this.myShortRefIsAmbigousOrUnequal) {
                ImportUtils.doImport((PsiElement)context2.expressionDescriptor.first, qName, false);
            }
        }
        return super.prepareDeclaration(varDeclText, context2, project, languageDialect, anchorStatement, editor);
    }

    @Override
    public JSExpression createRefExpr(PsiElement context2, JSIntroduceConstantSettings settings2, PsiElement scope2, JSLanguageDialect languageDialect) {
        String qName = settings2.getClassName();
        if (!StringUtil.isEmpty((String)qName) && !this.myIntroducingInTheSameClass) {
            String className = this.myShortRefIsAmbigousOrUnequal ? qName : JSResolveUtil.getShortTypeName(qName, true);
            return JSPsiElementFactory.createJSExpression(className + "." + settings2.getVariableName(), context2);
        }
        return super.createRefExpr(context2, settings2, scope2, languageDialect);
    }

    @Override
    protected JSVariable addStatementBefore(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        return FlexIntroduceConstantHandler.addToClassAnchor(anchor, declaration);
    }

    @Override
    protected boolean validateSelectedExpression(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        if (file == null) {
            FlexIntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FlexIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if (expressionDescriptor == null) {
            FlexIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        if (!super.validateSelectedExpression(file, editor, expressionDescriptor)) {
            return false;
        }
        final Ref hasAccesibilityProblem = new Ref();
        ((JSExpression)expressionDescriptor.first).accept(new JSElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.getQualifier() == null) {
                    PsiElement element = node.resolve();
                    if (element instanceof JSAttributeListOwner && !(element instanceof JSClass) && !JSResolveUtil.isConstructorFunction(element)) {
                        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
                        if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                            hasAccesibilityProblem.set((Object)Boolean.TRUE);
                        }
                    } else if (element == null) {
                        hasAccesibilityProblem.set((Object)Boolean.TRUE);
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            @Override
            public void visitJSElement(@NotNull JSElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                node.acceptChildren(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceConstant/FlexIntroduceConstantHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (Boolean.TRUE.equals(hasAccesibilityProblem.get())) {
            this.showErrorHint(editor, file, JavaScriptBundle.message("javascript.introduce.constant.error.not.constant.expression.selected", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected InplaceSettings<JSIntroduceConstantSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope2, OccurrencesChooser.ReplaceChoice choice) {
        return null;
    }

    @Override
    protected JSBaseInplaceIntroducer createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> context2, JSElement scope2, Editor editor, Project project, JSExpression[] occurences, Runnable callback) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "expressionDescriptor";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/introduceConstant/FlexIntroduceConstantHandler";
        objectArray[2] = "validateSelectedExpression";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

