/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.ES6RedundantNestingInTemplateLiteralInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.inline.InjectionQuoteHandler;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSFunctionInliner
extends JSInlineHandler.Inliner {
    @NotNull
    private final JSFunction myFunction;
    private final Set<String> myNonfinalParameters;
    private final ES6ReferenceExpressionsInfo myReferenceExpressionsInfoForCall;

    JSFunctionInliner(@NotNull PsiElement declaration, @NotNull JSFunction function2) {
        if (declaration == null) {
            JSFunctionInliner.$$$reportNull$$$0(0);
        }
        if (function2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(1);
        }
        super(declaration);
        this.myFunction = function2;
        JSElement body2 = JSPsiImplUtils.getFunctionBody(function2);
        this.myNonfinalParameters = JSFunctionInliner.getNonFinalParameters(function2);
        this.myReferenceExpressionsInfoForCall = body2 != null ? ES6ReferenceExpressionsInfo.getInfo((PsiElement)body2) : ES6ReferenceExpressionsInfo.EMPTY;
    }

    @Override
    @NotNull
    JSInlineHandler.Inliner.JSInlineHandlerResult doInlineUsage(@NotNull JSReferenceExpression referenceExpression) {
        JSExpression expression;
        boolean shouldReplaceWithFunctionExpression;
        if (referenceExpression == null) {
            JSFunctionInliner.$$$reportNull$$$0(2);
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)referenceExpression.getParent(), JSCallExpression.class);
        HashMap<PsiElement, String> additionalElementsToImport = new HashMap<PsiElement, String>();
        boolean bl = shouldReplaceWithFunctionExpression = callExpression == null || this.myFunction.isAsync() && !ES6PsiUtil.isAsyncFunction((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSFunction.class));
        if (shouldReplaceWithFunctionExpression) {
            JSElement result2;
            JSExpression leftmostQualifier = JSResolveUtil.getLeftmostQualifier(referenceExpression);
            JSExpression thisExpression = this.myFunction.isArrowFunction() || leftmostQualifier instanceof JSThisExpression ? referenceExpression.getQualifier() : null;
            JSFunction replacement = JSFunctionInliner.buildReplacementFunction(this.myFunction, referenceExpression, Collections.emptyMap(), Map.of(), thisExpression, additionalElementsToImport, false);
            if (replacement == null) {
                JSInlineHandler.Inliner.JSInlineHandlerResult jSInlineHandlerResult = JSInlineHandler.Inliner.JSInlineHandlerResult.EMPTY;
                if (jSInlineHandlerResult == null) {
                    JSFunctionInliner.$$$reportNull$$$0(3);
                }
                return jSInlineHandlerResult;
            }
            JSExpression replacementFunctionExpression = this.modifyIfAccessor(replacement instanceof JSFunctionExpression ? (JSFunctionExpression)replacement.copy() : JSFunctionsRefactoringUtil.createAnonymousFunctionExpression(replacement));
            if (referenceExpression.getParent() instanceof ES6Property && ((ES6Property)referenceExpression.getParent()).isShorthanded()) {
                String propertyValueText = replacementFunctionExpression.getText();
                result2 = ES6ChangeUtil.expandShorthandPropertyWithValue((ES6Property)referenceExpression.getParent(), propertyValueText);
            } else {
                result2 = JSChangeUtil.replaceExpression(referenceExpression, replacementFunctionExpression);
            }
            return new JSInlineHandler.Inliner.JSInlineHandlerResult((PsiElement)result2, additionalElementsToImport);
        }
        JSElement[] replacement = this.calculateReplacementForCall(this.myFunction, callExpression, additionalElementsToImport);
        Object usageParent = callExpression.getParent();
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSStatement.class);
        assert (statement != null);
        if (usageParent instanceof JSFunctionExpression && ((JSFunctionExpression)usageParent).isShorthandArrowFunction() && this.shouldExpandTargetBody(replacement) && (expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)usageParent)) == callExpression) {
            JSRefactoringUtil.addBracesToShorthandArrowFunction((JSFunctionExpression)usageParent);
            statement = (JSStatement)((JSFunctionExpression)usageParent).getBlock().getStatementListItems()[0];
            usageParent = statement;
            if (statement instanceof JSExpressionStatement) {
                callExpression = (JSCallExpression)((JSExpressionStatement)statement).getExpression();
            } else if (statement instanceof JSReturnStatement) {
                callExpression = (JSCallExpression)((JSReturnStatement)statement).getExpression();
            }
            assert (callExpression != null) : "call expression is null for " + statement.getClass().getName();
        }
        if (!(usageParent instanceof JSExpressionStatement) && replacement.length > 0 && (expression = JSFunctionInliner.tryGetSingleExpression(replacement[replacement.length - 1])) != null) {
            if (replacement.length > 1) {
                JSFunctionInliner.addStatementRangeWithComments(statement, replacement, replacement.length - 2);
            }
            return new JSInlineHandler.Inliner.JSInlineHandlerResult(JSFunctionInliner.performExpressionReplacement(callExpression, expression), additionalElementsToImport);
        }
        if (replacement.length > 0) {
            PsiElement result3 = JSFunctionInliner.addStatementRangeWithComments(statement, replacement, replacement.length - 1);
            statement.delete();
            return new JSInlineHandler.Inliner.JSInlineHandlerResult(result3, additionalElementsToImport);
        }
        JSInlineHandler.deleteElementWithReformat((PsiElement)statement);
        JSInlineHandler.Inliner.JSInlineHandlerResult jSInlineHandlerResult = JSInlineHandler.Inliner.JSInlineHandlerResult.EMPTY;
        if (jSInlineHandlerResult == null) {
            JSFunctionInliner.$$$reportNull$$$0(4);
        }
        return jSInlineHandlerResult;
    }

    private boolean shouldExpandTargetBody(JSElement @NotNull [] replacement) {
        if (replacement == null) {
            JSFunctionInliner.$$$reportNull$$$0(5);
        }
        if (this.myFunction.isShorthandArrowFunction()) {
            return false;
        }
        JSBlockStatement block = this.myFunction.getBlock();
        if (block == null) {
            return true;
        }
        int numStatements = block.getStatementListItems().length;
        return numStatements != 1 || replacement.length == 1 && JSFunctionInliner.tryGetSingleExpression(replacement[replacement.length - 1]) == null;
    }

    private JSExpression modifyIfAccessor(JSFunctionExpression replacementFunctionExpression) {
        JSExpression expression;
        JSSourceElement[] items;
        if (!this.myFunction.isGetProperty()) {
            return replacementFunctionExpression;
        }
        JSBlockStatement block = replacementFunctionExpression.getBlock();
        if (block != null && (items = block.getStatementListItems()).length == 1 && items[0] instanceof JSReturnStatement && (expression = ((JSReturnStatement)items[0]).getExpression()) != null) {
            return expression;
        }
        JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(replacementFunctionExpression);
        if (returnExpression != null) {
            return returnExpression;
        }
        if (DialectDetector.hasFeature(this.myFunction, JSLanguageFeature.ARROW_FUNCTIONS)) {
            return JSPsiElementFactory.createJSExpression("(" + replacementFunctionExpression.getParameterList().getText() + " => " + JSPsiImplUtils.getFunctionBody(replacementFunctionExpression).getText() + ")()", this.myFunction);
        }
        return JSPsiElementFactory.createJSExpression("(" + replacementFunctionExpression.getText() + ")()", this.myFunction);
    }

    @Nullable
    private static PsiElement addStatementRangeWithComments(@NotNull JSStatement anchorBefore, JSElement @NotNull [] replacement, int endIndex) {
        if (anchorBefore == null) {
            JSFunctionInliner.$$$reportNull$$$0(6);
        }
        if (replacement == null) {
            JSFunctionInliner.$$$reportNull$$$0(7);
        }
        PsiElement first = (PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)replacement[0], PsiComment.class), (Object)replacement[0]);
        PsiElement last = (PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.getNextSiblingOfType((PsiElement)replacement[endIndex], PsiComment.class), (Object)replacement[endIndex]);
        return SharedImplUtil.addRange((PsiElement)anchorBefore.getParent(), (PsiElement)first, (PsiElement)last, (ASTNode)anchorBefore.getNode(), (Boolean)Boolean.TRUE);
    }

    @Override
    public void removeDefinition(@NotNull PsiElement element) {
        ASTNode prev;
        PsiElement whitespace;
        if (element == null) {
            JSFunctionInliner.$$$reportNull$$$0(8);
        }
        if (element instanceof JSFunction && element.getParent() instanceof JSClass && (whitespace = (prev = element.getNode().getTreePrev()).getPsi()) instanceof PsiWhiteSpace) {
            whitespace.delete();
        }
        if (element instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> result2 = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)element);
            result2.add((TypeScriptFunction)element);
            List toRemove = result2.stream().sorted(Comparator.comparing(function2 -> function2.getTextRange().getStartOffset())).map(function2 -> {
                PsiElement parent = function2.getParent();
                return parent instanceof ES6ExportDefaultAssignment ? (ES6ExportDefaultAssignment)parent : function2;
            }).collect(Collectors.toList());
            JSInlineHandler.deleteSourceElementRange((JSSourceElement)toRemove.get(0), (JSSourceElement)toRemove.get(toRemove.size() - 1));
        } else if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            JSInlineHandler.deleteElementWithReformat(element.getParent());
        } else {
            JSInlineHandler.deleteElementWithReformat(element);
        }
    }

    private JSElement @NotNull [] calculateReplacementForCall(@NotNull JSFunction referenced, @NotNull JSCallExpression callExpr, @NotNull Map<PsiElement, String> additionalElementsToImport) {
        JSSourceElement[] statements;
        if (referenced == null) {
            JSFunctionInliner.$$$reportNull$$$0(9);
        }
        if (callExpr == null) {
            JSFunctionInliner.$$$reportNull$$$0(10);
        }
        if (additionalElementsToImport == null) {
            JSFunctionInliner.$$$reportNull$$$0(11);
        }
        JSExpression[] expressions = callExpr.getArguments();
        int currentActualIndex = 0;
        Map<String, PsiNamedElement> elementsInScope = JSFunctionInliner.collectNamesInScope((PsiElement)callExpr);
        HashMap<String, Object> parametersToActual = new HashMap<String, Object>();
        ArrayList<String> initializers = new ArrayList<String>();
        for (JSParameterListElement p : referenced.getParameters()) {
            JSExpression actual = (JSExpression)ObjectUtils.coalesce((Object)(currentActualIndex < expressions.length ? expressions[currentActualIndex] : null), (Object)p.getInitializer());
            Map<String, Object> map = JSFunctionInliner.tryMatchParametersToActual(p, actual);
            if (map != null && ContainerUtil.all(map.keySet(), s -> !this.myNonfinalParameters.contains(s))) {
                parametersToActual.putAll(map);
            } else {
                JSParameterListElement declaration = JSFunctionInliner.ensureUniqueNamesForDeclaration(p, elementsInScope.keySet(), parametersToActual);
                initializers.add(JSFunctionInliner.getVarStatementText((PsiElement)callExpr, declaration, actual));
            }
            ++currentActualIndex;
        }
        PsiElement usageParent = callExpr.getParent();
        boolean isExpressionStatement = usageParent instanceof JSExpressionStatement;
        JSExpression thisExpression = ((JSReferenceExpression)callExpr.getMethodExpression()).getQualifier();
        JSFunction replacementFun = JSFunctionInliner.buildReplacementFunction(referenced, callExpr, parametersToActual, elementsInScope, thisExpression, additionalElementsToImport, isExpressionStatement);
        if (replacementFun == null) {
            if (JSElement.EMPTY_ARRAY == null) {
                JSFunctionInliner.$$$reportNull$$$0(12);
            }
            return JSElement.EMPTY_ARRAY;
        }
        JSExpression arrowReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(replacementFun);
        if (arrowReturnExpression != null) {
            JSElement[] jSElementArray = new JSElement[]{arrowReturnExpression};
            if (jSElementArray == null) {
                JSFunctionInliner.$$$reportNull$$$0(13);
            }
            return jSElementArray;
        }
        JSBlockStatement body2 = replacementFun.getBlock();
        JSSourceElement[] jSSourceElementArray = statements = body2 != null ? body2.getStatementListItems() : JSSourceElement.EMPTY_ARRAY;
        if (body2 == null || statements.length == 0) {
            if (JSElement.EMPTY_ARRAY == null) {
                JSFunctionInliner.$$$reportNull$$$0(14);
            }
            return JSElement.EMPTY_ARRAY;
        }
        JSSourceElement anchor = statements[0];
        boolean addBefore = true;
        for (String statement : initializers) {
            JSVarStatement varStatement = JSPsiElementFactory.createJSStatement(statement, (PsiElement)callExpr, JSVarStatement.class);
            anchor = addBefore ? JSChangeUtil.doAddBefore(anchor.getParent(), (PsiElement)varStatement, (PsiElement)anchor) : JSChangeUtil.doAddAfter(anchor.getParent(), (PsiElement)varStatement, (PsiElement)anchor);
            addBefore = false;
        }
        JSElement[] jSElementArray = body2.getStatementListItems();
        if (jSElementArray == null) {
            JSFunctionInliner.$$$reportNull$$$0(15);
        }
        return jSElementArray;
    }

    @Nullable
    private static JSExpression tryGetSingleExpression(@NotNull JSElement statement) {
        if (statement == null) {
            JSFunctionInliner.$$$reportNull$$$0(16);
        }
        if (statement instanceof JSExpression) {
            return (JSExpression)statement;
        }
        if (statement instanceof JSExpressionStatement) {
            return ((JSExpressionStatement)statement).getExpression();
        }
        if (statement instanceof JSReturnStatement) {
            return ((JSReturnStatement)statement).getExpression();
        }
        return null;
    }

    @NotNull
    private static JSParameterListElement ensureUniqueNamesForDeclaration(@NotNull JSParameterListElement parameterListElement, @NotNull Collection<String> namesInScope, @NotNull Map<String, Object> parametersToActualMap) {
        if (parameterListElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(17);
        }
        if (namesInScope == null) {
            JSFunctionInliner.$$$reportNull$$$0(18);
        }
        if (parametersToActualMap == null) {
            JSFunctionInliner.$$$reportNull$$$0(19);
        }
        JSParameterListElement copy = (JSParameterListElement)parameterListElement.copy();
        PsiTreeUtil.processElements((PsiElement)copy, element -> {
            String newName;
            JSParameter parameter;
            String parameterName;
            if (element instanceof JSParameter && (parameterName = (parameter = (JSParameter)element).getName()) != null && !StringUtil.equals((CharSequence)parameterName, (CharSequence)(newName = JSNameSuggestionsUtil.ensureUniqueVariableName(parameterName, null, namesInScope, true)))) {
                PsiElement patt16584$temp = parameter.getParent();
                if (patt16584$temp instanceof JSDestructuringShorthandedProperty) {
                    JSDestructuringShorthandedProperty property = (JSDestructuringShorthandedProperty)patt16584$temp;
                    property.replace((PsiElement)ES6ChangeUtil.expandDestructuringPropertyWithVariableName(property, newName));
                } else {
                    parameter.setName(newName);
                }
                parametersToActualMap.put(parameterName, newName);
            }
            return true;
        });
        JSParameterListElement jSParameterListElement = copy;
        if (jSParameterListElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(20);
        }
        return jSParameterListElement;
    }

    @Nullable
    private static JSFunction buildReplacementFunction(@NotNull JSFunction referenced, @NotNull JSExpression context2, @NotNull Map<String, Object> parametersToActualMap, @NotNull Map<String, PsiNamedElement> elementsInCallScope, @Nullable JSExpression thisExpression, @NotNull Map<PsiElement, String> additionalElementsToImport, boolean replaceReturnStatements) {
        if (referenced == null) {
            JSFunctionInliner.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(22);
        }
        if (parametersToActualMap == null) {
            JSFunctionInliner.$$$reportNull$$$0(23);
        }
        if (elementsInCallScope == null) {
            JSFunctionInliner.$$$reportNull$$$0(24);
        }
        if (additionalElementsToImport == null) {
            JSFunctionInliner.$$$reportNull$$$0(25);
        }
        String replacementText = JSFunctionInliner.buildReplacement(referenced, referenced, context2, parametersToActualMap, elementsInCallScope, thisExpression, additionalElementsToImport, replaceReturnStatements);
        if (JSUtils.getMemberContainingClass(referenced) != null) {
            return JSChangeUtil.createClassMemberPsiFromTextWithContext(replacementText, referenced, JSFunction.class);
        }
        if (referenced instanceof JSFunctionProperty) {
            return (JSFunction)JSChangeUtil.createObjectLiteralPropertyFromText(replacementText, referenced);
        }
        ASTNode functionNode = JSChangeUtil.createJSTreeFromTextWithContext(replacementText, referenced);
        if (functionNode != null && functionNode.getPsi() instanceof JSExpressionStatement) {
            return (JSFunctionExpression)((JSExpressionStatement)functionNode.getPsi()).getExpression();
        }
        return (JSFunction)functionNode.getPsi();
    }

    static String buildReplacement(final @NotNull JSNamedElement referencedDeclaration, @NotNull PsiElement elementToUpdate, final @NotNull JSExpression usageContext, @NotNull Map<String, Object> parametersToActualMap, final @NotNull Map<String, PsiNamedElement> elementsInCallScope, @Nullable JSExpression thisExpression, final @NotNull Map<PsiElement, String> additionalElementsToImport, final boolean replaceReturnStatements) {
        if (referencedDeclaration == null) {
            JSFunctionInliner.$$$reportNull$$$0(26);
        }
        if (elementToUpdate == null) {
            JSFunctionInliner.$$$reportNull$$$0(27);
        }
        if (usageContext == null) {
            JSFunctionInliner.$$$reportNull$$$0(28);
        }
        if (parametersToActualMap == null) {
            JSFunctionInliner.$$$reportNull$$$0(29);
        }
        if (elementsInCallScope == null) {
            JSFunctionInliner.$$$reportNull$$$0(30);
        }
        if (additionalElementsToImport == null) {
            JSFunctionInliner.$$$reportNull$$$0(31);
        }
        final String thisValue = thisExpression != null ? thisExpression.getText() : null;
        int funOffset = -elementToUpdate.getTextRange().getStartOffset();
        DocumentImpl document2 = new DocumentImpl(elementToUpdate.getText());
        final HashMap parameterRefs = new HashMap();
        final HashMap markersToParametersMap = new HashMap();
        final HashMap simpleReplacements = new HashMap();
        InjectionQuoteHandler injectionQuoteHandler = new InjectionQuoteHandler((PsiElement)usageContext);
        final HashMap declarationsToRename = new HashMap();
        final JSTypeSubstitutor substitutor = JSFunctionInliner.createGenericsSubstitutor(referencedDeclaration, usageContext);
        elementToUpdate.accept((PsiElementVisitor)new JSRecursiveElementVisitor((Document)document2, funOffset){
            final /* synthetic */ Document val$document;
            final /* synthetic */ int val$funOffset;
            {
                this.val$document = document2;
                this.val$funOffset = n;
            }

            @Override
            public void visitJSElement(@NotNull JSElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSElement(node);
                if ((node instanceof JSVariable || node instanceof JSClass || node instanceof JSFunction) && node != referencedDeclaration && JSUseScopeProvider.getLexicalScope((PsiElement)node) == referencedDeclaration) {
                    String name = ((JSNamedElement)node).getName();
                    PsiElement identifier = ((JSQualifiedNamedElement)node).getNameIdentifier();
                    if (StringUtil.isNotEmpty((String)name) && identifier != null && elementsInCallScope.containsKey(name)) {
                        String newName = JSNameSuggestionsUtil.ensureUniqueVariableName(name, null, elementsInCallScope.keySet(), true);
                        declarationsToRename.put(node, newName);
                        simpleReplacements.put(this.createRangeMarkerToReplace(identifier), newName);
                    }
                }
            }

            @Override
            public void visitJSThisExpression(@NotNull JSThisExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitJSThisExpression(node);
                if ((this.isFunctionToInline(node) || node.resolve() == JSUtils.getMemberContainingClass((PsiElement)referencedDeclaration)) && thisValue != null) {
                    simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), thisValue);
                }
            }

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                JSExpression qualifier;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((qualifier = node.getQualifier()) == null) {
                    PsiElement nodeTarget = node.resolve();
                    if (nodeTarget instanceof JSParameter) {
                        JSParameter parameter = (JSParameter)nodeTarget;
                        if (parameter.getName() != null && parameter.getDeclaringFunction() == referencedDeclaration) {
                            RangeMarker rangeMarker = this.createRangeMarkerToReplace((PsiElement)node);
                            markersToParametersMap.put(rangeMarker, parameter.getName());
                            parameterRefs.put(node, rangeMarker);
                        }
                    } else if (node.getParent() != nodeTarget && nodeTarget != null) {
                        JSClass containingClass = JSUtils.getMemberContainingClass(nodeTarget);
                        if ((nodeTarget instanceof JSFunction || nodeTarget instanceof JSVariable) && containingClass != null && !JSResolveUtil.isConstructorFunction(nodeTarget)) {
                            boolean isStatic = JSPsiImplUtils.hasModifier((JSAttributeListOwner)nodeTarget, JSAttributeList.ModifierType.STATIC);
                            if (isStatic) {
                                simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), containingClass.getName() + "." + node.getText());
                            } else if (thisValue != null) {
                                String value = thisValue + "." + node.getText();
                                simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), value);
                            }
                        } else if (declarationsToRename.containsKey(nodeTarget)) {
                            String newName = (String)declarationsToRename.get(nodeTarget);
                            if (newName != null) {
                                simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), newName);
                            }
                        } else if (nodeTarget instanceof TypeScriptTypeParameter) {
                            JSTypeGenericId genericId = ((TypeScriptTypeParameter)nodeTarget).getGenericId();
                            JSType type2 = substitutor.get(genericId);
                            if (type2 != null) {
                                simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), type2.getTypeText(JSType.TypeTextFormat.CODE));
                            }
                        } else {
                            String name = node.getText();
                            PsiNamedElement reachableElement = (PsiNamedElement)elementsInCallScope.get(name);
                            if (containingClass == null && reachableElement != null && !reachableElement.isEquivalentTo(nodeTarget)) {
                                boolean isImportRequired;
                                boolean bl = isImportRequired = !reachableElement.getContainingFile().isEquivalentTo((PsiElement)nodeTarget.getContainingFile());
                                if (isImportRequired) {
                                    String newName = this.getNameFromExistingImport(nodeTarget, name);
                                    if (newName == null) {
                                        newName = JSNameSuggestionsUtil.ensureUniqueVariableName(name, (PsiElement)node, elementsInCallScope.keySet(), false);
                                    }
                                    additionalElementsToImport.put(nodeTarget, newName);
                                    simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), newName);
                                }
                            }
                        }
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            @Nullable
            private String getNameFromExistingImport(@NotNull PsiElement nodeTarget, @NotNull String referenceName) {
                if (nodeTarget == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (referenceName == null) {
                    1.$$$reportNull$$$0(4);
                }
                String newName = null;
                List<ES6ImportSpecifier> existingSpecifiers = ES6ImportPsiUtil.getImportDeclarations((PsiElement)usageContext.getContainingFile()).stream().flatMap(declaration -> Arrays.stream(declaration.getImportSpecifiers())).filter(specifier -> Objects.equals(specifier.getReferenceName(), referenceName)).toList();
                for (ES6ImportSpecifier specifier2 : existingSpecifiers) {
                    PsiElement resolved = specifier2.resolve();
                    if (resolved == null || !resolved.isEquivalentTo(nodeTarget)) continue;
                    String declaredName = specifier2.getDeclaredName();
                    Object aliasedElement = (PsiElement)elementsInCallScope.get(declaredName);
                    if (aliasedElement instanceof ES6ImportSpecifierAlias) {
                        aliasedElement = ((ES6ImportSpecifierAlias)aliasedElement).findSpecifierElement();
                    }
                    if (aliasedElement instanceof PsiReference) {
                        aliasedElement = ((PsiReference)aliasedElement).resolve();
                    }
                    if (aliasedElement == null || !aliasedElement.isEquivalentTo(nodeTarget)) continue;
                    newName = declaredName;
                    break;
                }
                return newName;
            }

            @Override
            public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (this.isFunctionToInline(node) && replaceReturnStatements) {
                    JSExpression expression = node.getExpression();
                    if (expression != null && SideEffectChecker.mayHaveSideEffects(expression)) {
                        TextRange range = new TextRange(node.getTextRange().getStartOffset(), expression.getTextRange().getStartOffset());
                        simpleReplacements.put(this.createRangeMarkerToReplace(range), "");
                    } else {
                        simpleReplacements.put(this.createRangeMarkerToReplace((PsiElement)node), "");
                    }
                }
                super.visitJSReturnStatement(node);
            }

            private boolean isFunctionToInline(JSElement node) {
                return PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class) == referencedDeclaration;
            }

            private RangeMarker createRangeMarkerToReplace(@NotNull PsiElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(6);
                }
                return this.createRangeMarkerToReplace(node.getTextRange());
            }

            private RangeMarker createRangeMarkerToReplace(@NotNull TextRange textRange2) {
                if (textRange2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                return this.val$document.createRangeMarker(textRange2.shiftRight(this.val$funOffset));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodeTarget";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceName";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textRange";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSFunctionInliner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSThisExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getNameFromExistingImport";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReturnStatement";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createRangeMarkerToReplace";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        injectionQuoteHandler.fixQuotes(elementToUpdate, funOffset, (Document)document2);
        for (Map.Entry pair : parameterRefs.entrySet()) {
            JSReferenceExpression parameterUsage = (JSReferenceExpression)pair.getKey();
            RangeMarker rangeMarker = (RangeMarker)pair.getValue();
            String parameter = (String)markersToParametersMap.get(rangeMarker);
            Object actual = parametersToActualMap.get(parameter);
            if (actual == null) continue;
            String expressionText = actual instanceof JSExpression ? ((JSExpression)actual).getText() : actual.toString();
            String introducedString = actual instanceof JSExpression && JSParenthesesUtils.needsParenthesis(parameterUsage, (JSExpression)actual) ? "(" + expressionText + ")" : expressionText;
            ES6Property property = (ES6Property)ObjectUtils.tryCast((Object)parameterUsage.getParent(), ES6Property.class);
            introducedString = property != null && property.isShorthanded() && !StringUtil.equals((CharSequence)property.getName(), (CharSequence)introducedString) ? String.format("%s: %s", property.getName(), introducedString) : introducedString;
            document2.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)introducedString);
        }
        for (Map.Entry entry : simpleReplacements.entrySet()) {
            RangeMarker marker = (RangeMarker)entry.getKey();
            document2.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)entry.getValue());
        }
        return document2.getText();
    }

    @NotNull
    private static JSTypeSubstitutor createGenericsSubstitutor(@NotNull JSNamedElement referencedDeclaration, @NotNull JSExpression usageContext) {
        JSExpression methodExpression;
        if (referencedDeclaration == null) {
            JSFunctionInliner.$$$reportNull$$$0(32);
        }
        if (usageContext == null) {
            JSFunctionInliner.$$$reportNull$$$0(33);
        }
        if (usageContext instanceof JSCallExpression && (methodExpression = ((JSCallExpression)usageContext).getMethodExpression()) != null) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(referencedDeclaration, (PsiElement)methodExpression);
            if (jSTypeSubstitutor == null) {
                JSFunctionInliner.$$$reportNull$$$0(34);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSFunctionInliner.$$$reportNull$$$0(35);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    public static JSInlineHandler.Settings handleFunction(@NotNull JSFunction fun, @Nullable Editor editor, boolean invokedOnReference, NotNullLazyValue<Collection<PsiReference>> deferredUsages) {
        JSBlockStatement bodyBlock;
        if (fun == null) {
            JSFunctionInliner.$$$reportNull$$$0(36);
        }
        Project project = fun.getProject();
        if (JSProjectUtil.isInLibrary(fun.getContainingFile())) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.function.defined.in.library", new Object[0]), editor, project);
            return null;
        }
        if (fun.isReferencesArguments()) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.function.referencing.arguments", new Object[0]), editor, project);
            return null;
        }
        if (TypeScriptPsiUtil.isAmbientDeclaration(fun)) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.ambient.function", new Object[0]), editor, project);
            return null;
        }
        if (fun.getParent() instanceof JSClass && ((JSClass)fun.getParent()).isInterface()) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.interface.method", new Object[0]), editor, project);
            return null;
        }
        for (JSParameter p : fun.getParameterVariables()) {
            if (!p.isRest()) continue;
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.function.referencing.rest.parameter", new Object[0]), editor, project);
            return null;
        }
        if (JSInheritanceUtil.participatesInHierarchy(fun)) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.overrided.or.overridden.method", new Object[0]), editor, project);
            return null;
        }
        if (JSFunctionInliner.isRecursive(fun)) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.recursive.function", new Object[0]), editor, project);
            return null;
        }
        List<JSReturnStatement> returnStatements = JSFunctionInliner.collectOwnReturns(fun);
        if (ContainerUtil.or(returnStatements, arg_0 -> JSFunctionInliner.lambda$handleFunction$4(bodyBlock = fun.getBlock(), arg_0)) && ContainerUtil.or((Iterable)((Iterable)deferredUsages.getValue()), ref -> JSFunctionInliner.isNonLastStatementInBlock(ref.getElement()))) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.function.with.multiple.returns", new Object[0]), editor, project);
            return null;
        }
        if (bodyBlock != null && bodyBlock.getStatementListItems().length > 1 && ContainerUtil.or(returnStatements, statement -> statement.getExpression() != null) && ContainerUtil.or((Iterable)((Iterable)deferredUsages.getValue()), ref -> {
            PsiElement parentElement = ref.getElement().getParent();
            return parentElement instanceof JSCallExpression && !(parentElement.getParent() instanceof JSExpressionStatement);
        })) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.complex.expression.evaluation", new Object[0]), editor, project);
            return null;
        }
        for (PsiReference ref2 : (Collection)deferredUsages.getValue()) {
            PsiElement elt = ref2.getElement();
            PsiElement parent = elt.getParent();
            if (!(parent instanceof JSNewExpression)) continue;
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.constructor", new Object[0]), editor, project);
            return null;
        }
        return new JSInlineHandler.Settings(deferredUsages, invokedOnReference);
    }

    @Override
    @NotNull
    protected ES6ReferenceExpressionsInfo getReferenceExpressionsInfo(@NotNull PsiElement referenceElement) {
        if (referenceElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(37);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = referenceElement.getParent() instanceof JSCallExpression ? this.myReferenceExpressionsInfoForCall : super.getReferenceExpressionsInfo(referenceElement);
        if (eS6ReferenceExpressionsInfo == null) {
            JSFunctionInliner.$$$reportNull$$$0(38);
        }
        return eS6ReferenceExpressionsInfo;
    }

    static void inlineFunctionProblem(@NlsContexts.DialogMessage @NotNull String message, @Nullable Editor editor, Project project) {
        if (message == null) {
            JSFunctionInliner.$$$reportNull$$$0(39);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaScriptBundle.message("javascript.refactoring.inline.function.title", new Object[0]), null);
    }

    @Nullable
    private static Map<String, Object> tryMatchParametersToActual(@NotNull JSParameterListElement param, @Nullable JSExpression expression) {
        LinkedHashMap<String, Object> result2;
        if (param == null) {
            JSFunctionInliner.$$$reportNull$$$0(40);
        }
        return JSFunctionInliner.tryMatchInitializerOwner(param, expression, result2 = new LinkedHashMap<String, Object>()) ? result2 : null;
    }

    private static boolean tryMatchDestructuringPattern(@Nullable JSDestructuringContainer target, @Nullable JSExpression expression, @NotNull Map<String, Object> result2) {
        if (result2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(41);
        }
        if (expression == null) {
            return true;
        }
        if (target instanceof JSDestructuringObject && expression instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression object = (JSObjectLiteralExpression)expression;
            for (JSDestructuringProperty property : ((JSDestructuringObject)target).getProperties()) {
                JSExpression value;
                JSInitializerOwner propertyTarget = property.getDestructuringElement();
                if (propertyTarget == null || property.isRest()) {
                    return false;
                }
                JSProperty objectProperty = object.findProperty(property.getName());
                JSExpression jSExpression = value = objectProperty != null && objectProperty.getValue() != null ? objectProperty.getValue() : null;
                if (JSFunctionInliner.tryMatchInitializerOwner(propertyTarget, value, result2)) continue;
                return false;
            }
            return true;
        }
        if (target instanceof JSDestructuringArray && expression instanceof JSArrayLiteralExpression) {
            if (((JSDestructuringArray)target).getRestElement() != null) {
                return false;
            }
            JSInitializerOwner[] destructuringElements = ((JSDestructuringArray)target).getElements();
            JSExpression[] expressions = ((JSArrayLiteralExpression)expression).getExpressions();
            for (int i = 0; i < destructuringElements.length; ++i) {
                JSExpression value;
                JSExpression jSExpression = value = i < expressions.length ? expressions[i] : null;
                if (JSFunctionInliner.tryMatchInitializerOwner(destructuringElements[i], value, result2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean tryMatchInitializerOwner(@NotNull JSInitializerOwner initializerOwner, @Nullable JSExpression actual, @NotNull Map<String, Object> result2) {
        if (initializerOwner == null) {
            JSFunctionInliner.$$$reportNull$$$0(42);
        }
        if (result2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(43);
        }
        actual = (JSExpression)ObjectUtils.coalesce((Object)actual, (Object)initializerOwner.getInitializer());
        if (initializerOwner instanceof JSParameter) {
            ContainerUtil.putIfNotNull((Object)initializerOwner.getName(), (Object)ObjectUtils.coalesce((Object)actual, (Object)"undefined"), result2);
            return true;
        }
        if (initializerOwner instanceof JSDestructuringElement) {
            return JSFunctionInliner.tryMatchDestructuringPattern(((JSDestructuringElement)initializerOwner).getTarget(), actual, result2);
        }
        return false;
    }

    @NotNull
    private static String getVarStatementText(@NotNull PsiElement context2, @NotNull JSParameterListElement parameterListElement, @Nullable JSExpression initializer) {
        if (context2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(44);
        }
        if (parameterListElement == null) {
            JSFunctionInliner.$$$reportNull$$$0(45);
        }
        StringBuilder builder2 = new StringBuilder(JSChangeUtil.getVariablePrefix(context2));
        builder2.append(" ");
        builder2.append(parameterListElement.getDeclarationElement().getText());
        PsiElement typeElement = parameterListElement.getTypeElement();
        if (typeElement != null) {
            builder2.append(": ");
            builder2.append(typeElement.getText());
        }
        if (initializer != null) {
            builder2.append(" = ");
            builder2.append(initializer.getText());
        }
        builder2.append(JSCodeStyleSettings.getSemicolon(context2)).append("\n");
        String string = builder2.toString();
        if (string == null) {
            JSFunctionInliner.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    static Map<String, PsiNamedElement> collectNamesInScope(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(47);
        }
        SinkResolveProcessor<CompletionResultSink> processor = new SinkResolveProcessor<CompletionResultSink>(new CompletionResultSink(null, null));
        JSResolveUtil.treeWalkUp(processor, context2, null, context2);
        HashMap<String, PsiNamedElement> results = new HashMap<String, PsiNamedElement>();
        for (PsiElement element : ContainerUtil.notNullize(processor.getResults())) {
            if (!(element instanceof JSNamedElement)) continue;
            JSNamedElement namedElement = (JSNamedElement)element;
            results.putIfAbsent(namedElement.getName(), namedElement);
        }
        HashMap<String, PsiNamedElement> hashMap = results;
        if (hashMap == null) {
            JSFunctionInliner.$$$reportNull$$$0(48);
        }
        return hashMap;
    }

    @NotNull
    private static Set<String> getNonFinalParameters(@NotNull JSFunction function2) {
        JSParameter[] variables;
        if (function2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(49);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (JSParameter parameter : variables = function2.getParameterVariables()) {
            ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)function2)).forEach(reference -> {
                if (JSReadWriteAccessDetector.ourInstance.getReferenceAccess((PsiElement)parameter, (PsiReference)reference) != ReadWriteAccessDetector.Access.Read) {
                    String name = parameter.getName();
                    if (name != null) {
                        result2.add(name);
                    }
                    return false;
                }
                return true;
            });
        }
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            JSFunctionInliner.$$$reportNull$$$0(50);
        }
        return linkedHashSet;
    }

    private static boolean isNonLastStatementInBlock(@NotNull PsiElement elt) {
        PsiElement parent;
        if (elt == null) {
            JSFunctionInliner.$$$reportNull$$$0(51);
        }
        if ((parent = elt.getParent()) instanceof JSCallExpression) {
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof JSStatement)) {
                return true;
            }
            PsiElement grandGrandParent = grandParent.getParent();
            return !(grandGrandParent instanceof JSStatement) || !ControlFlowUtils.statementCompletesWithStatement((JSStatement)grandGrandParent, (JSStatement)grandParent);
        }
        return false;
    }

    private static boolean isRecursive(@NotNull JSFunction fun) {
        if (fun == null) {
            JSFunctionInliner.$$$reportNull$$$0(52);
        }
        return !PsiTreeUtil.processElements((PsiElement)fun, element -> !(element instanceof JSReferenceExpression) || JSResolveUtil.isSelfReference(fun) || ((JSReferenceExpression)element).resolve() != fun);
    }

    @NotNull
    private static List<JSReturnStatement> collectOwnReturns(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSFunctionInliner.$$$reportNull$$$0(53);
        }
        final ArrayList<JSReturnStatement> returnStatements = new ArrayList<JSReturnStatement>();
        function2.acceptChildren(new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

            @Override
            protected boolean skipLambdas() {
                return true;
            }

            @Override
            public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                returnStatements.add(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/refactoring/inline/JSFunctionInliner$2", "visitJSReturnStatement"));
            }
        });
        ArrayList<JSReturnStatement> arrayList = returnStatements;
        if (arrayList == null) {
            JSFunctionInliner.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    @Nullable
    static PsiElement performExpressionReplacement(@NotNull JSExpression source, @NotNull JSExpression replacement) {
        PsiElement parent;
        JSLiteralExpression literalExpression;
        JSExpression result2;
        if (source == null) {
            JSFunctionInliner.$$$reportNull$$$0(55);
        }
        if (replacement == null) {
            JSFunctionInliner.$$$reportNull$$$0(56);
        }
        if ((result2 = JSChangeUtil.replaceExpression(source, replacement = JSFunctionInliner.removeRedundantAwaitExpressions(replacement, source))) instanceof JSLiteralExpression && ES6RedundantNestingInTemplateLiteralInspection.canInline(literalExpression = (JSLiteralExpression)result2, parent = result2.getParent())) {
            return ES6RedundantNestingInTemplateLiteralInspection.inlineArgument(literalExpression, (JSStringTemplateExpression)parent);
        }
        return result2;
    }

    @NotNull
    private static JSExpression removeRedundantAwaitExpressions(@NotNull JSExpression toInsert, @NotNull JSExpression original) {
        PsiElement insertionParent;
        if (toInsert == null) {
            JSFunctionInliner.$$$reportNull$$$0(57);
        }
        if (original == null) {
            JSFunctionInliner.$$$reportNull$$$0(58);
        }
        if (ES6PsiUtil.isAwaitExpression(insertionParent = original.getParent())) {
            while (ES6PsiUtil.isAwaitExpression((PsiElement)toInsert)) {
                JSExpression inner = ((JSPrefixExpression)toInsert).getExpression();
                if (inner == null) {
                    JSExpression jSExpression = toInsert;
                    if (jSExpression == null) {
                        JSFunctionInliner.$$$reportNull$$$0(59);
                    }
                    return jSExpression;
                }
                toInsert = inner;
            }
        }
        JSExpression jSExpression = toInsert;
        if (jSExpression == null) {
            JSFunctionInliner.$$$reportNull$$$0(60);
        }
        return jSExpression;
    }

    private static /* synthetic */ boolean lambda$handleFunction$4(JSBlockStatement bodyBlock, JSReturnStatement statement) {
        return statement.getParent() != bodyBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 12, 13, 14, 15, 20, 34, 35, 38, 46, 48, 50, 54, 59, 60 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 34: 
            case 35: 
            case 38: 
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSFunctionInliner";
                break;
            }
            case 5: 
            case 7: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 11: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElementsToImport";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 17: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterListElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesInScope";
                break;
            }
            case 19: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToActualMap";
                break;
            }
            case 22: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsInCallScope";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedDeclaration";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToUpdate";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageContext";
                break;
            }
            case 36: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSFunctionInliner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doInlineUsage";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReplacementForCall";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUniqueNamesForDeclaration";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenericsSubstitutor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceExpressionsInfo";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarStatementText";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamesInScope";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonFinalParameters";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOwnReturns";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRedundantAwaitExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInlineUsage";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 34: 
            case 35: 
            case 38: 
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 59: 
            case 60: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldExpandTargetBody";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addStatementRangeWithComments";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeDefinition";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementForCall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryGetSingleExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ensureUniqueNamesForDeclaration";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacementFunction";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createGenericsSubstitutor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "handleFunction";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionsInfo";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "inlineFunctionProblem";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "tryMatchParametersToActual";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "tryMatchDestructuringPattern";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "tryMatchInitializerOwner";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getVarStatementText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "collectNamesInScope";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getNonFinalParameters";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isNonLastStatementInBlock";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "collectOwnReturns";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "performExpressionReplacement";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantAwaitExpressions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 12, 13, 14, 15, 20, 34, 35, 38, 46, 48, 50, 54, 59, 60 -> new IllegalStateException(string);
        };
    }
}

