/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.FunctionDeclarationType;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFunctionSignatureGenerator
extends JSFunctionSignatureGenerator {
    @Override
    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info2, StringBuilder result2, PsiElement context2) {
        if (info2.getScope() != JSFunctionSignatureInfo.Scope.CLASS) {
            super.appendFunctionNameWithModifiers(info2, result2, context2);
            if (info2.getTypeParameterList() != null) {
                result2.append(info2.getTypeParameterList());
            }
            return;
        }
        JSAttributeList.AccessType type2 = info2.getAccessType();
        if (type2 != JSAttributeList.AccessType.PUBLIC || context2 != null && !(context2 instanceof JSObjectLiteralExpression) && TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)context2).USE_PUBLIC_MODIFIER) {
            result2.append(JSVisibilityUtil.accessTypeToKeyword(type2, DialectOptionHolder.TS)).append(" ");
        }
        if (info2.isStatic()) {
            result2.append("static ");
        }
        if (info2.isAbstract()) {
            result2.append("abstract ");
        }
        if (info2.getDeclarationType() == FunctionDeclarationType.FUNCTION && info2.isAsync()) {
            result2.append("async ");
        }
        if (info2.isGetter()) {
            result2.append("get ");
        } else if (info2.isSetter()) {
            result2.append("set ");
        } else if (info2.isGenerator()) {
            result2.append("*");
        }
        result2.append(info2.getFunctionName());
        if (info2.getDeclarationType() == FunctionDeclarationType.ARROW_FUNCTION) {
            result2.append(" = ");
            if (info2.isAsync()) {
                result2.append("async ");
            }
        }
        if (info2.getTypeParameterList() != null) {
            result2.append(info2.getTypeParameterList());
        }
    }

    @Override
    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        if (Strings.areSameInstance((String)((String)parameterWithType.second), (String)"$varArgs$")) {
            String string = "... " + (String)parameterWithType.first;
            if (string == null) {
                TypeScriptFunctionSignatureGenerator.$$$reportNull$$$0(0);
            }
            return string;
        }
        String type2 = (String)parameterWithType.second;
        String string = (String)parameterWithType.first + (String)(!StringUtil.isEmpty((String)type2) ? ":" + type2 : "");
        if (string == null) {
            TypeScriptFunctionSignatureGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void appendFunctionEnding(JSFunctionSignatureInfo info2, StringBuilder result2) {
        if (StringUtil.isNotEmpty((String)info2.getReturnType())) {
            result2.append(": ");
            result2.append(info2.getReturnType());
        }
        super.appendFunctionEnding(info2, result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/TypeScriptFunctionSignatureGenerator", "getFunctionParameter"));
    }
}

