/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.FunctionDeclarationType;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionSignatureGenerator {
    public StringBuilder getSignature(@NotNull JSFunctionSignatureInfo info2, PsiElement context2) {
        if (info2 == null) {
            JSFunctionSignatureGenerator.$$$reportNull$$$0(0);
        }
        StringBuilder result2 = new StringBuilder();
        this.appendFunctionNameWithModifiers(info2, result2, context2);
        this.appendFunctionParameters(info2, result2);
        this.appendFunctionEnding(info2, result2);
        return result2;
    }

    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info2, StringBuilder result2, PsiElement context2) {
        FunctionDeclarationType declarationType = info2.getDeclarationType();
        if (declarationType == FunctionDeclarationType.ARROW_FUNCTION) {
            JSFunctionSignatureGenerator.appendFunctionExpression(context2, info2, result2);
        } else {
            if (info2.isStatic()) {
                result2.append("static ");
            }
            if (info2.isAsync()) {
                result2.append("async ");
            }
            if (info2.getScope() != JSFunctionSignatureInfo.Scope.CLASS && info2.getScope() != JSFunctionSignatureInfo.Scope.JS_OBJECT) {
                result2.append("function ");
            }
            if (info2.isGetter()) {
                result2.append("get ");
            } else if (info2.isSetter()) {
                result2.append("set ");
            }
            if (info2.isGenerator()) {
                result2.append("*");
            }
            result2.append(info2.getFunctionName());
        }
    }

    protected static void appendFunctionExpression(@Nullable PsiElement context2, JSFunctionSignatureInfo info2, StringBuilder result2) {
        boolean isClassScope;
        boolean isObjectScope = info2.getScope() == JSFunctionSignatureInfo.Scope.JS_OBJECT;
        boolean bl = isClassScope = info2.getScope() == JSFunctionSignatureInfo.Scope.CLASS;
        if (!isObjectScope && !isClassScope) {
            result2.append(JSChangeUtil.getConstantPrefix(context2));
            result2.append(" ");
        }
        if (info2.isStatic()) {
            result2.append("static ");
        }
        result2.append(info2.getFunctionName()).append(isObjectScope ? ":" : " = ");
        if (info2.isAsync()) {
            result2.append("async ");
        }
        if (info2.isGenerator()) {
            result2.append("*");
        }
    }

    protected void appendFunctionParameters(JSFunctionSignatureInfo info2, StringBuilder result2) {
        result2.append("(");
        result2.append(StringUtil.join(info2.getParameters(), couple -> this.getFunctionParameter((Couple<String>)couple), (String)","));
        result2.append(")");
    }

    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        String string = (String)parameterWithType.first;
        if (string == null) {
            JSFunctionSignatureGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void appendFunctionEnding(JSFunctionSignatureInfo info2, StringBuilder result2) {
        if (info2.getDeclarationType() == FunctionDeclarationType.ARROW_FUNCTION) {
            result2.append(" => ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

