/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoftlyCachedValue<T> {
    @NotNull
    private final SoftReference<Data<T>> myData;

    public SoftlyCachedValue(@NotNull T value, @NotNull ModificationTracker tracker) {
        if (value == null) {
            SoftlyCachedValue.$$$reportNull$$$0(0);
        }
        if (tracker == null) {
            SoftlyCachedValue.$$$reportNull$$$0(1);
        }
        Data<T> referenceData = new Data<T>(value, tracker);
        this.myData = new SoftReference<Data<Data<T>>>(referenceData);
    }

    @Nullable
    public T getUpToDateOrNull() {
        Data<T> data = this.myData.get();
        if (data == null) {
            return null;
        }
        T value = data.getUpToDateOrNull();
        if (value == null) {
            this.myData.clear();
        }
        return value;
    }

    @Nullable
    public static <T> T getOrComputeOnce(@NotNull UserDataHolder holder, @NotNull Key<SoftlyCachedValue<T>> key2, @NotNull Supplier<? extends SoftlyCachedValue<T>> provider) {
        T upToDateOrNull;
        if (holder == null) {
            SoftlyCachedValue.$$$reportNull$$$0(2);
        }
        if (key2 == null) {
            SoftlyCachedValue.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            SoftlyCachedValue.$$$reportNull$$$0(4);
        }
        SoftlyCachedValue<T> value = (SoftlyCachedValue<T>)holder.getUserData(key2);
        boolean computed = false;
        if (value == null) {
            value = provider.get();
            holder.putUserData(key2, value);
            computed = true;
        }
        if ((upToDateOrNull = value.getUpToDateOrNull()) == null && !computed) {
            value = provider.get();
            holder.putUserData(key2, value);
            upToDateOrNull = value.getUpToDateOrNull();
        }
        return upToDateOrNull;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/SoftlyCachedValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrComputeOnce";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class Data<T> {
        final T myValue;
        final ModificationTracker myModificationTracker;
        final long myInitialStamp;

        Data(@NotNull T value, @NotNull ModificationTracker modificationTracker) {
            if (value == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (modificationTracker == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myValue = value;
            this.myModificationTracker = modificationTracker;
            this.myInitialStamp = modificationTracker.getModificationCount();
        }

        @Nullable
        public T getUpToDateOrNull() {
            long currentStamp = this.myModificationTracker.getModificationCount();
            return currentStamp == -1L || currentStamp != this.myInitialStamp ? null : (T)this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modificationTracker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/util/SoftlyCachedValue$Data";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class FinalRef<T> {
        private static final FinalRef<?> NULL = new FinalRef<Object>(null);
        @Nullable
        private final T myValue;

        public FinalRef(@Nullable T value) {
            this.myValue = value;
        }

        @Nullable
        public T getValue() {
            return this.myValue;
        }

        @NotNull
        public static <T> FinalRef<T> nullRef() {
            FinalRef<?> finalRef = NULL;
            if (finalRef == null) {
                FinalRef.$$$reportNull$$$0(0);
            }
            return finalRef;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/SoftlyCachedValue$FinalRef", "nullRef"));
        }
    }
}

