/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/psi/util/JSPluginPathManager;", "", "()V", "getPluginResourceOrSource", "Ljava/io/File;", "pluginClass", "Ljava/lang/Class;", "resourceName", "", "relativePathFromPluginsDirectoryToResourceRoot", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSPluginPathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSPluginPathManager.kt\ncom/intellij/lang/javascript/psi/util/JSPluginPathManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,36:1\n23#2:37\n*S KotlinDebug\n*F\n+ 1 JSPluginPathManager.kt\ncom/intellij/lang/javascript/psi/util/JSPluginPathManager\n*L\n30#1:37\n*E\n"})
public final class JSPluginPathManager {
    @NotNull
    public static final JSPluginPathManager INSTANCE = new JSPluginPathManager();

    private JSPluginPathManager() {
    }

    @JvmStatic
    @NotNull
    public static final File getPluginResourceOrSource(@NotNull Class<?> pluginClass, @NotNull String resourceName, @Nullable String relativePathFromPluginsDirectoryToResourceRoot) throws IOException {
        Intrinsics.checkNotNullParameter(pluginClass, (String)"pluginClass");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        if (relativePathFromPluginsDirectoryToResourceRoot != null && (ApplicationKt.getApplication().isUnitTestMode() || PluginManagerCore.isRunningFromSources() || AppMode.isDevServer())) {
            File sourceFile = PluginPathManager.getPluginHome((String)(relativePathFromPluginsDirectoryToResourceRoot + "/" + resourceName));
            if (sourceFile.exists()) {
                Intrinsics.checkNotNull((Object)sourceFile);
                return sourceFile;
            }
            JSPluginPathManager $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JSPluginPathManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot find " + sourceFile);
        }
        File file = PluginPathManager.getPluginResource(pluginClass, (String)resourceName);
        if (file == null) {
            throw new IOException("Cannot find " + resourceName);
        }
        return file;
    }
}

