/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.JSImplicitPrototypeElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSSuperExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassHierarchyVisitor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSClassUtils {
    private static final Key<ParameterizedCachedValue<JSImplicitPrototypeElementImpl, JSClass>> PROTOTYPE_PROPERTY_KEY = Key.create((String)"js.prototype.prop");
    private static final ParameterizedCachedValueProvider<JSImplicitPrototypeElementImpl, JSClass> PROTOTYPE_PROPERTY_PROVIDER = clazz -> {
        JSImplicitPrototypeElementImpl argumentsVar = new JSImplicitPrototypeElementImpl((JSClass)clazz);
        return CachedValueProvider.Result.create((Object)argumentsVar, (Object[])new Object[]{clazz});
    };

    private JSClassUtils() {
    }

    public static boolean canHaveClasses(@NotNull PsiElement element) {
        DialectOptionHolder holder;
        if (element == null) {
            JSClassUtils.$$$reportNull$$$0(0);
        }
        return (holder = DialectDetector.dialectOfElement(element)) != null && holder.hasFeature(JSLanguageFeature.CLASSES);
    }

    public static boolean isES6ClassImplementation(@Nullable PsiElement context2) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context2);
        return JSClassUtils.isES6ClassImplementation(holder);
    }

    public static boolean isES6ClassImplementation(@Nullable DialectOptionHolder holder) {
        return holder != null && (holder.isECMA6 || holder.isTypeScript);
    }

    @NotNull
    public static String createClassFunctionName(@NotNull String name, @NotNull PsiElement context2) {
        DialectOptionHolder holder;
        if (name == null) {
            JSClassUtils.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSClassUtils.$$$reportNull$$$0(2);
        }
        if (JSClassUtils.isES6ClassImplementation(holder = DialectDetector.dialectOfElement(context2))) {
            String string = name;
            if (string == null) {
                JSClassUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = "function " + name;
        if (string == null) {
            JSClassUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String getDefaultFieldQualifier(@NotNull PsiElement context2, boolean withDot) {
        DialectOptionHolder holder;
        if (context2 == null) {
            JSClassUtils.$$$reportNull$$$0(5);
        }
        if ((holder = DialectDetector.dialectOfElement(context2)) != null && (holder.isTypeScript || holder.isECMA6)) {
            return "this" + (withDot ? "." : "");
        }
        return null;
    }

    @Nullable
    public static String getAnyTypeString(@NotNull PsiElement context2, boolean strict) {
        DialectOptionHolder holder;
        if (context2 == null) {
            JSClassUtils.$$$reportNull$$$0(6);
        }
        if ((holder = DialectDetector.dialectOfElement(context2)) != null && holder.isECMA4) {
            return "*";
        }
        if (holder != null && holder.isTypeScript && strict) {
            return "any";
        }
        return null;
    }

    public static String createConstructorSignatureForClass(JSClass jsClass, boolean isPublic) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(jsClass);
        assert (holder != null);
        if (holder.isECMA4) {
            return (isPublic ? "public " : "") + "function " + jsClass.getName();
        }
        return "constructor";
    }

    public static boolean isAllowImplementation(@NotNull JSClass jsClass, @Nullable PsiElement context2) {
        if (jsClass == null) {
            JSClassUtils.$$$reportNull$$$0(7);
        }
        return jsClass.isInterface() || context2 != null && DialectDetector.isTypeScript(context2);
    }

    @Contract(value="null -> false")
    public static boolean isPossibleHierarchyMember(@Nullable PsiElement element) {
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isConstructor()) {
            return false;
        }
        return element instanceof JSFunction || element instanceof JSField && JSClassUtils.isES6ClassImplementation(element) || element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element) && JSInheritanceUtil.canBeSuperMember(((JSAttributeListOwner)element).getAttributeList());
    }

    public static boolean processClassesInHierarchy(@NotNull JSClass clazz, boolean includeInterfaces, @NotNull TypeScriptUtil.JSClassHierarchyProcessor processor) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(9);
        }
        return JSClassUtils.processClassesInHierarchyImpl(clazz, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, (Condition<? super JSClass>)Conditions.alwaysTrue(), 30);
    }

    public static boolean processClassesInHierarchy(@NotNull JSClass clazz, boolean includeInterfaces, @NotNull JSClassHierarchyProcessor processor) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(11);
        }
        return JSClassUtils.processClassesInHierarchyImpl(clazz, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, (Condition<? super JSClass>)Conditions.alwaysTrue(), 30);
    }

    public static boolean processClassesInHierarchy(@NotNull JSClass clazz, boolean includeInterfaces, @NotNull JSClassHierarchyProcessor processor, @NotNull Condition<? super JSClass> superClassAcceptor, @NotNull JSTypeSubstitutor substitutor) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(13);
        }
        if (superClassAcceptor == null) {
            JSClassUtils.$$$reportNull$$$0(14);
        }
        if (substitutor == null) {
            JSClassUtils.$$$reportNull$$$0(15);
        }
        return JSClassUtils.processClassesInHierarchyImpl(clazz, includeInterfaces, processor, substitutor, superClassAcceptor, 30);
    }

    public static boolean processClassesInHierarchy(@NotNull JSClass clazz, boolean includeInterfaces, @NotNull JSClassHierarchyProcessor processor, @NotNull Condition<? super JSClass> superClassAcceptor, @NotNull JSTypeSubstitutor substitutor, int depthLimit) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(17);
        }
        if (superClassAcceptor == null) {
            JSClassUtils.$$$reportNull$$$0(18);
        }
        if (substitutor == null) {
            JSClassUtils.$$$reportNull$$$0(19);
        }
        return JSClassUtils.processClassesInHierarchyImpl(clazz, includeInterfaces, processor, substitutor, superClassAcceptor, depthLimit);
    }

    private static boolean processClassesInHierarchyImpl(@NotNull JSClass clazz, boolean includeInterfaces, @NotNull JSClassHierarchyProcessor processor, @NotNull JSTypeSubstitutor typeSubstitutor, @NotNull Condition<? super JSClass> superClassAcceptor, int depthLimit) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(21);
        }
        if (typeSubstitutor == null) {
            JSClassUtils.$$$reportNull$$$0(22);
        }
        if (superClassAcceptor == null) {
            JSClassUtils.$$$reportNull$$$0(23);
        }
        return JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)clazz, () -> new JSClassHierarchyVisitor(includeInterfaces, processor, superClassAcceptor, depthLimit).visit(clazz, typeSubstitutor));
    }

    @NotNull
    public static JSTypeSubstitutor combineSuperClassSubstitutor(@NotNull JSTypeSubstitutor typeSubstitutor, @NotNull JSTypeSubstitutor superSubstitutor) {
        if (typeSubstitutor == null) {
            JSClassUtils.$$$reportNull$$$0(24);
        }
        if (superSubstitutor == null) {
            JSClassUtils.$$$reportNull$$$0(25);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.combineWithApplying(typeSubstitutor, superSubstitutor, JSTypeUtils::applyGenericArguments);
        if (jSTypeSubstitutor == null) {
            JSClassUtils.$$$reportNull$$$0(26);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> buildTypeArguments(@NotNull JSReferenceListMember referenceListMember) {
        if (referenceListMember == null) {
            JSClassUtils.$$$reportNull$$$0(27);
        }
        JSTypeDeclaration[] typeArgumentDeclarations = referenceListMember.getTypeArguments();
        ArrayList<JSType> typeArguments = new ArrayList<JSType>(typeArgumentDeclarations.length);
        for (JSTypeDeclaration typeArgumentDeclaration : typeArgumentDeclarations) {
            typeArguments.add(typeArgumentDeclaration.getJSType());
        }
        ArrayList<JSType> arrayList = typeArguments;
        if (arrayList == null) {
            JSClassUtils.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    public static ResolveResult @NotNull [] resolveES6Constructor(@NotNull JSClass clazz, @NotNull JSExpression methodExpression) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(29);
        }
        if (methodExpression == null) {
            JSClassUtils.$$$reportNull$$$0(30);
        }
        TypeScriptResolveProcessor processor = new TypeScriptResolveProcessor("constructor", methodExpression.getContainingFile(), methodExpression);
        JSCallLikeExpression callExpression = TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)methodExpression);
        JSTypeSignatureChooser resolver = callExpression instanceof JSCallExpression ? new JSTypeSignatureChooser(callExpression) : null;
        HashSet<JSClass> visitedClasses = new HashSet<JSClass>();
        ArrayDeque<JSClass> classQueue = new ArrayDeque<JSClass>();
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            PsiElement element;
            ResolveResult[] results;
            JSClass currentClass = (JSClass)classQueue.poll();
            if (!visitedClasses.add(currentClass)) continue;
            JSResolveUtil.processDeclarationsInScope(currentClass, processor, ResolveState.initial(), null, (PsiElement)methodExpression);
            ResolveResult[] candidates = processor.getResultsAsResolveResults();
            ResolveResult[] resolveResultArray = results = resolver == null ? candidates : resolver.chooseOverload(candidates);
            if (results.length >= 1) {
                if (results == null) {
                    JSClassUtils.$$$reportNull$$$0(31);
                }
                return results;
            }
            if (callExpression instanceof JSNewExpression && (element = JSSuperExpressionImpl.matchSuperConstructor((JSNewExpression)callExpression, currentClass)) != null) {
                PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[]{new PsiElementResolveResult(element, true)};
                if (psiElementResolveResultArray == null) {
                    JSClassUtils.$$$reportNull$$$0(32);
                }
                return psiElementResolveResultArray;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        if (callExpression instanceof JSNewExpression && resolver.argumentsCount() == 0) {
            PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[]{new PsiElementResolveResult((PsiElement)clazz, true)};
            if (psiElementResolveResultArray == null) {
                JSClassUtils.$$$reportNull$$$0(33);
            }
            return psiElementResolveResultArray;
        }
        JSQualifiedNamedElement resolveResult = clazz;
        if (clazz instanceof TypeScriptClass) {
            TypeScriptFunction[] constructors = ((TypeScriptClass)clazz).getConstructors();
            if (constructors.length == 1) {
                resolveResult = constructors[0];
            }
        } else {
            JSFunction candidate = clazz.getConstructor();
            if (candidate != null) {
                resolveResult = candidate;
            }
        }
        PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[]{new PsiElementResolveResult((PsiElement)resolveResult, false)};
        if (psiElementResolveResultArray == null) {
            JSClassUtils.$$$reportNull$$$0(34);
        }
        return psiElementResolveResultArray;
    }

    @Contract(value="null->false")
    public static boolean isStaticMethodOrField(@Nullable PsiElement element) {
        JSClass clazz = JSUtils.getMemberContainingClass(element);
        if (clazz == null || clazz.isInterface()) {
            return false;
        }
        return JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.STATIC);
    }

    public static JSImplicitPrototypeElement getImplicitPrototypeProperty(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(35);
        }
        return (JSImplicitPrototypeElement)CachedValuesManager.getManager((Project)clazz.getProject()).getParameterizedCachedValue((UserDataHolder)clazz, PROTOTYPE_PROPERTY_KEY, PROTOTYPE_PROPERTY_PROVIDER, false, (Object)clazz);
    }

    public static boolean canHavePrototypeProperty(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(36);
        }
        return !clazz.isInterface() && !(clazz instanceof TypeScriptEnum);
    }

    public static boolean isClassMember(@NotNull PsiElement element) {
        if (element == null) {
            JSClassUtils.$$$reportNull$$$0(37);
        }
        return JSUtils.isMember(element);
    }

    public static boolean hasPrivateMembers(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            JSClassUtils.$$$reportNull$$$0(38);
        }
        return ContainerUtil.exists(jsClass.getMembers(), member -> member instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)member).isPrivateName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 26, 28, 31, 32, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSClassUtils";
                break;
            }
            case 7: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 29: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassAcceptor";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceListMember";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSClassUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassFunctionName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "combineSuperClassSubstitutor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeArguments";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveES6Constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canHaveClasses";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClassFunctionName";
                break;
            }
            case 3: 
            case 4: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFieldQualifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnyTypeString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAllowImplementation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processClassesInHierarchy";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processClassesInHierarchyImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "combineSuperClassSubstitutor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeArguments";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveES6Constructor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitPrototypeProperty";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "canHavePrototypeProperty";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isClassMember";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasPrivateMembers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 26, 28, 31, 32, 33, 34 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface JSClassHierarchyProcessor {
        public boolean process(@NotNull JSClass var1, @NotNull JSTypeSubstitutor var2, boolean var3, boolean var4, int var5);
    }
}

