/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSNarrowTypeByTypePredicateOperation
extends JSConditionalTypeOperationBase {
    public static final int THIS_ARGUMENT = -1;
    @NotNull
    private final IntSet myPredicateCandidateArguments;
    @NotNull
    private final IntSet myMatchedNonRefs;
    private final Map<Integer, JSTypeOperation> myOperations;
    private final boolean myAssertionOnly;
    @NotNull
    private final JSType myExpressionType;

    public JSNarrowTypeByTypePredicateOperation(@NotNull JSTypeOperation prev, @NotNull JSType expressionType, @NotNull IntSet arguments, @NotNull IntSet matchedNonRefs, boolean assumeTrue, @NotNull Map<Integer, JSTypeOperation> operations, boolean assertionOnly) {
        if (prev == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(0);
        }
        if (expressionType == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(2);
        }
        if (matchedNonRefs == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(3);
        }
        if (operations == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(4);
        }
        super(prev, assumeTrue);
        this.myExpressionType = expressionType;
        this.myPredicateCandidateArguments = arguments;
        this.myMatchedNonRefs = matchedNonRefs;
        this.myOperations = operations;
        this.myAssertionOnly = assertionOnly;
    }

    private boolean isAcceptableTypeForPredicate(@NotNull JSType type2) {
        if (type2 == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(5);
        }
        if (this.myPredicateCandidateArguments.size() == 1 && this.myPredicateCandidateArguments.contains(-1)) {
            return TypeScriptTypeRelations.isTypeOrUnionOf(type2, JSTypeImpl.class) || TypeScriptTypeRelations.isTypeOrUnionOf(type2, JSClassExpressionType.class);
        }
        return true;
    }

    @Override
    @NotNull
    protected JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type2) {
        JSType guardType;
        if (context2 == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(6);
        }
        if (type2 == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(7);
        }
        if (!this.isAcceptableTypeForPredicate(type2)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSType expressionJSType = context2.expandOperationType(this.myExpressionType);
        if (!(expressionJSType instanceof TypeScriptTypePredicateTypeImpl)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        TypeScriptTypePredicateTypeImpl typePredicate = (TypeScriptTypePredicateTypeImpl)expressionJSType;
        if (typePredicate.isAssertion() && !this.myAssumeTrue) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        if (!typePredicate.isAssertion() && this.myAssertionOnly) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        if (typePredicate.isThisParameter()) {
            if (!this.myPredicateCandidateArguments.contains(-1)) {
                JSType jSType = type2;
                if (jSType == null) {
                    JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(12);
                }
                return jSType;
            }
        } else {
            int index = typePredicate.getParameterIndex();
            if (index < 0) {
                JSType jSType = type2;
                if (jSType == null) {
                    JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(13);
                }
                return jSType;
            }
            if (!this.myPredicateCandidateArguments.contains(index)) {
                return this.getAssertionNarrowedType(context2, type2, typePredicate, index);
            }
        }
        if ((guardType = JSTypeGuardChecker.getExactType(typePredicate.getGuardType())) == null) {
            JSType jSType = typePredicate.isAssertion() ? JSTypeUtils.removeNullableComponents(type2) : type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        JSType unwrappedType = JSTypeUtils.unwrapType(type2);
        if (JSTypeGuardUtil.isSourceTypeAnyAndTargetTypeFunctionOrObject(unwrappedType, guardType)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        if (unwrappedType instanceof JSAnyType && !(unwrappedType instanceof JSUnknownType)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        JSType narrowedType = context2.getNarrowedType(type2, guardType, this.myAssumeTrue, (el1, el2) -> TypeScriptTypeRelations.isTypeSubtypeOf(el1, el2, context2.getSubtypingProcessingContext()));
        JSType jSType = context2.processNeverType(type2, narrowedType);
        if (jSType == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    @NotNull
    private JSType getAssertionNarrowedType(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type2, @NotNull TypeScriptTypePredicateTypeImpl typePredicate, int index) {
        if (context2 == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(18);
        }
        if (type2 == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(19);
        }
        if (typePredicate == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(20);
        }
        if (!typePredicate.isAssertion() || typePredicate.getGuardType() != null || !this.myMatchedNonRefs.contains(index)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(21);
            }
            return jSType;
        }
        JSTypeOperation operation = this.myOperations.get(index);
        JSType jSType = operation == null ? type2 : operation.apply(context2, type2);
        if (jSType == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @Override
    protected boolean checkOwnEquality(@NotNull JSTypeOperation sameTypeOperation) {
        if (sameTypeOperation == null) {
            JSNarrowTypeByTypePredicateOperation.$$$reportNull$$$0(23);
        }
        JSNarrowTypeByTypePredicateOperation operation = (JSNarrowTypeByTypePredicateOperation)sameTypeOperation;
        return this.myAssertionOnly == operation.myAssertionOnly && this.myPredicateCandidateArguments.equals(operation.myPredicateCandidateArguments) && this.myMatchedNonRefs.equals(operation.myMatchedNonRefs) && this.myExpressionType.equals(operation.myExpressionType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNonRefs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 5: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByTypePredicateOperation";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePredicate";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameTypeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByTypePredicateOperation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssertionNarrowedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableTypeForPredicate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAssertionNarrowedType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkOwnEquality";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 21, 22 -> new IllegalStateException(string);
        };
    }
}

