/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.IndexedData;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeIndexerKt;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptStringMappingTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTemplateLiteralJSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumLiteralType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.typescript.resolve.TypeScriptTypeHelper;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypeRelations {
    public static final int MAX_UNION_SIZE = 100000;
    private static final JSType.LocalTypeKey ENUM_VALUES_UNION_TYPE_KEY = JSType.createLocalTypeKey("enum.values.union.type");

    public static boolean isTypeDerivedFrom(@Nullable JSType source, @Nullable JSType target, @NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(0);
        }
        if (source instanceof JSUnionType) {
            return ContainerUtil.and(((JSUnionType)source).getTypes(), el -> TypeScriptTypeRelations.isTypeDerivedFrom(el, target, context2));
        }
        if (target instanceof JSUnionType) {
            return ContainerUtil.or(((JSUnionType)target).getTypes(), el -> TypeScriptTypeRelations.isTypeDerivedFrom(source, el, context2));
        }
        if (source != null && TypeScriptTypeRelations.isInstantiableNonPrimitive(source)) {
            return TypeScriptTypeRelations.isTypeDerivedFrom(TypeScriptTypeRelations.getBaseConstraintOfType(source, context2), target, context2);
        }
        if (source != null) {
            return TypeScriptTypeRelations.hasBaseType(source, target);
        }
        return false;
    }

    @Contract(value="!null, _ -> !null")
    public static JSType subtypeReduction(@Nullable JSType type2, @NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(1);
        }
        if (!(type2 instanceof JSUnionType)) {
            return type2;
        }
        List<JSType> types2 = ((JSUnionType)type2).getTypes();
        if (TypeScriptTypeRelations.isSubsetOfOneEnumLiteral(types2)) {
            return type2;
        }
        ArrayList<JSType> result2 = new ArrayList<JSType>(types2);
        if (!TypeScriptTypeRelations.reduceBySubtyping(context2, types2, result2)) {
            return TypeScriptTypeRelations.getUnionType(result2, type2.getSource());
        }
        return result2.size() == types2.size() ? type2 : TypeScriptTypeRelations.getUnionType(result2, type2.getSource());
    }

    public static boolean reduceBySubtyping(@NotNull PsiElement context2, List<JSType> types2, List<JSType> result2) {
        if (context2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(2);
        }
        ProcessingContext subtypingProcessingContext = JSTypeComparingContextService.createSubtypingProcessingContext(context2);
        int count = 0;
        HashSet<JSType> removed = new HashSet<JSType>();
        block0: for (int i = types2.size() - 1; i >= 0; --i) {
            JSType source = types2.get(i);
            for (JSType target : types2) {
                if (source == target || removed.contains(target)) continue;
                if (count == 100000 && types2.size() > 1000000) {
                    return false;
                }
                ++count;
                if (!TypeScriptTypeRelations.isTypeSubtypeOf(source, target, subtypingProcessingContext) || TypeScriptTypeRelations.isClassType(source) && TypeScriptTypeRelations.isClassType(target) && !TypeScriptTypeRelations.isTypeDerivedFrom(source, target, context2)) continue;
                result2.remove(i);
                removed.add(source);
                continue block0;
            }
        }
        return true;
    }

    private static boolean isClassType(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(3);
        }
        if (!(type2 instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info2 = ((JSResolvableType)type2).resolveType();
        Collection<JSClass> classes = info2.getDeclarationsOfType(JSClass.class);
        return !classes.isEmpty() && classes.stream().anyMatch(el -> !el.isInterface());
    }

    private static boolean isSubsetOfOneEnumLiteral(@NotNull List<JSType> types2) {
        JSResolvedTypeInfo info2;
        JSType first;
        if (types2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(4);
        }
        if ((first = types2.get(0)) instanceof JSResolvableType && (info2 = ((JSResolvableType)first).resolveType()).isEnumLiteral()) {
            JSType type2 = TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)first);
            for (int i = 1; i < types2.size(); ++i) {
                JSType next = types2.get(0);
                if (!(next instanceof JSResolvableType)) {
                    return false;
                }
                JSResolvedTypeInfo resolved = ((JSResolvableType)next).resolveType();
                if (!resolved.isEnumLiteral()) {
                    return false;
                }
                JSType nextEnum = TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)next);
                if (type2.isEquivalentTo(nextEnum, null, true)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasBaseType(@NotNull JSType type2, @Nullable JSType checkBase) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(5);
        }
        JSType sourceType = TypeScriptTypeRelations.unwrapGenericType(type2);
        JSType baseType = TypeScriptTypeRelations.unwrapGenericType(checkBase);
        if (baseType instanceof JSNamedType && sourceType instanceof JSNamedType) {
            return TypeScriptTypeHelper.areNamedTypesClassAssignable((JSNamedType)baseType, (JSNamedType)sourceType).isAssignable();
        }
        if (baseType instanceof JSIntersectionType) {
            return ContainerUtil.or(((JSIntersectionType)baseType).getTypes(), el -> TypeScriptTypeRelations.hasBaseType(sourceType, el));
        }
        return false;
    }

    @Nullable
    private static JSType unwrapGenericType(@Nullable JSType type2) {
        return type2 instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)type2).getType() : type2;
    }

    public static boolean isTypeSubtypeOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(6);
        }
        if (source == null || target == null) {
            return false;
        }
        assert (processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null);
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, processingContext);
    }

    public static boolean areTypesComparable(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext context2) {
        return TypeScriptTypeRelations.isTypeComparableTo(type1, type2, context2) || TypeScriptTypeRelations.isTypeComparableTo(type2, type1, context2);
    }

    public static boolean isCoercibleUnderDoubleEquals(@Nullable JSType source, @Nullable JSType target) {
        if (source == null || target == null) {
            return false;
        }
        return TypeScriptTypeRelations.isCoercibleSource(source) && TypeScriptTypeRelations.isCoercibleTarget(target);
    }

    private static boolean isCoercibleSource(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(7);
        }
        return !(type2 instanceof JSStringLiteralTypeImpl) && !(type2 instanceof JSNumberLiteralTypeImpl) && (type2 instanceof JSStringType || type2 instanceof JSNumberType || type2 instanceof JSBooleanType);
    }

    private static boolean isCoercibleTarget(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(8);
        }
        if (TypeScriptTypeRelations.isBooleanUnionType(type2)) {
            return true;
        }
        return !(type2 instanceof JSPrimitiveLiteralType) && (type2 instanceof JSStringType || type2 instanceof JSNumberType || type2 instanceof JSBooleanType);
    }

    public static boolean isTypeComparableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context2) {
        block3: {
            block2: {
                if (!(source instanceof JSUnionType)) break block2;
                for (JSType sourceSubType : ((JSUnionType)source).getTypes()) {
                    if (!TypeScriptTypeRelations.isTypeComparableTo(sourceSubType, target, context2)) continue;
                    return true;
                }
                break block3;
            }
            if (!(target instanceof JSUnionType)) break block3;
            for (JSType targetSubType : ((JSUnionType)target).getTypes()) {
                if (!TypeScriptTypeRelations.isTypeRelatedTo(source, targetSubType, context2)) continue;
                return true;
            }
        }
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, context2);
    }

    @NotNull
    public static JSType mapType(@NotNull JSType type2, Function<? super JSType, ? extends JSType> function2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(9);
        }
        if (type2 instanceof TypeScriptNeverType) {
            JSType jSType = type2;
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        if (!(type2 instanceof JSUnionType)) {
            JSType jSType = (JSType)function2.fun((Object)type2);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        JSType jSType = ((JSUnionType)type2).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)arg_0 -> function2.fun(arg_0)));
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    public static boolean isTypeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context2) {
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, context2);
    }

    public static JSType getCanonicalType(@Nullable JSType type2) {
        if (type2 instanceof JSDecoratedType) {
            type2 = ((JSDecoratedType)type2).getOriginalType();
        }
        return TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(type2);
    }

    @Contract(value="!null->!null")
    public static JSType getCanonicalTypeForExoticLiterals(@Nullable JSType type2) {
        if (type2 instanceof JSExoticStringLiteralType) {
            return ((JSExoticStringLiteralType)type2).asSimpleLiteralType();
        }
        return type2;
    }

    public static boolean isTypeRelatedTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context2) {
        return target != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(target).isDirectlyAssignableType(TypeScriptTypeRelations.getRegularTypeOfLiteralType(source), context2);
    }

    public static boolean typeMaybeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context2) {
        if (source instanceof JSUnionType) {
            return ((JSUnionType)source).getTypes().stream().anyMatch(el -> TypeScriptTypeRelations.typeMaybeAssignableTo(el, target, context2));
        }
        return TypeScriptTypeRelations.isTypeAssignableTo(source, target, context2);
    }

    @Deprecated(forRemoval=true)
    @Contract(value="!null -> !null; null -> null")
    public static JSType expandAndOptimizeTypeRecursive(@Nullable JSType type2) {
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, null);
    }

    @Contract(value="null -> null")
    public static JSType expandAndOptimizeExpressionTypeRecursive(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType(expression), (PsiElement)expression);
    }

    @Contract(value="null -> null")
    public static JSType expandAndOptimizeElementTypeRecursive(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getElementJSType(element), element);
    }

    @Contract(value="!null,_ -> !null; null, _ -> null")
    public static JSType expandAndOptimizeTypeRecursive(@Nullable JSType type2, @Nullable PsiElement place) {
        if (type2 == null) {
            return null;
        }
        return type2.substitute(place);
    }

    public static boolean isInstantiableNonPrimitive(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(13);
        }
        return type2 instanceof TypeScriptMappedJSTypeImpl || type2 instanceof JSGenericParameterImpl || type2 instanceof TypeScriptConditionalTypeJSTypeImpl || type2 instanceof TypeScriptIndexedAccessJSTypeImpl;
    }

    public static boolean isInstantiablePrimitive(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(14);
        }
        return type2 instanceof JSKeyofType || type2 instanceof JSTemplateLiteralType || type2 instanceof TypeScriptStringMappingTypeImpl;
    }

    public static boolean isGenericIndexType(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(15);
        }
        if (type2 instanceof JSUnionOrIntersectionType) {
            return ContainerUtil.exists(((JSUnionOrIntersectionType)type2).getTypes(), TypeScriptTypeRelations::isGenericIndexType);
        }
        return (TypeScriptTypeRelations.isInstantiableNonPrimitive(type2) || TypeScriptTypeRelations.isInstantiablePrimitive(type2)) && !TypeScriptTypeRelations.isPatternLiteralType(type2);
    }

    public static boolean isInstantiable(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(16);
        }
        return TypeScriptTypeRelations.isInstantiableNonPrimitive(type2) || TypeScriptTypeRelations.isInstantiablePrimitive(type2);
    }

    @NotNull
    public static JSType expandUnionOrIntersectionType(@NotNull JSType originalType, @NotNull JSTypeSubstitutionContext context2) {
        List filtered;
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(18);
        }
        List<JSType> types2 = ((JSUnionOrIntersectionType)originalType).getTypes();
        List expandedTypes = ContainerUtil.map(types2, sub -> {
            JSType type2 = context2.substituteNested((JSType)sub);
            return type2 == null ? JSAnyType.get(originalType.getSource()) : type2;
        });
        if (originalType instanceof JSUnionType && originalType.isTypeScript() && !JSTypeCastUtil.strictNullChecks(context2, originalType.getSourceElement()) && !(filtered = ContainerUtil.filter((Collection)expandedTypes, type2 -> !(type2 instanceof JSNullType) && !(type2 instanceof JSUndefinedType))).isEmpty()) {
            expandedTypes = filtered;
        }
        if (ContainerUtil.equalsIdentity(types2, (List)expandedTypes)) {
            JSType jSType = originalType;
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        return TypeScriptTypeRelations.createTypeBy(originalType, expandedTypes);
    }

    @Nullable
    public static JSType getBaseConstraintOfType(@Nullable JSType type2, @Nullable PsiElement context2) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof JSGenericParameterImpl) {
            return ((JSGenericParameterImpl)type2).getConstraintType();
        }
        if (type2 instanceof JSKeyofType) {
            return TypeScriptTypeRelations.getKeyOfConstraintType(context2);
        }
        if (type2 instanceof JSTemplateLiteralType) {
            return TypeScriptTypeRelations.getTemplateLiteralConstraintType((JSTemplateLiteralType)type2);
        }
        if (type2 instanceof TypeScriptStringMappingTypeImpl) {
            return TypeScriptTypeRelations.getStringMappingConstraintType((TypeScriptStringMappingTypeImpl)type2);
        }
        return null;
    }

    @NotNull
    private static JSType getStringMappingConstraintType(@NotNull TypeScriptStringMappingTypeImpl type2) {
        JSType constraintOfType;
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(20);
        }
        if ((constraintOfType = TypeScriptTypeRelations.getBaseConstraintOfType(type2.getType(), type2.getSourceElement())) == null || constraintOfType == type2.getType()) {
            JSStringType jSStringType = JSNamedTypeFactory.createStringPrimitiveType(type2.getSource());
            if (jSStringType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(21);
            }
            return jSStringType;
        }
        JSType jSType = TypeScriptStringMappingTypeImpl.createType(type2.getKind(), constraintOfType, type2.getSource());
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @NotNull
    public static JSType getKeyOfConstraintType(@Nullable PsiElement context2) {
        TypeScriptConfig config;
        JSTypeSource source = context2 == null ? JSTypeSource.EMPTY_TS : JSTypeSourceFactory.createTypeSource(context2, true);
        TypeScriptConfig typeScriptConfig = config = context2 == null ? null : TypeScriptConfigUtil.getConfigForPsiFile(context2.getContainingFile());
        if (config != null && config.keyofStringsOnly()) {
            JSType jSType = JSNamedTypeFactory.createType("string", source, JSContext.INSTANCE);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(23);
            }
            return jSType;
        }
        List<JSType> types2 = TypeScriptTypeRelations.getDefaultKeyOfTypes(source);
        JSType jSType = JSCompositeTypeFactory.createUnionType(source, types2);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @NotNull
    public static JSType getTemplateLiteralConstraintType(@NotNull JSTemplateLiteralType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(25);
        }
        if (type2.getTypes().isEmpty()) {
            JSTemplateLiteralType jSTemplateLiteralType = type2;
            if (jSTemplateLiteralType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(26);
            }
            return jSTemplateLiteralType;
        }
        ArrayList<JSType> newTypes2 = new ArrayList<JSType>(type2.getTypes().size());
        for (JSType childType : type2.getTypes()) {
            JSType constraint = TypeScriptTypeRelations.getBaseConstraintOfType(childType, type2.getSourceElement());
            if (constraint == null) {
                JSStringType jSStringType = JSNamedTypeFactory.createStringPrimitiveType(type2.getSource());
                if (jSStringType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(27);
                }
                return jSStringType;
            }
            newTypes2.add(constraint);
        }
        JSType jSType = TypeScriptTemplateLiteralJSTypeImpl.createType(type2.getTexts(), newTypes2, type2.allowWidening(), type2.getSource()).substitute();
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @NotNull
    public static List<JSType> getDefaultKeyOfTypes(JSTypeSource source) {
        List list2 = ContainerUtil.map((Object[])JSCommonTypeNames.KEYOF_TYPES, typeName -> JSNamedTypeFactory.createType(typeName, source, JSContext.INSTANCE));
        if (list2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(29);
        }
        return list2;
    }

    @NotNull
    private static JSType createTypeBy(@NotNull JSType originalType, @NotNull List<JSType> expandedTypes) {
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(30);
        }
        if (expandedTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(31);
        }
        if (originalType instanceof JSContextualUnionType) {
            JSType jSType = JSCompositeTypeFactory.createContextualUnionType(expandedTypes, originalType.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(32);
            }
            return jSType;
        }
        if (originalType instanceof JSUnionType) {
            JSType jSType = JSCompositeTypeFactory.createUnionType(originalType.getSource(), expandedTypes);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(33);
            }
            return jSType;
        }
        if (originalType instanceof JSIntersectionType) {
            JSType jSType = JSCompositeTypeFactory.createIntersectionType(expandedTypes, originalType.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(34);
            }
            return jSType;
        }
        JSType jSType = originalType;
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @NotNull
    public static JSType filterType(@Nullable JSType type2, @NotNull Predicate<? super JSType> filter, @NotNull PsiElement context2) {
        if (filter == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(36);
        }
        if (context2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(37);
        }
        if (type2 == null) {
            TypeScriptNeverType typeScriptNeverType = JSNamedTypeFactory.createNeverType(JSTypeSourceFactory.createTypeSource(context2, true));
            if (typeScriptNeverType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(38);
            }
            return typeScriptNeverType;
        }
        if (type2 instanceof JSDecoratedType) {
            JSDecoratedType decorated = (JSDecoratedType)type2;
            JSType original = decorated.getOriginalType();
            JSType filtered = TypeScriptTypeRelations.filterType(original, filter, context2);
            if (filtered instanceof TypeScriptNeverType) {
                JSType jSType = filtered;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(39);
                }
                return jSType;
            }
            if (filtered == original) {
                JSType jSType = type2;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(40);
                }
                return jSType;
            }
            return new JSDecoratedTypeImpl(type2.getSource(), filtered, decorated.getDecorations());
        }
        if (type2 instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)type2).getTypes();
            List resultTypes = ContainerUtil.filter(types2, el -> filter.test((JSType)el));
            if (types2.size() == resultTypes.size()) {
                JSType jSType = type2;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(41);
                }
                return jSType;
            }
            return TypeScriptTypeRelations.getUnionType(resultTypes, type2.getSource());
        }
        JSType jSType = filter.test(type2) ? type2 : JSNamedTypeFactory.createNeverType(type2.getSource());
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    public static boolean isBooleanUnionType(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(43);
        }
        if (!(type2 instanceof JSUnionType)) {
            return false;
        }
        List<JSType> types2 = ((JSUnionType)type2).getTypes();
        if (types2.size() != 2) {
            return false;
        }
        JSType type1 = types2.get(0);
        JSType type22 = types2.get(1);
        if (!(type1 instanceof JSBooleanLiteralTypeImpl) || !(type22 instanceof JSBooleanLiteralTypeImpl)) {
            return false;
        }
        return ((JSBooleanLiteralTypeImpl)type1).getLiteral() != ((JSBooleanLiteralTypeImpl)type22).getLiteral();
    }

    @Contract(value="!null -> !null")
    public static JSType getAsUnionIfBooleanOrEnum(@Nullable JSType type2) {
        if (!((type2 = TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(type2)) instanceof JSBooleanType) || !((JSBooleanType)type2).isPrimitive() || type2 instanceof JSBooleanLiteralTypeImpl) {
            return type2;
        }
        JSTypeSource source = type2.getSource();
        JSBooleanLiteralTypeImpl trueType = new JSBooleanLiteralTypeImpl(true, true, source);
        JSBooleanLiteralTypeImpl falseType = new JSBooleanLiteralTypeImpl(false, true, source);
        return JSCompositeTypeFactory.createUnionType(source, trueType, falseType);
    }

    @Contract(value="!null -> !null")
    public static JSType getAsUnionTypeIfEnumWithLiterals(@Nullable JSType type2) {
        if (!(type2 instanceof JSResolvableType) || !type2.isTypeScript()) {
            return type2;
        }
        JSResolvedTypeInfo info2 = ((JSResolvableType)type2).resolveType();
        if (info2.isEnumWithLiteralValues()) {
            return type2.getResolveCachedType(() -> {
                JSType result2 = TypeScriptTypeRelations.createEnumValuesUnionType(type2, info2);
                return result2 == null ? type2 : result2;
            }, ENUM_VALUES_UNION_TYPE_KEY);
        }
        return type2;
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<? extends JSType> resultTypes, @NotNull JSTypeSource source) {
        if (resultTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(44);
        }
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(45);
        }
        JSType jSType = JSCompositeTypeFactory.getCommonType(resultTypes, source, true);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    @Contract(value="!null -> !null")
    public static JSType getRegularTypeOfLiteralType(@Nullable JSType valueType) {
        if ((valueType = JSTypeUtils.unwrapType(TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(valueType))) instanceof TypeScriptEnumLiteralType) {
            TypeScriptEnumLiteralType enumLiteralType = (TypeScriptEnumLiteralType)valueType;
            valueType = enumLiteralType.asNamedType();
        }
        if (valueType instanceof JSLiteralType && ((JSLiteralType)valueType).allowWidening()) {
            return ((JSLiteralType)valueType).copyWithAllowWidening(false);
        }
        return valueType;
    }

    @Nullable
    public static JSType createEnumValuesUnionType(@NotNull JSType elementType, @NotNull JSResolvedTypeInfo resolvedType) {
        Collection<TypeScriptEnum> enums;
        if (elementType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(47);
        }
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(48);
        }
        if ((enums = resolvedType.getDeclarationsOfType(TypeScriptEnum.class)).isEmpty()) {
            return null;
        }
        SmartList combinedTypeMembers = new SmartList();
        for (TypeScriptEnum enumDeclaration : enums) {
            JSField[] members;
            for (JSField member : members = enumDeclaration.getFields()) {
                String fieldName = member.getName();
                if (fieldName == null) {
                    fieldName = "";
                }
                combinedTypeMembers.add(TypeScriptEnumLiteralType.createNamedType(elementType.getTypeText(), fieldName, (PsiElement)member));
            }
        }
        return combinedTypeMembers.isEmpty() ? null : JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(elementType.getSourceElement(), true), (Collection<? extends JSType>)combinedTypeMembers);
    }

    @Nullable
    public static JSType getBestChoiceType(@Nullable JSType lType, @Nullable JSType rType, @NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(49);
        }
        boolean isTypeScript = DialectDetector.isTypeScript(context2);
        if (lType == null) {
            if (!isTypeScript) {
                return rType;
            }
            lType = JSAnyType.get(context2);
        }
        if (rType == null) {
            if (!isTypeScript) {
                return lType;
            }
            rType = JSAnyType.get(context2);
        }
        if (DialectDetector.isActionScript(context2) || isTypeScript && (rType instanceof JSAnyType || lType instanceof JSAnyType)) {
            return JSTypeUtils.getCommonType(lType, rType, DialectDetector.dialectOfElement(context2), true);
        }
        if (!isTypeScript) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context2, lType.isSourceStrict() && rType.isSourceStrict());
            return JSCompositeTypeFactory.createContextualUnionType(Arrays.asList(lType, rType), typeSource);
        }
        ProcessingContext processingContext = JSTypeComparingContextService.createSubtypingProcessingContext(context2);
        boolean firstAssignableToSecond = TypeScriptTypeRelations.isTypeAssignableTo(lType, rType, processingContext);
        boolean secondAssignableToFirst = TypeScriptTypeRelations.isTypeAssignableTo(rType, lType, processingContext);
        if (secondAssignableToFirst && !firstAssignableToSecond) {
            return lType;
        }
        if (firstAssignableToSecond && !secondAssignableToFirst) {
            return rType;
        }
        return TypeScriptTypeRelations.subtypeReduction(JSCompositeTypeFactory.getCommonType(lType, rType, JSTypeSourceFactory.createTypeSource(context2, true), true), context2);
    }

    public static boolean checkEnumTypeForPrimitive(@NotNull JSResolvedTypeInfo resolvedType, @NotNull Class<?> primitiveClass) {
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(50);
        }
        if (primitiveClass == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(51);
        }
        return primitiveClass.isInstance(resolvedType.getEnumConstValue().getExpandedJSType(null));
    }

    @NotNull
    public static ThreeState areExplicitAssignableByNames(@NotNull String lText, @NotNull String rText) {
        if (lText == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(52);
        }
        if (rText == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(53);
        }
        ThreeState threeState = switch (lText) {
            case "PromiseLike" -> {
                if ("Promise".equals(rText)) {
                    yield ThreeState.YES;
                }
                yield ThreeState.UNSURE;
            }
            case "ArrayLike", "ConcatArray" -> {
                if (JSCommonTypeNames.ARRAY_LIKE_CLASSES.contains(rText)) {
                    yield ThreeState.YES;
                }
                yield ThreeState.UNSURE;
            }
            case "Iterable" -> {
                if ("ReadonlyArray".equals(rText) || "Array".equals(rText)) {
                    yield ThreeState.YES;
                }
                yield ThreeState.UNSURE;
            }
            case "Array" -> {
                if ("ReadonlyArray".equals(rText)) {
                    yield ThreeState.NO;
                }
                yield ThreeState.UNSURE;
            }
            case "ReadonlyArray" -> {
                if ("Array".equals(rText)) {
                    yield ThreeState.YES;
                }
                yield ThreeState.UNSURE;
            }
            default -> ThreeState.UNSURE;
        };
        if (threeState == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(54);
        }
        return threeState;
    }

    @NotNull
    public static JSCacheableTypeTransformerResolvedIdBase instantiationTransformer(final boolean useConstraintType) {
        return new JSCacheableTypeTransformerResolvedIdBase(){

            @Override
            protected boolean isCompletelyIgnored(@NotNull JSType appliedType) {
                if (appliedType == null) {
                    1.$$$reportNull$$$0(0);
                }
                IndexedData data = JSTypeIndexerKt.getTypeIndexedData(appliedType);
                return data.getGenerics().isEmpty();
            }

            @Override
            @NotNull
            public JSType fun(@NotNull JSType t) {
                if (t == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSType jSType = t instanceof JSGenericParameterImpl ? (JSType)Objects.requireNonNullElse(useConstraintType ? ((JSGenericParameterImpl)t).getConstraintType() : null, JSAnyType.get(t.getSource())) : t;
                if (jSType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "appliedType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "t";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isCompletelyIgnored";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static boolean isTypeOrUnionOf(@Nullable JSType expressionJSType, @NotNull Class<? extends JSType> expectedType) {
        if (expectedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(55);
        }
        if (expressionJSType == null) {
            return false;
        }
        if (expectedType.isInstance(expressionJSType)) {
            return true;
        }
        return expressionJSType instanceof JSUnionType && ContainerUtil.and(((JSUnionType)expressionJSType).getTypes(), t -> expectedType.isInstance(t));
    }

    public static boolean isUnionWithUndefinedType(@Nullable JSType p) {
        return p instanceof JSUnionType && ((JSUnionType)p).getTypes().stream().anyMatch(t -> t instanceof JSUndefinedType);
    }

    public static int computeCrossProductUnionSize(@NotNull Collection<JSType> types2) {
        if (types2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(56);
        }
        int size = 1;
        for (JSType type2 : types2) {
            if (type2 instanceof JSUnionType) {
                try {
                    size = Math.multiplyExact(size, ((JSUnionType)type2).getTypes().size());
                    continue;
                }
                catch (ArithmeticException e) {
                    return -1;
                }
            }
            if (!(type2 instanceof TypeScriptNeverType)) continue;
            return 0;
        }
        return size;
    }

    public static boolean isPatternLiteralType(@Nullable JSType type2) {
        return type2 instanceof JSTemplateLiteralType && ContainerUtil.all(((JSTemplateLiteralType)type2).getTypes(), TypeScriptTypeRelations::isPatternLiteralPlaceholderType);
    }

    public static boolean isPatternLiteralPlaceholderType(@Nullable JSType type2) {
        if (type2 instanceof JSPrimitiveLiteralType) {
            return false;
        }
        return type2 instanceof JSStringType || type2 instanceof JSNumberType || type2 instanceof JSBigIntType || type2 instanceof JSAnyType;
    }

    public static <T extends JSType> boolean everyType(@NotNull List<T> types1, @NotNull List<T> types2, @NotNull BiFunction<? super T, ? super T, Boolean> comparer) {
        if (types1 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(57);
        }
        if (types2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(58);
        }
        if (comparer == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(59);
        }
        if (types1.size() != types2.size()) {
            return false;
        }
        for (int i = 0; i < types1.size(); ++i) {
            if (comparer.apply(types1.get(i), types2.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static JSType createTemplateLiteralConstraintType(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(60);
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType(source, JSNamedTypeFactory.createStringPrimitiveType(source), JSNamedTypeFactory.createBooleanPrimitiveType(source), JSNamedTypeFactory.createBigIntPrimitiveType(source), JSNamedTypeFactory.createNumberPrimitiveType(source), JSNamedTypeFactory.createUndefinedType(source), JSNamedTypeFactory.createNullType(source));
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(61);
        }
        return jSType;
    }

    public static boolean someType(@NotNull JSType type2, @NotNull Predicate<JSType> predicate) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(62);
        }
        if (predicate == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(63);
        }
        if (type2 instanceof JSUnionType) {
            return ContainerUtil.exists(((JSUnionType)type2).getTypes(), constituent -> TypeScriptTypeRelations.someType(constituent, predicate));
        }
        return predicate.test(type2);
    }

    public static boolean maybeTypeOfKind(@NotNull JSType type2, @NotNull Predicate<JSType> predicate) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(64);
        }
        if (predicate == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(65);
        }
        if (type2 instanceof JSUnionOrIntersectionType) {
            return ContainerUtil.exists(((JSUnionOrIntersectionType)type2).getTypes(), constituent -> TypeScriptTypeRelations.maybeTypeOfKind(constituent, predicate));
        }
        return predicate.test(type2);
    }

    public static boolean isStringLike(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(66);
        }
        return type2 instanceof JSStringType || type2 instanceof JSTemplateLiteralType || type2 instanceof TypeScriptStringMappingTypeImpl;
    }

    public static boolean isPrimitiveType(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(67);
        }
        return type2 instanceof JSPrimitiveType || JSTypeUtils.isEnumLiteral(type2) || JSTypeUtils.isNullOrUndefinedType(type2) || type2 instanceof JSVoidType;
    }

    public static boolean isObjectTypeWithInferableIndex(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(68);
        }
        if (!(type2 instanceof JSRecordType)) {
            return false;
        }
        JSRecordType recordType = (JSRecordType)type2;
        return JSRecordTypeImpl.isObjectType(recordType) && recordType.getCallSignatures().isEmpty();
    }

    @Contract(pure=true)
    public static boolean isObjectType(@Nullable JSType valueType) {
        return valueType instanceof JSNamedType || valueType instanceof JSRecordType || valueType instanceof JSFunctionTypeImpl || valueType instanceof JSTupleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 19, 21, 22, 23, 24, 26, 27, 28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 46, 54, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 25: 
            case 43: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 54: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedTypes";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTypes";
                break;
            }
            case 45: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lText";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rText";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types1";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparer";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "expandUnionOrIntersectionType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringMappingConstraintType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyOfConstraintType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateLiteralConstraintType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKeyOfTypes";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeBy";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "filterType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "areExplicitAssignableByNames";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateLiteralConstraintType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTypeDerivedFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "subtypeReduction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reduceBySubtyping";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isClassType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSubsetOfOneEnumLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasBaseType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubtypeOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCoercibleSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCoercibleTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mapType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 54: 
            case 61: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiableNonPrimitive";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiablePrimitive";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGenericIndexType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandUnionOrIntersectionType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getStringMappingConstraintType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateLiteralConstraintType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTypeBy";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "filterType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanUnionType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createEnumValuesUnionType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getBestChoiceType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumTypeForPrimitive";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "areExplicitAssignableByNames";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOrUnionOf";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "computeCrossProductUnionSize";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "everyType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateLiteralConstraintType";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "someType";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "maybeTypeOfKind";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isStringLike";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isObjectTypeWithInferableIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 19, 21, 22, 23, 24, 26, 27, 28, 29, 32, 33, 34, 35, 38, 39, 40, 41, 42, 46, 54, 61 -> new IllegalStateException(string);
        };
    }
}

