/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.resolve.complexity.JSNamedEvaluationTask;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyResolveResultsWithOverloadsType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReferenceType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSTypeWithDeclarations,
JSReferenceItem {
    @NotNull
    private final String myReferencedName;

    public JSReferenceType(@NotNull String referencedName, @NotNull JSReferenceExpression source) {
        if (referencedName == null) {
            JSReferenceType.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSReferenceType.$$$reportNull$$$0(1);
        }
        super((PsiElement)source);
        this.myReferencedName = referencedName;
    }

    public JSReferenceType(@NotNull String referencedName, @NotNull JSTypeSource source) {
        if (referencedName == null) {
            JSReferenceType.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSReferenceType.$$$reportNull$$$0(3);
        }
        super(source);
        this.myReferencedName = referencedName;
    }

    public JSReferenceType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSReferenceType.$$$reportNull$$$0(4);
        }
        if (inputStream == null) {
            JSReferenceType.$$$reportNull$$$0(5);
        }
        super(source);
        this.myReferencedName = JSTypeSerializer.readString(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSReferenceType.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myReferencedName, outputStream);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getSourceElement(), this.myReferencedName);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSReferenceType.$$$reportNull$$$0(7);
        }
        return Objects.equals(this.getSourceElement(), type2.getSourceElement()) && this.myReferencedName.equals(((JSReferenceType)type2).myReferencedName);
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String string = this.myReferencedName;
        if (string == null) {
            JSReferenceType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSReferenceType.$$$reportNull$$$0(9);
        }
        return new JSReferenceType(this.myReferencedName, source);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSReferenceType.$$$reportNull$$$0(10);
        }
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        final PsiElement sourceElement = this.getSourceElement();
        if (sourceElement == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSReferenceType.$$$reportNull$$$0(11);
            }
            return set;
        }
        if (this.matchesSourceElement()) {
            ResolveResult[] results = ((JSReferenceExpression)sourceElement).multiResolve(false);
            List<PsiElement> list2 = JSResolveResult.toElements(results);
            if (list2 == null) {
                JSReferenceType.$$$reportNull$$$0(12);
            }
            return list2;
        }
        JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Collection<PsiElement>> value = JSEvaluatorComplexityTracker.getDefaultInstance().runTask(1, new JSNamedEvaluationTask<Collection<PsiElement>>(){

            @Override
            public Collection<PsiElement> get() {
                PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(JSReferenceType.this.getReferenceName(), sourceElement);
                if (localResolve != null) {
                    return Collections.singleton(localResolve);
                }
                ResolveResult[] resolveResults = JSReferenceExpressionResolver.resolveGlobalReference(JSReferenceType.this.myReferencedName, sourceElement, false, false);
                return JSResolveResult.toElements(resolveResults);
            }

            public String toString() {
                return "Get declarations of JSReferenceType[" + JSReferenceType.this.myReferencedName + "]";
            }
        });
        Collection<PsiElement> declarations = value != null ? value.getValue() : null;
        Collection<Object> collection = declarations != null ? declarations : Collections.emptyList();
        if (collection == null) {
            JSReferenceType.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        PsiElement sourceElement;
        if (evaluateContext == null) {
            JSReferenceType.$$$reportNull$$$0(14);
        }
        if ((sourceElement = this.getSourceElement()) == null) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSReferenceType.$$$reportNull$$$0(15);
            }
            return jSEvaluationTaskList;
        }
        ArrayList<JSEvaluationTask> tasks = new ArrayList<JSEvaluationTask>();
        Collection<PsiElement> declarations = this.getDeclarations();
        if (JSReferenceType.addUnknownElementFromResolveResults(sourceElement, declarations)) {
            tasks.add(JSReferenceType.getTaskForUnknownElement(sourceElement, evaluateContext));
        }
        if (declarations.size() > JSReferenceExpressionResolver.MAX_RESULTS_COUNT_TO_KEEP) {
            JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
            if (jSEvaluationTask == null) {
                JSReferenceType.$$$reportNull$$$0(16);
            }
            return jSEvaluationTask;
        }
        boolean addedFromResolveResult = declarations.stream().anyMatch(e -> e instanceof JSNamedElement || e instanceof ES6ImportExportSpecifier);
        List resolvedElementsTasks = ContainerUtil.map(declarations, resolvedElement -> {
            JSNamespace namespace;
            ArrayList<JSEvaluationResultElement> result2 = new ArrayList<JSEvaluationResultElement>();
            if (resolvedElement instanceof JSNamedElement || resolvedElement instanceof ES6ImportExportSpecifier) {
                if (resolvedElement instanceof JSNamedElement) {
                    result2.add(JSEvaluationResultElement.fromType(this.getTypeFromResolvedElement((PsiElement)resolvedElement, evaluateContext), evaluateContext));
                } else {
                    List<ResolveResultSink.JSResolveResultForSymbolProcessor> specifierResolveResults = ResolveResultSink.resolveImportExportSpecifier(resolvedElement, null, null, 0);
                    if (specifierResolveResults != null) {
                        JSApplyResolveResultsWithOverloadsType resolveResultsType = new JSApplyResolveResultsWithOverloadsType(specifierResolveResults, JSTypeSourceFactory.createTypeSource(resolvedElement, true));
                        result2.add(JSEvaluationResultElement.fromType(resolveResultsType, evaluateContext));
                    }
                }
            }
            if (resolvedElement instanceof JSElementBase && (namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)resolvedElement, false)) != null) {
                result2.add(new JSEvaluationResultElement(namespace, true, evaluateContext));
            }
            return JSEvaluationTasks.fromList(result2);
        });
        JSEvaluationTask resolvedElementTask = JSEvaluationTasks.fromSet(resolvedElementsTasks, this.isJavaScript());
        tasks.add(resolvedElementTask);
        if (!addedFromResolveResult) {
            JSQualifiedNameImpl name = JSQualifiedNameImpl.create(this.getReferenceName(), null);
            JSNamespace namespace = JSNamedTypeFactory.createNamespace(name, JSContext.STATIC, sourceElement, false, true, false);
            tasks.add(JSEvaluationResultElement.fromAdditionalType(namespace, evaluateContext));
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
        if (jSEvaluationTask == null) {
            JSReferenceType.$$$reportNull$$$0(17);
        }
        return jSEvaluationTask;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSReferenceType.$$$reportNull$$$0(18);
        }
        if (builder2 == null) {
            JSReferenceType.$$$reportNull$$$0(19);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            builder2.append("#referenceType(" + this.myReferencedName + ")");
            return;
        }
        super.buildTypeTextImpl(format, builder2);
    }

    public static boolean addUnknownElementFromResolveResults(@NotNull PsiElement source, @NotNull Collection<PsiElement> elements) {
        if (source == null) {
            JSReferenceType.$$$reportNull$$$0(20);
        }
        if (elements == null) {
            JSReferenceType.$$$reportNull$$$0(21);
        }
        return DialectDetector.isJavaScript(source) && elements.size() > 1 && ContainerUtil.exists(elements, DialectDetector::isJavaScript);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12, 13, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSReferenceType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSReferenceType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addUnknownElementFromResolveResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 12, 13, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

