/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSRecursiveTypeUtil {
    public static final Key<Map<JSResolvedTypeId, Map<JSResolvedTypeId, Integer>>> ASSIGNABLE_KEY = Key.create((String)"already.compared.types");
    public static final Key<Map<JSResolvedTypeId, Map<JSResolvedTypeId, Integer>>> GENERICS_SUBSTITUTION = Key.create((String)"generics.compared.types");
    private static final int MAX_RECURSIVE_TYPE_COMPARING_DEPTH = 100;
    private static final int MAX_COMPARING_TO_SAME_TYPE = 2;
    private static final Logger LOG = Logger.getInstance(JSRecursiveTypeUtil.class);

    private static boolean startRecursiveTypesComparison(@NotNull JSType thisType, @NotNull JSType elementType, @NotNull Key<Map<JSResolvedTypeId, Map<JSResolvedTypeId, Integer>>> key2, @NotNull ProcessingContext processingContext) {
        if (thisType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(1);
        }
        if (key2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(2);
        }
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(3);
        }
        ProgressIndicatorProvider.checkCanceled();
        HashMap alreadyComparedTypes = (HashMap)processingContext.get(key2);
        if (alreadyComparedTypes == null) {
            alreadyComparedTypes = new HashMap();
            processingContext.put(key2, alreadyComparedTypes);
        } else if (alreadyComparedTypes.size() > 100) {
            return JSRecursiveTypeUtil.logOverflowError(thisType, elementType);
        }
        JSResolvedTypeId elementTypeId = elementType.getResolvedTypeId();
        Map typesComparedToThisCount = (Map)alreadyComparedTypes.get(thisType.getResolvedTypeId());
        if (typesComparedToThisCount == null) {
            HashMap<JSResolvedTypeId, Integer> map = new HashMap<JSResolvedTypeId, Integer>();
            map.put(elementTypeId, 1);
            alreadyComparedTypes.put(thisType.getResolvedTypeId(), map);
        } else {
            int newCount;
            if (typesComparedToThisCount.size() > 100) {
                return JSRecursiveTypeUtil.logOverflowError(thisType, elementType);
            }
            Integer alreadyCount = (Integer)typesComparedToThisCount.get(elementTypeId);
            int n = newCount = alreadyCount != null ? alreadyCount + 1 : 1;
            if (newCount > 2) {
                return false;
            }
            typesComparedToThisCount.put(elementTypeId, newCount);
        }
        return true;
    }

    private static boolean logOverflowError(@NotNull JSType lType, @NotNull JSType rType) {
        boolean shouldLogError;
        if (lType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(4);
        }
        if (rType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(5);
        }
        boolean bl = shouldLogError = ApplicationManager.getApplication().isUnitTestMode() || PluginManagerCore.isRunningFromSources();
        if (shouldLogError || LOG.isDebugEnabled()) {
            String message = "Too deep type comparing: " + lType + ", " + rType;
            if (shouldLogError) {
                LOG.error(message);
            } else {
                LOG.debug(message);
            }
        }
        return false;
    }

    public static boolean computeGenericRecursiveTypes(@NotNull JSType id1, @NotNull JSType id2, @NotNull JSType rType, @NotNull ProcessingContext context2, @NotNull CheckAssignable operation) {
        if (id1 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(6);
        }
        if (id2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(7);
        }
        if (rType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(9);
        }
        if (operation == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(10);
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(id1, id2, GENERICS_SUBSTITUTION, rType, context2, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean computeWithRecursiveTypes(@NotNull JSType id1, @NotNull JSType id2, @NotNull Key<Map<JSResolvedTypeId, Map<JSResolvedTypeId, Integer>>> key2, @NotNull JSType rType, @NotNull ProcessingContext context2, @NotNull CheckAssignable operation) {
        if (id1 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(11);
        }
        if (id2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(12);
        }
        if (key2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(13);
        }
        if (rType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(15);
        }
        if (operation == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(16);
        }
        if (!JSRecursiveTypeUtil.startRecursiveTypesComparison(id1, id2, key2, context2)) {
            if (JSEvaluatorComplexityTracker.isAssertOnPrevention() && key2 != ASSIGNABLE_KEY) {
                throw new StackOverflowPreventedException("Recursive type comparing " + id1 + ", " + id2);
            }
            return true;
        }
        try {
            boolean bl = operation.check(rType, context2);
            return bl;
        }
        finally {
            JSRecursiveTypeUtil.endRecursiveTypesComparison(id1, id2, key2, context2);
        }
    }

    private static void endRecursiveTypesComparison(@NotNull JSType thisType, @NotNull JSType elementType, @NotNull Key<Map<JSResolvedTypeId, Map<JSResolvedTypeId, Integer>>> key2, @NotNull ProcessingContext processingContext) {
        Map map;
        Map alreadyComparedTypes;
        if (thisType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(17);
        }
        if (elementType == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(18);
        }
        if (key2 == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(19);
        }
        if (processingContext == null) {
            JSRecursiveTypeUtil.$$$reportNull$$$0(20);
        }
        if ((alreadyComparedTypes = (Map)processingContext.get(key2)) != null && (map = (Map)alreadyComparedTypes.get(thisType.getResolvedTypeId())) != null) {
            JSResolvedTypeId elementTypeId = elementType.getResolvedTypeId();
            Integer count = (Integer)map.get(elementTypeId);
            if (count != null) {
                if (count > 1) {
                    map.put(elementTypeId, count - 1);
                } else {
                    map.remove(elementTypeId);
                }
            }
            if (map.isEmpty()) {
                alreadyComparedTypes.remove(thisType.getResolvedTypeId());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id1";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id2";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecursiveTypeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startRecursiveTypesComparison";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logOverflowError";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "computeGenericRecursiveTypes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "computeWithRecursiveTypes";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "endRecursiveTypesComparison";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface CheckAssignable {
        public boolean check(@NotNull JSType var1, @NotNull ProcessingContext var2);
    }
}

