/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSRecordMemberSourceFactory {
    @NotNull
    public static Collection<PsiElement> mergeCollectionToUnique(@NotNull Collection<PsiElement> elements, @NotNull Collection<PsiElement> extraElements) {
        if (elements == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(0);
        }
        if (extraElements == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(1);
        }
        if (elements.isEmpty()) {
            Collection<PsiElement> collection = extraElements;
            if (collection == null) {
                JSRecordMemberSourceFactory.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (extraElements.isEmpty()) {
            Collection<PsiElement> collection = elements;
            if (collection == null) {
                JSRecordMemberSourceFactory.$$$reportNull$$$0(3);
            }
            return collection;
        }
        ArrayList<PsiElement> newElements = new ArrayList<PsiElement>(elements);
        for (PsiElement element : extraElements) {
            if (newElements.contains(element)) continue;
            newElements.add(element);
        }
        ArrayList<PsiElement> arrayList = newElements;
        if (arrayList == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static JSRecordType.MemberSource createEmptySource() {
        EmptyMemberSource emptyMemberSource = EmptyMemberSource.INSTANCE;
        if (emptyMemberSource == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(5);
        }
        return emptyMemberSource;
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@Nullable PsiElement element) {
        return element == null ? EmptyMemberSource.INSTANCE : new SingleMemberSource(element);
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@Nullable PsiElement element, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
        if (memberSourceKind == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(6);
        }
        return element == null ? EmptyMemberSource.INSTANCE : new SingleMemberSource(element, memberSourceKind);
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@NotNull Collection<PsiElement> elements, @NotNull JSRecordType.MemberSourceKind memberSourceKind, boolean deduplicate) {
        List<PsiElement> elementsList;
        int size;
        if (elements == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(7);
        }
        if (memberSourceKind == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(8);
        }
        if ((size = (elementsList = elements instanceof List && (!deduplicate || elements.size() == 1) ? (List<PsiElement>)elements : elements.stream().distinct().collect(Collectors.toList())).size()) == 0) {
            EmptyMemberSource emptyMemberSource = EmptyMemberSource.INSTANCE;
            if (emptyMemberSource == null) {
                JSRecordMemberSourceFactory.$$$reportNull$$$0(9);
            }
            return emptyMemberSource;
        }
        if (size == 1) {
            return JSRecordMemberSourceFactory.createSource((PsiElement)elementsList.get(0), memberSourceKind);
        }
        return new MultipleMemberSource(elementsList, memberSourceKind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberSourceKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionToUnique";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptySource";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionToUnique";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 9 -> new IllegalStateException(string);
        };
    }

    public static final class EmptyMemberSource
    extends MemberSourceBase {
        public static final EmptyMemberSource INSTANCE = new EmptyMemberSource();

        public EmptyMemberSource() {
            super(JSRecordType.MemberSourceKind.Empty);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isUnion() {
            return false;
        }

        @Override
        public boolean isMerged() {
            return false;
        }

        @Override
        public boolean isReadonly() {
            return false;
        }

        @Override
        public boolean isOptional() {
            return false;
        }

        @Override
        public boolean hasSingleDocumentation() {
            return true;
        }

        @Override
        @Nullable
        public PsiElement getSingleElement() {
            return null;
        }

        @Override
        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                EmptyMemberSource.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        public  @NotNull JSRecordType.MemberSource copyWithKind( @NotNull JSRecordType.MemberSourceKind kind) {
            if (kind == null) {
                EmptyMemberSource.$$$reportNull$$$0(1);
            }
            EmptyMemberSource emptyMemberSource = this;
            if (emptyMemberSource == null) {
                EmptyMemberSource.$$$reportNull$$$0(2);
            }
            return emptyMemberSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$EmptyMemberSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$EmptyMemberSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyWithKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "copyWithKind";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class SingleMemberSource
    extends MemberSourceBase {
        @NotNull
        private final PsiElement mySourceElement;

        public SingleMemberSource(@NotNull PsiElement sourceElement) {
            if (sourceElement == null) {
                SingleMemberSource.$$$reportNull$$$0(0);
            }
            super(JSRecordType.MemberSourceKind.Identity);
            this.mySourceElement = sourceElement;
        }

        public SingleMemberSource(@NotNull PsiElement sourceElement, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
            if (sourceElement == null) {
                SingleMemberSource.$$$reportNull$$$0(1);
            }
            if (memberSourceKind == null) {
                SingleMemberSource.$$$reportNull$$$0(2);
            }
            super(memberSourceKind);
            this.mySourceElement = sourceElement;
        }

        @Override
        public PsiElement getSingleElement() {
            return this.mySourceElement;
        }

        @Override
        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List<PsiElement> list2 = Collections.singletonList(this.mySourceElement);
            if (list2 == null) {
                SingleMemberSource.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public  @NotNull JSRecordType.MemberSource copyWithKind( @NotNull JSRecordType.MemberSourceKind kind) {
            if (kind == null) {
                SingleMemberSource.$$$reportNull$$$0(4);
            }
            return new SingleMemberSource(this.mySourceElement, kind);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberSourceKind";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$SingleMemberSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$SingleMemberSource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "copyWithKind";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MultipleMemberSource
    extends MemberSourceBase {
        @NotNull
        private final List<PsiElement> mySourceElements;

        public MultipleMemberSource(@NotNull List<PsiElement> sourceElements, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
            if (sourceElements == null) {
                MultipleMemberSource.$$$reportNull$$$0(0);
            }
            if (memberSourceKind == null) {
                MultipleMemberSource.$$$reportNull$$$0(1);
            }
            super(memberSourceKind);
            this.mySourceElements = sourceElements;
        }

        @Override
        @Nullable
        public PsiElement getSingleElement() {
            return this.mySourceElements.size() == 0 ? null : this.mySourceElements.get(0);
        }

        @Override
        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List<PsiElement> list2 = this.mySourceElements;
            if (list2 == null) {
                MultipleMemberSource.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        public  @NotNull JSRecordType.MemberSource copyWithKind( @NotNull JSRecordType.MemberSourceKind kind) {
            if (kind == null) {
                MultipleMemberSource.$$$reportNull$$$0(3);
            }
            return new MultipleMemberSource(this.mySourceElements, kind);
        }

        @Override
        public boolean hasSingleDocumentation() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberSourceKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$MultipleMemberSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$MultipleMemberSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "copyWithKind";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class MemberSourceBase
    implements JSRecordType.MemberSource {
        private final JSRecordType.MemberSourceKind myMemberSourceKind;

        MemberSourceBase(JSRecordType.MemberSourceKind memberSourceKind) {
            this.myMemberSourceKind = memberSourceKind;
        }

        @Override
        public  @NotNull JSRecordType.MemberSourceKind getSourceKind() {
            JSRecordType.MemberSourceKind memberSourceKind = this.myMemberSourceKind;
            if (memberSourceKind == null) {
                MemberSourceBase.$$$reportNull$$$0(0);
            }
            return memberSourceKind;
        }

        @Override
        public boolean isOptional() {
            JSRecordType.MemberSourceKind kind = this.myMemberSourceKind;
            if (kind.isForceOptional()) {
                return true;
            }
            if (kind.isForceNonOptional()) {
                return false;
            }
            return ContainerUtil.and(this.getAllSourceElements(), MemberSourceBase::isOptionalPredicate);
        }

        private static boolean isOptionalPredicate(PsiElement e) {
            return e instanceof JSOptionalOwner && ((JSOptionalOwner)e).isOptional();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$MemberSourceBase", "getSourceKind"));
        }
    }
}

